/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.attribute;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.attribute.DuplicateDataCheckParam;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class DuplicateDataCheckTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DuplicateDataCheckParam param = (DuplicateDataCheckParam)toolParam;
        if (param.isBatch() && StrUtil.isEmpty((CharSequence)batchInputData.getDsKey())) {
            ToolHelper.callbackDir(batchInputData, batchOutputData, oneDataCallback, param, param.getVectorFormats());
        } else {
            Assert.state((boolean)VectorFileUtil.exactlyMatchAny((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef");
            ToolHelper.callbackOne(batchInputData, batchOutputData, param, oneDataCallback);
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, true);
        return ToolHelper.buildExecuteParam(inputData, outputData, toolParam, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, true);
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            IFeatureWorkspace sourceWorkspace = workspaceDTO.getSourceWorkspace();
            DuplicateDataCheckParam param = (DuplicateDataCheckParam)toolParam;
            this.invokeExcuteLog("\u6837\u4f8b\u6570\u636e\uff1a" + param.getSamplePath());
            String layers = param.getLayers();
            JSONObject layersObj = JSONUtil.parseObj((String)param.getLayers());
            this.invokeExcuteLog("\u6570\u91cf\uff1a" + layersObj.size());
            for (String layer : layersObj.keySet()) {
                JSONArray fieldsArray = layersObj.getJSONArray((Object)layer);
                ITable table = sourceWorkspace.openTable(layer);
                if (table == null) {
                    this.invokeExcuteLog(sourceWorkspace.getConnectionString() + " \u65e0\u9009\u5b9a\u56fe\u5c42 : " + layer, TaskLogLevelEnum.Error);
                    continue;
                }
                this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + layer);
                Set<String> fields = fieldsArray.stream().map(String::valueOf).collect(Collectors.toSet());
                this.duplicateDataCheck(param, table, fields);
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
            ToolHelper.copyWhenFlowLast(inputData, outputData);
        }
        return executeResult;
    }

    private void duplicateDataCheck(DuplicateDataCheckParam rangeCheckParam, ITable table, Set<String> fields) {
        ICursor rowCursor = null;
        try {
            rowCursor = table.searchRow(null);
            IRow row = rowCursor.nextRow();
            HashMap<String, Map> fieldMap = new HashMap<String, Map>();
            while (row != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IFields iFields = row.getFields();
                for (String string : fields) {
                    IField field = iFields.findField(string);
                    if (field == null) {
                        this.invokeExcuteLog("\u56fe\u5c42 " + table.getName() + " \u65e0\u9009\u5b9a\u5b57\u6bb5 : " + string, TaskLogLevelEnum.Error);
                        continue;
                    }
                    Object value = row.getValue(field.getName());
                    if (value == null) continue;
                    String objectId = row.getObjectId().toString();
                    Map valueIdMap = fieldMap.getOrDefault(string, new HashMap());
                    Set ids = valueIdMap.getOrDefault(String.valueOf(value), new TreeSet());
                    ids.add(objectId);
                    valueIdMap.put(String.valueOf(value), ids);
                    fieldMap.put(string, valueIdMap);
                }
                row = rowCursor.nextRow();
            }
            boolean hasDup = false;
            for (Map.Entry entry : fieldMap.entrySet()) {
                String f = (String)entry.getKey();
                Map dataMap = (Map)entry.getValue();
                for (Map.Entry e : dataMap.entrySet()) {
                    String value = (String)e.getKey();
                    Set ids = (Set)e.getValue();
                    if (ids.size() <= 1) continue;
                    this.invokeExcuteLog("\u8981\u7d20\u7c7b " + table.getName() + " \u5b57\u6bb5 " + f + " \u53d1\u73b0\u91cd\u590d\u6570\u636e, \u503c\u4e3a : " + value + ", \u5171 " + ids.size() + "\u6761", TaskLogLevelEnum.Warning);
                    this.invokeExcuteLog("oid \u5982\u4e0b : ", TaskLogLevelEnum.Warning);
                    this.hasCheckError = true;
                    int step = 10;
                    ArrayList idList = new ArrayList(ids);
                    int i = 0;
                    while (i * step < idList.size()) {
                        if ((i + 1) * step >= idList.size()) {
                            this.invokeExcuteLog(idList.subList(i * step, idList.size()).toString(), TaskLogLevelEnum.Warning);
                        } else {
                            this.invokeExcuteLog(idList.subList(i * step, (i + 1) * step).toString(), TaskLogLevelEnum.Warning);
                        }
                        ++i;
                    }
                    hasDup = true;
                }
            }
            if (!hasDup) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + table.getName() + " \u91cd\u590d\u68c0\u67e5\u901a\u8fc7!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rowCursor != null) {
                rowCursor.release();
            }
        }
    }
}

