/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.clean.attribute;

import cn.hutool.core.lang.func.Supplier4;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.clean.attribute.IllegalCharacterCheckParam;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.util.VectorCheckUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class IllegalCharacterCheckTool
extends ToolBase {
    private boolean hasCheckError = false;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        IllegalCharacterCheckParam param = (IllegalCharacterCheckParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(batchInputData, batchOutputData, !param.isDeleteIllegalCharacter());
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, param, vectorReadWriteEnum);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        IllegalCharacterCheckParam param = (IllegalCharacterCheckParam)toolParam;
        VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isDeleteIllegalCharacter());
        return ToolHelper.buildExecuteParam(inputData, outputData, param, vectorReadWriteEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            IllegalCharacterCheckParam param = (IllegalCharacterCheckParam)toolParam;
            VectorReadWriteEnum vectorReadWriteEnum = VectorCheckUtil.readWriteModel(inputData, outputData, !param.isDeleteIllegalCharacter());
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, vectorReadWriteEnum);
            switch (vectorReadWriteEnum) {
                case D: 
                case F: {
                    ToolHelper.handleTable(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.illegalCharacterCheck((IllegalCharacterCheckParam)p, (ITable)f));
                    ToolHelper.copyWhenFlowLast(inputData, outputData);
                    break;
                }
                case D2F: 
                case F2D: 
                case F2F: 
                case D2D: {
                    ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(f, w, p, n) -> this.illegalCharacterCheck((IFeatureClass)f, (FeatureClassMeta)w, (IllegalCharacterCheckParam)p, (String)n)));
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
                }
            }
            executeResult.setSuccess(Boolean.valueOf(!this.hasCheckError));
            executeResult.setOutDataParam(outputData);
        }
        return executeResult;
    }

    private void illegalCharacterCheck(IllegalCharacterCheckParam param, ITable table) {
        table.getWorkspace().beginTransaction();
        this.invokeExcuteLog("\u5f00\u59cb\u68c0\u67e5\uff1a" + table.getName());
        ICursor rowCursor = null;
        boolean hasIc = false;
        try {
            rowCursor = table.searchRow(null);
            IRow row = rowCursor.nextRow();
            List<String> illegalCharacters = ToolHelper.codes(param.getDictionaryKey());
            Assert.state((!illegalCharacters.isEmpty() ? 1 : 0) != 0, (String)"\u975e\u6cd5\u5b57\u7b26\u5b57\u5178\u4e3a\u7a7a");
            String regex = this.illegalCharacterRegex(illegalCharacters);
            if (regex.contains("-")) {
                regex = StrUtil.replace((CharSequence)regex, (CharSequence)"-", (CharSequence)"\\-", (boolean)false);
            }
            while (row != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                for (IField field : row.getFields()) {
                    String value;
                    if (field.getFieldType() != FieldType.String || !this.illegal(value = String.valueOf(row.getValue(field.getName())), regex)) continue;
                    hasIc = true;
                    this.hasCheckError = true;
                    String s = StrUtil.getContainsStr((CharSequence)value, (CharSequence[])illegalCharacters.toArray(new String[0]));
                    this.invokeExcuteLog("\u53d1\u73b0\u975e\u6cd5\u5b57\u7b26 " + s + ", \u8981\u7d20\u7c7b : " + table.getName() + ", oid : " + row.getObjectId().toString() + ", \u5b57\u6bb5 : " + field.getName(), TaskLogLevelEnum.Warning);
                }
                row = rowCursor.nextRow();
            }
            if (!hasIc) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + table.getName() + " \u65e0\u975e\u6cd5\u5b57\u7b26!");
            }
            table.getWorkspace().commitTransaction();
        }
        catch (Exception e) {
            table.getWorkspace().rollbackTransaction();
            throw new RuntimeException(e);
        }
        finally {
            if (rowCursor != null) {
                rowCursor.release();
            }
        }
    }

    private boolean illegal(String value, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    private String illegalCharacterRegex(List<String> illegalCharacters) {
        return String.format("[%s]", illegalCharacters.stream().map(ReUtil::escape).collect(Collectors.joining()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean illegalCharacterCheck(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, IllegalCharacterCheckParam param, String outputName) {
        IFeatureWorkspace targetWorkspace = featureClassMeta.getWorkspace();
        IFeatureCursor insertCursor = null;
        IFeatureCursor searchCursor = null;
        try {
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            targetWorkspace.beginTransaction();
            insertCursor = targetFeatureClass.batchInsertFeature();
            searchCursor = srcFeatureClass.searchFeature(null);
            IFeature feature = searchCursor.nextFeature();
            boolean hasIc = false;
            List<String> illegalCharacters = ToolHelper.codes(param.getDictionaryKey());
            Assert.state((!illegalCharacters.isEmpty() ? 1 : 0) != 0, (String)"\u975e\u6cd5\u5b57\u7b26\u5b57\u5178\u4e3a\u7a7a");
            String regex = this.illegalCharacterRegex(illegalCharacters);
            if (regex.contains("-")) {
                regex = StrUtil.replace((CharSequence)regex, (CharSequence)"-", (CharSequence)"\\-", (boolean)false);
            }
            while (feature != null) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                IFeature newFeature = targetFeatureClass.createFeature();
                newFeature.setGeometry(feature.getGeometry());
                for (IField ifield : newFeature.getFields()) {
                    int srcIndex = feature.getFields().findFieldIndex(ifield.getName());
                    if (srcIndex < 0) continue;
                    IField field = feature.getFields().getField(srcIndex);
                    Object value = feature.getValue(srcIndex);
                    if (field.getFieldType() != FieldType.String) {
                        newFeature.setValue(ifield.getName(), value);
                        continue;
                    }
                    String valueStr = String.valueOf(value);
                    if (this.illegal(valueStr, regex)) {
                        hasIc = true;
                        if (param.isDeleteIllegalCharacter()) {
                            valueStr = valueStr.replaceAll(regex, "");
                            newFeature.setValue(ifield.getName(), (Object)valueStr);
                            this.invokeExcuteLog("\u8981\u7d20\u7c7b : " + srcFeatureClass.getName() + ", oid : " + feature.getObjectId().toString() + ", \u5b57\u6bb5 : " + ifield.getName() + " \u5220\u9664\u975e\u6cd5\u5b57\u7b26", TaskLogLevelEnum.Warning);
                            continue;
                        }
                        String s = StrUtil.getContainsStr((CharSequence)valueStr, (CharSequence[])illegalCharacters.toArray(new String[0]));
                        this.invokeExcuteLog("\u53d1\u73b0\u975e\u6cd5\u5b57\u7b26 [" + s + "], \u56fe\u5c42 : " + srcFeatureClass.getName() + ", oid : " + feature.getObjectId().toString() + ", \u5b57\u6bb5 : " + ifield.getName(), TaskLogLevelEnum.Warning);
                        continue;
                    }
                    newFeature.setValue(ifield.getName(), (Object)valueStr);
                }
                insertCursor.insertFeature(newFeature);
                feature = searchCursor.nextFeature();
            }
            if (!hasIc) {
                this.invokeExcuteLog("\u56fe\u5c42 : " + srcFeatureClass.getName() + " \u65e0\u975e\u6cd5\u5b57\u7b26!");
            }
            targetWorkspace.commitTransaction();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u975e\u6cd5\u5b57\u7b26\u68c0\u67e5\u5931\u8d25", e);
            targetWorkspace.rollbackTransaction();
            boolean bl = false;
            return bl;
        }
        finally {
            if (searchCursor != null) {
                searchCursor.release();
            }
            if (insertCursor != null) {
                insertCursor.release();
            }
        }
    }
}

