/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.srs;

import cn.hutool.core.lang.func.Supplier4;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.srs.VectorSpatialRefTransferParam;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class VectorSpatialRefTransferTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        VectorSpatialRefTransferParam param = (VectorSpatialRefTransferParam)toolParam;
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.F2F);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorSpatialRefTransferParam param = (VectorSpatialRefTransferParam)toolParam;
        return ToolHelper.buildExecuteParam(inputData, outputData, param, VectorReadWriteEnum.F2F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        ToolFeatureWorkspaceDTO workspaceDTO = null;
        try {
            VectorSpatialRefTransferParam param = (VectorSpatialRefTransferParam)toolParam;
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, VectorReadWriteEnum.F2F);
            ToolHelper.handleAndSaveFeatureClass(inputData.getName(), outputData.getName(), param, workspaceDTO.getSourceWorkspace(), workspaceDTO.getTargetWorkspace(), (Supplier4<Boolean, IFeatureClass, FeatureClassMeta, IToolParam, String>)((Supplier4)(srcFeatureClass, featureClassMeta, iToolParam, outputName) -> this.srsTransfer((IFeatureClass)srcFeatureClass, (FeatureClassMeta)featureClassMeta, (VectorSpatialRefTransferParam)iToolParam, (String)outputName)));
            executeResult.setSuccess(Boolean.valueOf(true));
            executeResult.setOutDataParam(outputData);
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog("\u7a7a\u95f4\u53c2\u8003\u8f6c\u6362\u5931\u8d25", e);
        }
        finally {
            if (workspaceDTO != null) {
                workspaceDTO.close();
            }
            ToolHelper.copyWhenFlowLast(inputData, outputData);
        }
        return executeResult;
    }

    private Boolean srsTransfer(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, VectorSpatialRefTransferParam param, String outputName) {
        try {
            ISpatialReferenceSystem srs = StrUtil.isNotEmpty((CharSequence)param.getOutputWkt()) ? SpatialReferenceSystemFunc.createSpatialReference((String)param.getOutputWkt()) : SpatialReferenceSystemFunc.createSpatialReference((int)param.getOutputSrid());
            Assert.notNull((Object)srs, (String)("srid\u6709\u8bef : " + param.getOutputSrid()));
            featureClassMeta.setSrs(srs);
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setCancelCallback(() -> ((VectorSpatialRefTransferTool)this).isAborted());
            TransferResult transferResult = vectorDataTransfer.copyFeature(srcFeatureClass, targetFeatureClass, null);
            Assert.state((boolean)transferResult.isSuccess(), (String)transferResult.getErrorMessage());
            return true;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u7a7a\u95f4\u53c2\u8003\u8f6c\u6362\u5931\u8d25", e);
            return false;
        }
    }
}

