/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.grid.extent.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geoway.dgt.geodata.annosimplify.grid.Grid;
import com.geoway.dgt.geodata.annosimplify.grid.extent.Extent;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.grid.extent.impl.ExtentImpl;
import java.util.LinkedList;

public class GridExtentImpl
extends ExtentImpl
implements GridExtent {
    protected int x;
    protected int y;
    protected int level;
    @JsonIgnore
    protected Grid grid;
    @JsonIgnore
    public double resolution;

    public GridExtentImpl(double left, double bottom, double right, double top, int level, Grid grid, int x, int y) {
        super(left, bottom, right, top);
        this.x = x;
        this.y = y;
        this.level = level;
        this.resolution = grid.getResolution(level);
        this.grid = grid;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public int getL() {
        return this.grid.getBase();
    }

    @Override
    public Extent getExtentByBuffer(int percent) {
        double buffer = this.getBuffer(percent);
        double left = this.left - buffer;
        double bottom = this.bottom - buffer;
        double right = this.right + buffer;
        double top = this.top + buffer;
        return new ExtentImpl(left, bottom, right, top);
    }

    @Override
    public GridExtent[] getDown(int downLevel) {
        if (downLevel <= 0) {
            return new GridExtent[]{this};
        }
        LinkedList<GridExtent> list = new LinkedList<GridExtent>();
        int endLevel = this.level + downLevel;
        this.buildDownArray(this, list, endLevel);
        list.push(this);
        return list.toArray(new GridExtent[list.size()]);
    }

    private void buildDownArray(GridExtent extent, LinkedList<GridExtent> list, int endLevel) {
        GridExtent extent3;
        GridExtent extent2;
        GridExtent extent1;
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = this.grid.getExtent(l, x * 2, y * 2);
        if (extent0.getLevel() < endLevel) {
            this.buildDownArray(extent0, list, endLevel);
        }
        if ((extent1 = this.grid.getExtent(l, x * 2 + 1, y * 2)).getLevel() < endLevel) {
            this.buildDownArray(extent1, list, endLevel);
        }
        if ((extent2 = this.grid.getExtent(l, x * 2, y * 2 + 1)).getLevel() < endLevel) {
            this.buildDownArray(extent2, list, endLevel);
        }
        if ((extent3 = this.grid.getExtent(l, x * 2 + 1, y * 2 + 1)).getLevel() < endLevel) {
            this.buildDownArray(extent3, list, endLevel);
        }
        list.push(extent0);
        list.push(extent1);
        list.push(extent2);
        list.push(extent3);
    }

    @Override
    public GridExtent[] getChildren() {
        LinkedList<GridExtent> list = new LinkedList<GridExtent>();
        this.buildDownArray(this, list, this.level + 1);
        return list.toArray(new GridExtent[4]);
    }

    public String toString() {
        return "x = " + this.x + " y = " + this.y + " level = " + this.level;
    }

    @Override
    public String toJSON() {
        return this.level + "_" + this.x + "_" + this.y;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getResolution() {
        return this.resolution;
    }

    @Override
    public Grid getGrid() {
        return this.grid;
    }

    @Override
    public double getBuffer(int percent) {
        double buffer = (double)this.grid.getBase() * this.resolution * (double)percent / 100.0;
        return buffer;
    }
}

