/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.srs;

import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.srs.VectorSpatialReferenceCheckParam;
import java.util.function.Consumer;

public class VectorSpatialReferenceCheckTool
extends ToolBase {
    private Boolean allSuccess = true;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        batchOutputData = new DataParam();
        ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.F);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try (ToolFeatureWorkspaceDTO workspaceDTO = null;){
            VectorSpatialReferenceCheckParam param = (VectorSpatialReferenceCheckParam)executeParam;
            workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, VectorReadWriteEnum.F);
            ToolHelper.handleFeatureClass(inputData.getName(), param, workspaceDTO.getSourceWorkspace(), (p, f) -> this.srsCheck((VectorSpatialReferenceCheckParam)p, (IFeatureClass)f));
            executeResult.setOutDataParam(outputData);
            executeResult.setSuccess(this.allSuccess);
        }
        return executeResult;
    }

    private void srsCheck(VectorSpatialReferenceCheckParam param, IFeatureClass srcFeatureClass) {
        boolean checkResult;
        ISpatialReferenceSystem srs = srcFeatureClass.getSpatialReferenceSystem();
        this.invokeExcuteLog(srcFeatureClass.getName() + "\u7a7a\u95f4\u53c2\u8003\uff1a" + srs.getName());
        boolean bl = checkResult = srs.getSrid() == param.getSrid().intValue();
        if (!checkResult) {
            this.allSuccess = false;
            this.invokeExcuteLog("\u6570\u636e\u7a7a\u95f4\u53c2\u8003\u4e0e\u6807\u51c6\u7a7a\u95f4\u53c2\u8003\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
        }
    }
}

