/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.transfer;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.transfer.VectorFormatTransferParam;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.gdal.ogr.Geometry;
import org.springframework.util.Assert;

public class VectorFormatTransferTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        VectorFormatTransferParam param = (VectorFormatTransferParam)toolParam;
        if (StringUtil.isEmpty((String)batchInputData.getDsKey())) {
            ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.F2F, param.getSourceFormat(), param.getTargetFormat());
        } else {
            ToolHelper.strip(batchInputData, batchOutputData, oneDataCallback, toolParam, VectorReadWriteEnum.D2F, param.getSourceFormat(), param.getTargetFormat());
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        VectorFormatTransferParam param = (VectorFormatTransferParam)toolParam;
        return ToolHelper.buildExecuteParam(inputData, outputData, param, VectorReadWriteEnum.F2F, param.getSourceFormat(), param.getTargetFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        ToolFeatureWorkspaceDTO workspace = null;
        int totalCount = 0;
        int successCount = 0;
        int failCount = 0;
        boolean success = true;
        String inputFile = inputDataParam.getFilePath();
        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362\uff1a" + inputFile);
        try {
            ArrayList<IGeoDataset> srcDatasets;
            IFeatureWorkspace outputWorkspace;
            IFeatureWorkspace inputWorkspace;
            VectorFormatTransferParam param = (VectorFormatTransferParam)toolParam;
            FileUtil.mkParentDirs((String)outputDataParam.getFilePath());
            if (param.getSourceFormat() == VectorFormatEnum.Mapgis) {
                this.convertMapgis(inputDataParam, outputDataParam, toolParam, executeResult);
                executeResult.setOutDataParam(outputDataParam);
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            if (StringUtil.isEmpty((String)inputDataParam.getDsKey())) {
                workspace = ToolHelper.getWorkspace(inputDataParam, outputDataParam, VectorReadWriteEnum.F2F);
                inputWorkspace = workspace.getSourceWorkspace();
                outputWorkspace = workspace.getTargetWorkspace();
                srcDatasets = inputWorkspace.getDatasets();
            } else {
                String[] datasetNames;
                workspace = ToolHelper.getWorkspace(inputDataParam, outputDataParam, VectorReadWriteEnum.D2F);
                inputWorkspace = workspace.getSourceWorkspace();
                outputWorkspace = workspace.getTargetWorkspace();
                srcDatasets = new ArrayList<IGeoDataset>();
                for (String datasetName : datasetNames = inputDataParam.getName().split(",")) {
                    IGeoDataset geoDataset = inputWorkspace.openGeoDataset(datasetName);
                    srcDatasets.add(geoDataset);
                }
            }
            block12: for (IGeoDataset dataset : srcDatasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                Fields newFields = new Fields();
                switch (geoDatasetType) {
                    case FeatureClass: {
                        IFeatureClass srcFeatureClass = (IFeatureClass)dataset;
                        FeatureClassMeta featureClassMeta = new FeatureClassMeta(outputWorkspace, null);
                        ++totalCount;
                        TransferResult transferResult = this.transFerFeatureClass(srcFeatureClass, featureClassMeta, () -> ((VectorFormatTransferTool)this).isAborted());
                        if (transferResult.isSuccess()) {
                            ++successCount;
                        } else {
                            ++failCount;
                        }
                        this.invokeExcuteLog(String.format("%s\u8f6c\u6362%s\uff0c\u5171%d\u4e2a\uff0c\u6210\u529f%d\u4e2a", srcFeatureClass.getName(), transferResult.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25" + transferResult.getErrorMessage(), transferResult.getTotalCount(), transferResult.getSuccessCount()));
                        break;
                    }
                    case FeatureDataset: {
                        TransferResult transferResult;
                        IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                        List subsets = featureDataset.getSubsets();
                        for (IGeoDataset subset : subsets) {
                            IFeatureClass subFeatureClass = (IFeatureClass)subset;
                            FeatureClassMeta position = new FeatureClassMeta(outputWorkspace, featureDataset.getName());
                            ++totalCount;
                            transferResult = this.transFerFeatureClass(subFeatureClass, position, () -> ((VectorFormatTransferTool)this).isAborted());
                            if (transferResult.isSuccess()) {
                                ++successCount;
                            } else {
                                ++failCount;
                            }
                            this.invokeExcuteLog(String.format("%s\u8f6c\u6362%s\uff0c\u5171%d\u4e2a\uff0c\u6210\u529f%d\u4e2a", subFeatureClass.getName(), transferResult.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25" + transferResult.getErrorMessage(), transferResult.getTotalCount(), transferResult.getSuccessCount()));
                        }
                        continue block12;
                    }
                    case Table: {
                        ITable srcTable = (ITable)dataset;
                        IntStream.range(0, srcTable.getFields().getFieldCount()).mapToObj(i -> srcTable.getFields().getField(i).clone()).forEach(arg_0 -> ((IFields)newFields).addField(arg_0));
                        ITable targetTable = outputWorkspace.createTable(srcTable.getName(), (IFields)newFields);
                        if (targetTable == null) {
                            this.invokeExcuteLog(srcTable.getName() + "\u521b\u5efa\u8868\u5931\u8d25\uff01");
                            ++failCount;
                            continue block12;
                        }
                        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362" + srcTable.getName());
                        ++totalCount;
                        VectorDataTransfer vt = new VectorDataTransfer();
                        vt.setCancelCallback(() -> ((VectorFormatTransferTool)this).isAborted());
                        TransferResult transferResult = vt.copyTable(srcTable, targetTable, null);
                        if (transferResult.isSuccess()) {
                            ++successCount;
                        } else {
                            ++failCount;
                        }
                        this.invokeExcuteLog(String.format("%s\u8f6c\u6362%s\uff0c\u5171%d\u4e2a\uff0c\u6210\u529f%d\u4e2a", srcTable.getName(), transferResult.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25" + transferResult.getErrorMessage(), transferResult.getTotalCount(), transferResult.getSuccessCount()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b : " + geoDatasetType);
                    }
                }
            }
            executeResult.setSuccess(Boolean.valueOf(failCount == 0 && totalCount == successCount));
            executeResult.setOutDataParam(outputDataParam);
            this.invokeExcuteLog(String.format("\u5171%d\u4e2a\u56fe\u5c42\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
        }
        catch (Exception e) {
            this.log.error(inputFile + " \u8f6c\u6362\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("\u8f6c\u6362\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        finally {
            if (workspace != null) {
                workspace.close();
            }
        }
        return executeResult;
    }

    private TransferResult transFerFeatureClass(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, Supplier<Boolean> cancelCallback) {
        this.invokeExcuteLog("\u5f00\u59cb\u8f6c\u6362" + srcFeatureClass.getName());
        VectorDataTransfer vt = new VectorDataTransfer();
        vt.setCancelCallback(cancelCallback);
        IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, null);
        Assert.notNull((Object)targetFeatureClass, (String)"\u521b\u5efa\u8981\u7d20\u7c7b\u5931\u8d25!");
        Assert.state((boolean)targetFeatureClass.createSpatialIndex(), (String)"\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15\u5931\u8d25");
        return vt.copyFeature(srcFeatureClass, targetFeatureClass, null);
    }

    private void convertMapgis(DataParam inputDataParam, DataParam outputDataParam, IToolParam toolParam, ExecuteResult executeResult) {
        String inputFile = inputDataParam.getFilePath();
        String outputFile = outputDataParam.getFilePath();
        String extension = FileUtil.getSuffix((String)inputFile);
        if (extension.equalsIgnoreCase("wat")) {
            this.convertWat(inputFile, outputFile, executeResult);
        } else if (extension.equalsIgnoreCase("wal")) {
            this.convertWal(inputFile, outputFile, executeResult);
        } else if (extension.equalsIgnoreCase("wap")) {
            this.convertWap(inputFile, outputFile, executeResult);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f:" + extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertWat(String watFile, String targetFile, ExecuteResult executeResult) {
        IFeatureWorkspace outputWorkspace = ToolHelper.getFileWorkspace(targetFile);
        int lineNum = 0;
        try {
            Fields fields = new Fields();
            fields.addField((IField)new Field("FID", "FID", FieldType.OID));
            fields.addField((IField)new GeometryField("Shape", "Shape", GeometryType.Point, null, CoordinateType.XY));
            String name = FileUtil.getPrefix((String)watFile);
            IFeatureClass featureClass = outputWorkspace.createFeatureClass(name, (IFields)fields, FeatureType.Point, "Shape", null);
            if (featureClass == null) {
                throw new RuntimeException(name + " \u56fe\u5c42\u521b\u5efa\u5931\u8d25");
            }
            outputWorkspace.beginTransaction();
            IFeatureCursor cursor = featureClass.insertFeature();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(watFile), Charset.forName("GBK")));){
                String line = br.readLine();
                line = br.readLine();
                int featureCount = 0;
                while ((line = br.readLine()) != null) {
                    ++lineNum;
                    if ((line = line.trim()).isEmpty()) continue;
                    String[] xy = line.split(",");
                    double x = Double.parseDouble(xy[0]);
                    double y = Double.parseDouble(xy[1]);
                    IGeometry geometry = GeometryFunc.createGeometry((String)String.format("POINT(%s %s)", x, y));
                    IFeature feature = featureClass.createFeature();
                    feature.setGeometry(geometry);
                    cursor.insertFeature(feature);
                    ++featureCount;
                }
                executeResult.setSuccess(Boolean.valueOf(true));
                this.invokeExcuteLog(String.format("%s\u8f6c\u6210\u5b8c\u6210\uff0c\u5171%d\u4e2a", name, featureCount));
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
        }
        catch (Exception e) {
            if (lineNum > 0) {
                this.invokeExcuteLog(String.format("%s \u7b2c%d\u884c\u5904\u7406\u5931\u8d25", watFile, lineNum));
            }
            this.log.error(watFile + " \u5904\u7406\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("%s \u8f6c\u6362\u5931\u8d25:%s", watFile, e.getMessage()));
        }
        finally {
            if (outputWorkspace != null) {
                this.stopEdit(outputWorkspace, true);
                outputWorkspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertWal(String walFile, String targetFile, ExecuteResult executeResult) {
        IFeatureWorkspace outputWorkspace = ToolHelper.getFileWorkspace(targetFile);
        int lineNum = 0;
        try {
            Fields fields = new Fields();
            fields.addField((IField)new Field("FID", "FID", FieldType.OID));
            fields.addField((IField)new GeometryField("Shape", "Shape", GeometryType.Polyline, null, CoordinateType.XY));
            String name = FileUtil.getPrefix((String)walFile);
            IFeatureClass featureClass = outputWorkspace.createFeatureClass(name, (IFields)fields, FeatureType.Polyline, "Shape", null);
            if (featureClass == null) {
                throw new RuntimeException(name + " \u56fe\u5c42\u521b\u5efa\u5931\u8d25");
            }
            outputWorkspace.beginTransaction();
            IFeatureCursor cursor = featureClass.insertFeature();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(walFile), Charset.forName("GBK")));){
                String line = br.readLine();
                line = br.readLine();
                int featureCount = 0;
                while ((line = br.readLine()) != null) {
                    ++lineNum;
                    if ((line = line.trim()).isEmpty() || !line.startsWith("1,")) continue;
                    line = br.readLine();
                    ++lineNum;
                    int pointCount = Integer.parseInt(line);
                    Geometry geoLine = new Geometry(2);
                    for (int i = 0; i < pointCount; ++i) {
                        line = br.readLine();
                        ++lineNum;
                        String[] xy = line.split(",");
                        double x = Double.parseDouble(xy[0]);
                        double y = Double.parseDouble(xy[1]);
                        geoLine.AddPoint(x, y);
                    }
                    IGeometry geometry = GeometryFunc.createGeometryByObject((Object)geoLine);
                    IFeature feature = featureClass.createFeature();
                    feature.setGeometry(geometry);
                    cursor.insertFeature(feature);
                    ++featureCount;
                    line = br.readLine();
                    ++lineNum;
                }
                executeResult.setSuccess(Boolean.valueOf(true));
                this.invokeExcuteLog(String.format("%s\u8f6c\u6210\u5b8c\u6210\uff0c\u5171%d\u4e2a", name, featureCount));
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
        }
        catch (Exception e) {
            if (lineNum > 0) {
                this.invokeExcuteLog(String.format("%s \u7b2c%d\u884c\u5904\u7406\u5931\u8d25", walFile, lineNum));
            }
            this.log.error(walFile + " \u5904\u7406\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("%s \u8f6c\u6362\u5931\u8d25:%s", walFile, e.getMessage()));
        }
        finally {
            if (outputWorkspace != null) {
                this.stopEdit(outputWorkspace, true);
                outputWorkspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertWap(String wapFile, String targetFile, ExecuteResult executeResult) {
        IFeatureWorkspace outputWorkspace = ToolHelper.getFileWorkspace(targetFile);
        int lineNum = 0;
        try {
            Fields fields = new Fields();
            fields.addField((IField)new Field("OBJECTID", "OBJECTID", FieldType.OID));
            fields.addField((IField)new GeometryField("Shape", "Shape", GeometryType.Polygon, null, CoordinateType.XY));
            String name = FileUtil.getPrefix((String)wapFile);
            IFeatureClass featureClass = outputWorkspace.createFeatureClass(name, (IFields)fields, FeatureType.Polygon, "Shape", null);
            if (featureClass == null) {
                throw new RuntimeException(name + " \u56fe\u5c42\u521b\u5efa\u5931\u8d25");
            }
            outputWorkspace.beginTransaction();
            IFeatureCursor cursor = featureClass.insertFeature();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wapFile), Charset.forName("GBK")));){
                String line = br.readLine();
                line = br.readLine();
                int featureCount = 0;
                while ((line = br.readLine()) != null) {
                    ++lineNum;
                    if ((line = line.trim()).isEmpty()) continue;
                    if (!line.startsWith("1,")) break;
                    line = br.readLine();
                    ++lineNum;
                    line = br.readLine();
                    ++lineNum;
                    line = br.readLine();
                    ++lineNum;
                    int pointCount = Integer.parseInt(line);
                    Geometry geoRing = new Geometry(101);
                    for (int i = 0; i < pointCount; ++i) {
                        line = br.readLine();
                        ++lineNum;
                        String[] xy = line.split(",");
                        double x = Double.parseDouble(xy[0]);
                        double y = Double.parseDouble(xy[1]);
                        geoRing.AddPoint(x, y);
                    }
                    Geometry poly = new Geometry(3);
                    poly.AddGeometry(geoRing);
                    IGeometry geometry = GeometryFunc.createGeometryByObject((Object)poly);
                    IFeature feature = featureClass.createFeature();
                    feature.setGeometry(geometry);
                    cursor.insertFeature(feature);
                    ++featureCount;
                    line = br.readLine();
                    ++lineNum;
                }
                executeResult.setSuccess(Boolean.valueOf(true));
                this.invokeExcuteLog(String.format("%s\u8f6c\u6210\u5b8c\u6210\uff0c\u5171%d\u4e2a", name, featureCount));
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
        }
        catch (Exception e) {
            if (lineNum > 0) {
                this.invokeExcuteLog(String.format("%s \u7b2c%d\u884c\u5904\u7406\u5931\u8d25", wapFile, lineNum));
            }
            this.log.error(wapFile + " \u5904\u7406\u5931\u8d25", (Throwable)e);
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("%s \u8f6c\u6362\u5931\u8d25:%s", wapFile, e.getMessage()));
        }
        finally {
            if (outputWorkspace != null) {
                this.stopEdit(outputWorkspace, true);
                outputWorkspace.close();
            }
        }
    }

    private void stopEdit(IFeatureWorkspace pWorkspace, boolean isSave) {
        try {
            if (pWorkspace == null) {
                return;
            }
            if (pWorkspace.getInTransaction()) {
                if (isSave) {
                    pWorkspace.commitTransaction();
                } else {
                    pWorkspace.rollbackTransaction();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u63d0\u4ea4\u4e8b\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }
}

