/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify;

import com.geoway.dgt.geodata.annosimplify.AnnoBase;
import com.geoway.dgt.geodata.annosimplify.AnnoParas;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.dao.DbOperation;
import com.geoway.dgt.geodata.annosimplify.dao.WorkspaceUtil;
import com.geoway.dgt.geodata.annosimplify.supplier.SimplifySupplier;
import com.geoway.dgt.geodata.annosimplify.vectortile.tilecutter.scroll.Scroll;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class AnnoSimplify
extends AnnoBase<String> {
    @Override
    public void execute(AnnoParas annoParas) throws Exception {
        this.at = AnnoType.SIMPLIFY;
        this.supplier = SimplifySupplier.getSimplifySupplier();
        this.setFeatureSetBox(annoParas);
        super.execute(annoParas);
    }

    @Override
    protected void pretreatment() {
        this.checkAnnoField();
    }

    private void checkAnnoField() {
        if (this.haveField().booleanValue()) {
            this.cleanNewFieldValue();
        } else {
            this.createNewField();
        }
    }

    private Boolean haveField() {
        String sql = String.format("select  %s  from %s   limit 1", AnnoBase.annoParas.annoFild, AnnoBase.annoParas.newTableName);
        try {
            WorkspaceUtil.queryOne(AnnoBase.annoParas.newDsKey, sql);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5b58\u5728" + AnnoBase.annoParas.annoFild + "\u5b57\u6bb5");
            }
            return true;
        }
        catch (Exception ex) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u6ca1\u6709" + AnnoBase.annoParas.annoFild + "\u5b57\u6bb5");
            }
            return false;
        }
    }

    private void cleanNewFieldValue() {
        String newFieldName = AnnoBase.annoParas.annoFild;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u6e05\u7a7a" + newFieldName + "\u5b57\u6bb5\u7684\u503c");
        }
        String sql = "update " + AnnoBase.annoParas.newTableName + " set " + newFieldName + " = null where " + newFieldName + " is not null";
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sql:" + sql);
        }
        WorkspaceUtil.excuteSql(AnnoBase.annoParas.newDsKey, sql);
    }

    private void createNewField() {
        String newFieldName = AnnoBase.annoParas.annoFild;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u521b\u5efa" + newFieldName + "\u5b57\u6bb5");
        }
        String sql = "alter table " + AnnoBase.annoParas.newTableName + " ADD COLUMN " + newFieldName + " integer";
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sql:" + sql);
        }
        WorkspaceUtil.excuteSql(AnnoBase.annoParas.newDsKey, sql);
    }

    private void setFeatureSetBox(AnnoParas annoParas) {
        String sql = "select  st_astext(st_extent({geom})) as WKT from {table}";
        sql = sql.replace("{geom}", annoParas.getGeoField());
        sql = sql.replace("{table}", annoParas.getTable());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sql:" + sql);
        }
        Map<String, Object> boxMap = WorkspaceUtil.queryOne(annoParas.newDsKey, sql);
        String box = "";
        box = boxMap.get("WKT") == null ? (String)boxMap.get("wkt") : (String)boxMap.get("WKT");
        String returnBox = "-180,-90,180,90";
        if (box != null && !box.isEmpty() && box.startsWith("POLYGON((")) {
            returnBox = box.replace("POLYGON((", "");
            returnBox = returnBox.replace("))", "");
            returnBox = returnBox.replace(" ", ",");
        }
        String[] returnBoxArr = returnBox.split(",");
        annoParas.setLeft(Double.parseDouble(returnBoxArr[0])).setBottom(Double.parseDouble(returnBoxArr[1])).setRight(Double.parseDouble(returnBoxArr[4])).setTop(Double.parseDouble(returnBoxArr[5]));
        this.logger.info("\u8bbe\u7f6e\u65b0\u7684\u70b9\u56fe\u5c42\u5916\u6846\u77e9\u5f62\u503c\uff1a" + box);
    }

    @Override
    protected void executeEndValue(int level, String values) {
        DbOperation.getDbOperation().setLevelToDB(level, values);
    }

    @Override
    protected void beginExecute(Scroll scroll, CompletableFuture<String> cfBase) {
    }
}

