/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify;

import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.annosimplify.AnnoBase;
import com.geoway.dgt.geodata.annosimplify.AnnoParas;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplifyParam;
import com.geoway.dgt.geodata.annosimplify.config.PrepareParameter;
import java.util.UUID;
import java.util.function.Consumer;

public class AnnoSimplifyTool
extends ToolBase {
    public boolean isAborted() {
        return super.isAborted();
    }

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName(batchInputData.getName());
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        throw new UnsupportedOperationException();
    }

    public void log(String format, String param) {
        this.invokeExcuteLog(String.format(format, param));
    }

    public void log(String log) {
        this.invokeExcuteLog(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u62bd\u7a00\u5de5\u5177\u6570\u636e\uff1a" + inputDataParam.getName());
        IFeatureWorkspace workspace = null;
        try {
            GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
            workspace = geoDatabaseService.openGeoWorkspace(inputDataParam.getDsKey());
            ITable table = workspace.openTable(inputDataParam.getName());
            if (table == null) {
                this.invokeExcuteLog("\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            if (table.getOidFieldName() == null) {
                this.invokeExcuteLog("\u6570\u636e\u6ca1\u6709\u4e3b\u952e", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            AnnoBase.annoSimplifyTool = this;
            AnnoSimplifyParam param = (AnnoSimplifyParam)executeParam;
            AnnoParas ap = PrepareParameter.prepareStr(param.getXml().replaceAll("\t", ""));
            if (ap.newSrid.equals("4326") || ap.newSrid.equals("4490")) {
                ap.mapUnit = "degrees";
                ap.avServer.setGridUnit("degrees");
            } else if (ap.newSrid.equals("3857") || ap.newSrid.equals("4548")) {
                ap.mapUnit = "meters";
                ap.avServer.setGridUnit("meters");
            } else {
                throw new RuntimeException(String.format("\u4e0d\u652f\u6301\u7684\u5750\u6807\u7cfb\u7edfsrid: %s", ap.newSrid));
            }
            if (ap == null) {
                throw new RuntimeException("\u4f20\u9012\u5230\u540e\u53f0\u7684\u62bd\u7a00\u4efb\u52a1\u53c2\u6570\u6709\u8bef\uff01");
            }
            ap.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            new AnnoSimplify().execute(ap);
            if (!this.isAborted()) {
                this.invokeExcuteLog(String.format("[%s]\u62bd\u7a00\u5904\u7406\u5b8c\u6210 ", inputDataParam.getName()));
                executeResult.setSuccess(Boolean.valueOf(true));
            } else {
                executeResult.setSuccess(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            this.invokeExcuteLog(String.format("[%s]\u62bd\u7a00\u5904\u7406\u5931\u8d25", inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (workspace != null) {
                workspace.close();
            }
            AnnoBase.annoParas = null;
            AnnoBase.annoSimplifyTool = null;
        }
        return executeResult;
    }
}

