/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.dao;

import com.geoway.dgt.geodata.annosimplify.AnnoBase;
import com.geoway.dgt.geodata.annosimplify.AnnoLog;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.config.layer.LayerLevel;
import com.geoway.dgt.geodata.annosimplify.dao.DbOperation;
import com.geoway.dgt.geodata.annosimplify.dao.WorkspaceUtil;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import java.util.List;
import java.util.Map;

public class PoiOperation {
    protected static final AnnoLog logger = new AnnoLog(PoiOperation.class);

    public static int setLevelToDB(int level, String ids) {
        return DbOperation.getDbOperation().setLevelToDB(level, ids);
    }

    public static List getPoiByBox(AnnoType at, GridExtent extent) {
        int level = extent.getLevel();
        if (AnnoBase.annoParas == null) {
            return null;
        }
        Map<Integer, LayerLevel> levelMap = AnnoBase.annoParas.avServer.getLayerMap().get("annoLayer").getLevelMap();
        LayerLevel ll = levelMap.get(level);
        String where = "";
        if (!ll.getFilter().trim().isEmpty()) {
            where = " and " + ll.getFilter();
        }
        String newDsKey = AnnoSimplify.annoParas.newDsKey;
        String sql = String.format(AnnoBase.annoParas.getPointFromBoxSql, extent.getWkt(), where);
        if (logger.isDebugEnabled()) {
            logger.debug("\u6267\u884cgetPoiByBox\u67e5\u8be2\uff1a" + sql);
        }
        return WorkspaceUtil.query(newDsKey, sql);
    }
}

