/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.check;

import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.check.OsgbEpsgCheckParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OsgbEpsgCheckTool
extends ToolBase {
    private String epsg = null;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName("\u6a21\u578b\u6570\u636e\u68c0\u67e5");
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setPriority(100);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        File folder = new File(inputDataParam.getFilePath());
        OsgbEpsgCheckParam osgbEpsgCheckParam = (OsgbEpsgCheckParam)executeParam;
        File[] subFiles = folder.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            this.invokeExcuteLog("\u6570\u636e\u6587\u4ef6\u5939\u4e3a\u7a7a\uff01", TaskLogLevelEnum.Error);
            executeResult.setSuccess(Boolean.valueOf(false));
            return executeResult;
        }
        boolean hasCheckError = false;
        for (File rootFile : subFiles) {
            String name = rootFile.getName();
            if (rootFile.isDirectory()) {
                this.invokeExcuteLog("\u53d1\u73b0\u6839\u8282\u70b9\uff1a" + rootFile.getName());
                if (!this.rootFolderHasCheckError(rootFile)) continue;
                hasCheckError = true;
                continue;
            }
            if (!rootFile.isFile() || !name.contains(".") || !".xml".equalsIgnoreCase(name.substring(name.lastIndexOf(".")))) continue;
            this.epsg = this.readEpsgFromXml(rootFile);
        }
        this.invokeExcuteLog("\u6570\u636eepsg\uff1a" + (this.epsg == null ? "" : this.epsg));
        if (this.epsg == null || !this.epsg.equals(osgbEpsgCheckParam.getEpsg())) {
            this.invokeExcuteLog("\u6570\u636eepsg\u4e0e\u68c0\u67e5\u9879\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
            hasCheckError = true;
        }
        executeResult.setSuccess(Boolean.valueOf(!hasCheckError));
        return executeResult;
    }

    private boolean rootFolderHasCheckError(File rootFile) {
        boolean hasCheckError = false;
        File[] tileFolders = rootFile.listFiles();
        int subFolderCount = 0;
        if (tileFolders == null || tileFolders.length == 0) {
            this.invokeExcuteLog(rootFile.getName() + "\u6587\u4ef6\u5939\u4e0b\u65e0\u5b50\u6587\u4ef6\u5939\uff01", TaskLogLevelEnum.Error);
            return true;
        }
        for (File tileFile : tileFolders) {
            subFolderCount = tileFile.isDirectory() ? subFolderCount + 1 : subFolderCount;
            String name = tileFile.getName();
            if (tileFile.isDirectory() && this.tileFolderHasCheckError(tileFile)) {
                hasCheckError = true;
                continue;
            }
            if (this.epsg != null || !tileFile.isFile() || !name.contains(".") || !".xml".equalsIgnoreCase(name.substring(name.lastIndexOf(".")))) continue;
            this.epsg = this.readEpsgFromXml(tileFile);
        }
        if (subFolderCount == 0) {
            this.invokeExcuteLog(rootFile.getName() + "\u6587\u4ef6\u5939\u4e0b\u65e0\u5b50\u6587\u4ef6\u5939\uff01", TaskLogLevelEnum.Error);
            hasCheckError = true;
        }
        return hasCheckError;
    }

    private boolean tileFolderHasCheckError(File tileFile) {
        boolean hasCheckError = false;
        String tileName = tileFile.getName();
        File[] subFiles = tileFile.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            this.invokeExcuteLog(tileName + "\u6587\u4ef6\u5939\u4e0b\u65e0\u5b50\u6587\u4ef6\uff01", TaskLogLevelEnum.Error);
            return true;
        }
        boolean hasSameNameFile = false;
        for (File file : subFiles) {
            int index;
            String subFileName;
            if (file.isDirectory()) {
                this.invokeExcuteLog(tileName + "\u6587\u4ef6\u5939\u4e0b\u6709\u5d4c\u5957\u6587\u4ef6\u5939\uff1a" + file.getName() + "\uff01", TaskLogLevelEnum.Error);
                hasCheckError = true;
                continue;
            }
            if (!file.getName().toLowerCase(Locale.ROOT).endsWith(".osgb")) {
                this.invokeExcuteLog(tileName + "\u6587\u4ef6\u5939\u4e0b\u6709\u975eosgb\u6587\u4ef6\uff1a" + file.getName() + "\uff01", TaskLogLevelEnum.Error);
                hasCheckError = true;
            }
            String string = subFileName = (index = file.getName().lastIndexOf(".")) >= 0 ? file.getName().substring(0, index) : file.getName();
            if (!subFileName.equals(tileName)) continue;
            hasSameNameFile = true;
        }
        if (!hasSameNameFile) {
            this.invokeExcuteLog(tileName + "\u6587\u4ef6\u5939\u4e0b\u65e0\u540c\u540dosgb\u6587\u4ef6\uff01", TaskLogLevelEnum.Error);
            hasCheckError = true;
        }
        return hasCheckError;
    }

    private String readEpsgFromXml(File xmlFile) {
        FileInputStream xmlInputStream = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            xmlInputStream = new FileInputStream(xmlFile);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlInputStream);
            Element metadataXml = (Element)document.getElementsByTagName("ModelMetadata").item(0);
            NodeList nodeList = metadataXml.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!"SRS".equals(nodeList.item(i).getNodeName())) continue;
                Element element = (Element)nodeList.item(i);
                String text = element.getTextContent();
                if (text.indexOf(":") + 1 > 0) {
                    String string = text.substring(text.indexOf(":") + 1);
                    return string;
                }
                String string = null;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("xml\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
        finally {
            try {
                if (xmlInputStream != null) {
                    ((InputStream)xmlInputStream).close();
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

