/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.feature;

import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.geometry.Coordinate;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.feature.FeatureToPointParam;
import com.geoway.dgt.geodata.feature.LayerRelationship;
import java.io.File;
import java.util.function.Consumer;

public class FeatureToCenterPointTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        FeatureToPointParam param = (FeatureToPointParam)toolParam;
        if (param.getLayerList() == null || param.getLayerList().size() == 0 || !ListUtil.exist(param.getLayerList(), f -> Boolean.TRUE.equals(f.getChecked()))) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5f85\u5904\u7406\u56fe\u5c42");
        }
        String name = batchInputData.getName();
        if (StringUtil.isEmptyOrWhiteSpace((String)name)) {
            name = FileUtil.getFileNameWithoutExtension((String)batchInputData.getFilePath());
        }
        DataStripingResult dataStripingResult = new DataStripingResult();
        dataStripingResult.setName(name);
        dataStripingResult.setInputData(batchInputData);
        dataStripingResult.setOutputData(batchOutputData);
        dataStripingResult.setToolExecuteParam(toolParam);
        oneDataCallback.accept(dataStripingResult);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        IFeatureWorkspace srcWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        try {
            FeatureToPointParam param = (FeatureToPointParam)executeParam;
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)inputDataParam.getFilePath());
            if (srcWorkspace == null) {
                executeResult.setErrorMessage("\u6253\u5f00\u6e90\u6570\u636e\u5931\u8d25:" + inputDataParam.getFilePath());
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            if (Boolean.TRUE.equals(param.getSaveAsNew())) {
                if (StringUtil.isEmpty((String)outputDataParam.getFilePath())) {
                    executeResult.setErrorMessage("\u672a\u8bbe\u7f6e\u8f93\u51fa\u6570\u636e\u8def\u5f84");
                    executeResult.setSuccess(Boolean.valueOf(false));
                    this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                    ExecuteResult executeResult3 = executeResult;
                    return executeResult3;
                }
                String outputName = FileUtil.getFileNameWithoutExtension((String)inputDataParam.getFilePath()) + ".gdb";
                File outputFile = new File(outputDataParam.getFilePath(), outputName);
                if (outputFile.isDirectory() && outputFile.exists()) {
                    targetWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)outputFile.getAbsolutePath());
                    if (targetWorkspace == null) {
                        executeResult.setErrorMessage("\u6253\u5f00\u8f93\u51fa\u6570\u636e\u5931\u8d25:" + outputFile.getAbsolutePath());
                        executeResult.setSuccess(Boolean.valueOf(false));
                        this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                        ExecuteResult executeResult4 = executeResult;
                        return executeResult4;
                    }
                } else {
                    targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)outputFile.getAbsolutePath());
                    if (targetWorkspace == null) {
                        executeResult.setErrorMessage("\u521b\u5efa\u8f93\u51fa\u6570\u636e\u5931\u8d25:" + outputFile.getAbsolutePath());
                        executeResult.setSuccess(Boolean.valueOf(false));
                        this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
                        ExecuteResult executeResult5 = executeResult;
                        return executeResult5;
                    }
                }
                this.invokeExcuteLog("\u8f93\u51fa\u6570\u636e\u5230\uff1a" + outputFile.getAbsolutePath());
            } else {
                targetWorkspace = srcWorkspace;
            }
            boolean success = true;
            for (LayerRelationship layer : param.getLayerList()) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u7ec8\u6b62");
                }
                if (!Boolean.TRUE.equals(layer.getChecked())) continue;
                if (!Boolean.TRUE.equals(param.getSaveAsNew()) && StringUtil.equals((String)layer.getSourceLayerName(), (String)layer.getTargetLayerName())) {
                    this.invokeExcuteLog(layer.getSourceLayerName() + " \u6e90\u56fe\u5c42\u4e0e\u76ee\u6807\u56fe\u5c42\u76f8\u540c\uff0c\u8bf7\u9009\u62e9\u4e0d\u540c\u7684\u56fe\u5c42", TaskLogLevelEnum.Error);
                    success = false;
                    continue;
                }
                this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\uff1a" + layer.getSourceLayerName());
                IFeatureClass srcFeatClass = srcWorkspace.openFeatureClass(layer.getSourceLayerName());
                if (srcFeatClass == null) {
                    success = false;
                    this.invokeExcuteLog(layer.getSourceLayerName() + " \u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                    continue;
                }
                if (srcFeatClass.getFeatureType() == FeatureType.Point) {
                    this.invokeExcuteLog(layer.getSourceLayerName() + " \u4e3a\u70b9\u56fe\u5c42\uff0c\u8df3\u8fc7\u5904\u7406", TaskLogLevelEnum.Info);
                    continue;
                }
                IFeatureClass targetFeatureClass = targetWorkspace.openFeatureClass(layer.getTargetLayerName());
                if (targetFeatureClass != null) {
                    targetFeatureClass.delete();
                    this.invokeExcuteLog(layer.getTargetLayerName() + " \u5df2\u5b58\u5728\uff0c\u5220\u9664", TaskLogLevelEnum.Warning);
                }
                Fields newFields = new Fields();
                for (int i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
                    IField tempField = srcFeatClass.getFields().getField(i).clone();
                    newFields.addField(tempField);
                    if (tempField.getFieldType() != FieldType.Shape) continue;
                    GeometryField geometryField = (GeometryField)tempField;
                    geometryField.setGeometryType(GeometryType.Point);
                }
                targetFeatureClass = targetWorkspace.createFeatureClass(layer.getTargetLayerName(), (IFields)newFields, FeatureType.Point, srcFeatClass.getShapeFieldName(), null);
                if (targetFeatureClass == null) {
                    success = false;
                    this.invokeExcuteLog(layer.getTargetLayerName() + " \u521b\u5efa\u5931\u8d25", TaskLogLevelEnum.Error);
                    continue;
                }
                targetFeatureClass.createSpatialIndex();
                QueryFilter queryFilter = null;
                if (StringUtil.isNotEmpty((String)layer.getFilter())) {
                    queryFilter = new QueryFilter();
                    queryFilter.setWhereClause(layer.getFilter());
                }
                IFeatureCursor srcFeatureCursor = null;
                IFeatureCursor targetFeatureCursor = null;
                targetWorkspace.beginTransaction();
                try {
                    int sCount = 0;
                    srcFeatureCursor = srcFeatClass.searchFeature((IQueryFilter)queryFilter);
                    targetFeatureCursor = targetFeatureClass.insertFeature();
                    IFeature srcFeature = srcFeatureCursor.nextFeature();
                    while (srcFeature != null) {
                        if (this.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u7ec8\u6b62");
                        }
                        IFeature targetFeature = targetFeatureClass.createFeature();
                        IGeometry srcGeometry = srcFeature.getGeometry();
                        if (srcGeometry != null) {
                            Coordinate centerPt = "inner".equalsIgnoreCase(layer.getRule()) ? srcGeometry.getPointOnSurface() : srcGeometry.getCentroid();
                            IGeometry point = GeometryFunc.createGeometry((String)("POINT(" + centerPt.getX() + " " + centerPt.getY() + ")"));
                            targetFeature.setGeometry(point);
                        }
                        for (int i = 0; i < srcFeature.getFields().getFieldCount(); ++i) {
                            IField field = srcFeature.getFields().getField(i);
                            if (field.getFieldType() == FieldType.Shape || field.getFieldType() == FieldType.OID) continue;
                            String fieldName = field.getName();
                            int index = targetFeature.getFields().findFieldIndex(fieldName);
                            if (index > -1) {
                                targetFeature.setValue(index, srcFeature.getValue(i));
                                continue;
                            }
                            if (!fieldName.equalsIgnoreCase("DATE") || (index = targetFeature.getFields().findFieldIndex("DATE_")) <= -1) continue;
                            targetFeature.setValue(index, srcFeature.getValue(i));
                        }
                        targetFeatureCursor.insertFeature(targetFeature);
                        srcFeature = srcFeatureCursor.nextFeature();
                        ++sCount;
                    }
                    targetFeatureCursor.release();
                    targetFeatureCursor = null;
                    targetWorkspace.commitTransaction();
                    this.invokeExcuteLog(String.format("[%s]->[%s]\u5904\u7406\u5b8c\u6210\uff0c\u6570\u636e\u5171%d\u6761", layer.getSourceLayerName(), layer.getTargetLayerName(), sCount));
                }
                catch (Exception e) {
                    this.log.error(String.format("[%s]->[%s]\u5904\u7406\u5931\u8d25", layer.getSourceLayerName(), layer.getTargetLayerName()), (Throwable)e);
                    success = false;
                    this.invokeExcuteLog(String.format("[%s]->[%s]\u5904\u7406\u5931\u8d25\uff1a%s", layer.getSourceLayerName(), layer.getTargetLayerName(), e.getMessage()), TaskLogLevelEnum.Error);
                }
                finally {
                    if (srcFeatureCursor != null) {
                        srcFeatureCursor.release();
                    }
                    if (targetFeatureCursor != null) {
                        targetFeatureCursor.release();
                    }
                    if (!targetWorkspace.getInTransaction()) continue;
                    targetWorkspace.commitTransaction();
                }
            }
            executeResult.setSuccess(Boolean.valueOf(success));
        }
        catch (Exception e) {
            this.log.error("\u5904\u7406\u5f02\u5e38", (Throwable)e);
            executeResult.setErrorMessage("\u5904\u7406\u5931\u8d25:" + e.getMessage());
            executeResult.setSuccess(Boolean.valueOf(false));
            this.invokeExcuteLog(executeResult.getErrorMessage(), TaskLogLevelEnum.Error);
        }
        finally {
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        return executeResult;
    }
}

