/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.merge;

import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.merge.MergeLineParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.gdal.ogr.Geometry;

public class MergeLineTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName(batchInputData.getName());
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a" + inputDataParam.getName());
        IFeatureWorkspace srcWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        IFeatureClass targetFc = null;
        IFeatureCursor insertCursor = null;
        int successCount = 0;
        try {
            GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
            srcWorkspace = geoDatabaseService.openGeoWorkspace(inputDataParam.getDsKey());
            targetWorkspace = geoDatabaseService.openGeoWorkspace(outputDataParam.getDsKey());
            IFeatureClass srcFc = srcWorkspace.openFeatureClass(inputDataParam.getName());
            if (srcFc == null) {
                this.invokeExcuteLog(inputDataParam.getName() + "\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            MergeLineParam mergeLineParam = (MergeLineParam)executeParam;
            IField nameField = srcFc.getFields().findField(mergeLineParam.getNameField());
            if (nameField == null) {
                this.invokeExcuteLog("\u4e3b\u8981\u878d\u5408\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + mergeLineParam.getNameField(), TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            long totalCount = srcFc.featureCount(null);
            if (totalCount == 0L) {
                this.invokeExcuteLog(inputDataParam.getName() + "\u56fe\u5c42\u8bb0\u5f55\u4e3a\u7a7a", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult4 = executeResult;
                return executeResult4;
            }
            ArrayList<String> mergeFields = new ArrayList<String>();
            mergeFields.add(mergeLineParam.getNameField().toLowerCase());
            for (String mFld : mergeLineParam.getMergeFields().split(",")) {
                if (mergeFields.contains(mFld.toLowerCase())) continue;
                mergeFields.add(mFld.toLowerCase());
            }
            String targetName = outputDataParam.getName();
            targetFc = targetWorkspace.openFeatureClass(targetName);
            if (targetFc != null) {
                targetFc = null;
                this.invokeExcuteLog(targetName + " \u5df2\u5b58\u5728", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult5 = executeResult;
                return executeResult5;
            }
            targetFc = this.createFeatureClass(srcFc, mergeFields, targetWorkspace, targetName);
            double resolution = mergeLineParam.getTolerance().floatValue();
            if (targetFc.getSpatialReferenceSystem() != null && targetFc.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Geographic) {
                resolution = resolution * 360.0 / 4.007501668557849E7;
            }
            List distinctDatas = srcWorkspace.queryList(String.format("select distinct %s from %s", String.join((CharSequence)",", mergeFields), inputDataParam.getName()), new Object[0]);
            targetWorkspace.beginTransaction();
            insertCursor = targetFc.insertFeature();
            for (Map dataValues : distinctDatas) {
                IFeature newFeature;
                boolean merge = true;
                for (Map.Entry data : dataValues.entrySet()) {
                    if (!((String)data.getKey()).equalsIgnoreCase(nameField.getName()) || data.getValue() != null && !data.getValue().toString().trim().isEmpty()) continue;
                    merge = false;
                    break;
                }
                if (resolution == 0.0) {
                    merge = false;
                }
                ArrayList<Geometry> mergeGeometry = new ArrayList<Geometry>();
                QueryFilter filter = new QueryFilter();
                filter.setSubFields(srcFc.getOidFieldName() + "," + srcFc.getShapeFieldName());
                filter.setWhereClause(this.buildFilter(srcFc, dataValues));
                IFeatureCursor srcCursor = null;
                try {
                    srcCursor = srcFc.searchFeature((IQueryFilter)filter);
                    IFeature feature = srcCursor.nextFeature();
                    while (feature != null) {
                        if (feature.getGeometry() == null) {
                            this.invokeExcuteLog(feature.getObjectId() + "\u6570\u636e\u51e0\u4f55\u4e3a\u7a7a", TaskLogLevelEnum.Error);
                            feature = srcCursor.nextFeature();
                            continue;
                        }
                        if (merge) {
                            Geometry geo = (Geometry)feature.getGeometry().clone().getObject();
                            if (feature.getGeometry().getType() == GeometryType.LineString || feature.getGeometry().getType() == GeometryType.LinearRing) {
                                mergeGeometry.add(geo);
                            } else if (feature.getGeometry().getType() == GeometryType.Polyline) {
                                for (int i = 0; i < geo.GetGeometryCount(); ++i) {
                                    mergeGeometry.add(geo.GetGeometryRef(i));
                                }
                            } else {
                                this.invokeExcuteLog(feature.getObjectId() + "\u51e0\u4f55\u4e0d\u662f\u7ebf\u7c7b\u578b", TaskLogLevelEnum.Error);
                            }
                        } else {
                            newFeature = targetFc.createFeature();
                            newFeature.setGeometry(feature.getGeometry());
                            for (Map.Entry data : dataValues.entrySet()) {
                                newFeature.setValue((String)data.getKey(), data.getValue());
                            }
                            insertCursor.insertFeature(newFeature);
                            ++successCount;
                        }
                        feature = srcCursor.nextFeature();
                    }
                }
                finally {
                    if (srcCursor != null) {
                        srcCursor.release();
                    }
                }
                if (!merge || mergeGeometry.size() <= 0) continue;
                while (mergeGeometry.size() > 0) {
                    Geometry newLine = this.dealWith(mergeGeometry, resolution);
                    newFeature = targetFc.createFeature();
                    newFeature.setGeometry(GeometryFunc.createGeometryByObject((Object)newLine));
                    for (Map.Entry data : dataValues.entrySet()) {
                        newFeature.setValue((String)data.getKey(), data.getValue());
                    }
                    insertCursor.insertFeature(newFeature);
                    ++successCount;
                }
            }
            this.invokeExcuteLog(String.format("[%s]\u878d\u5408\u5904\u7406\u5b8c\u6210\uff0c\u5171%d\u6761\u6570\u636e\uff0c\u878d\u5408\u540e%d\u6761\u6570\u636e", inputDataParam.getName(), totalCount, successCount));
            executeResult.setSuccess(Boolean.valueOf(successCount > 0));
        }
        catch (Exception e) {
            this.invokeExcuteLog(String.format("[%s]\u878d\u5408\u5931\u8d25\uff1a" + e.getMessage(), inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (targetWorkspace != null) {
                targetWorkspace.commitTransaction();
                if (successCount == 0 && targetFc != null) {
                    try {
                        targetFc.delete();
                    }
                    catch (Exception e) {
                        this.log.error("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
                    }
                }
                targetWorkspace.close();
            }
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
        }
        return executeResult;
    }

    private Geometry dealWith(List<Geometry> pointsArr, double distance) {
        Geometry line;
        Geometry newLine = line = pointsArr.get(0);
        pointsArr.remove(line);
        int length = pointsArr.size();
        for (int i = 0; i < length; ++i) {
            double[] p;
            int j;
            double[] point2;
            Geometry nextLine = pointsArr.get(i);
            double[] point1 = newLine.GetPoint_2D(0);
            if (this.check(point1, point2 = nextLine.GetPoint_2D(nextLine.GetPointCount() - 1), distance)) {
                for (j = 0; j < newLine.GetPointCount(); ++j) {
                    p = newLine.GetPoint_2D(j);
                    nextLine.AddPoint(p[0], p[1]);
                }
                newLine = nextLine;
                pointsArr.remove(i);
                length = pointsArr.size();
                i = -1;
                continue;
            }
            point1 = newLine.GetPoint_2D(newLine.GetPointCount() - 1);
            if (!this.check(point1, point2 = nextLine.GetPoint_2D(0), distance)) continue;
            for (j = 0; j < nextLine.GetPointCount(); ++j) {
                p = nextLine.GetPoint_2D(j);
                newLine.AddPoint(p[0], p[1]);
            }
            pointsArr.remove(i);
            length = pointsArr.size();
            i = -1;
        }
        return newLine;
    }

    private boolean check(double[] point1, double[] point2, double distance) {
        return this.length(point1[0], point1[1], point2[0], point2[1]) <= distance;
    }

    private double length(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double len = StrictMath.sqrt(dx * dx + dy * dy);
        return len;
    }

    private IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, List<String> fields, IFeatureWorkspace tarWorkspace, String tarFCName) {
        Fields newFields = new Fields();
        newFields.addField(srcFeatClass.getFields().findField(srcFeatClass.getOidFieldName()).clone());
        newFields.addField(srcFeatClass.getFields().findField(srcFeatClass.getShapeFieldName()).clone());
        for (String fld : fields) {
            IField tempField = srcFeatClass.getFields().findField(fld);
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField.clone());
        }
        IFeatureClass iFeatClass = tarWorkspace.createFeatureClass(tarFCName, (IFields)newFields, srcFeatClass.getFeatureType(), srcFeatClass.getShapeFieldName(), srcFeatClass.getSubTypeFieldName());
        if (iFeatClass == null) {
            throw new RuntimeException("\u76ee\u6807\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25");
        }
        iFeatClass.createSpatialIndex();
        return iFeatClass;
    }

    private String buildFilter(IFeatureClass featureClass, Map<String, Object> dataValues) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (Map.Entry<String, Object> data : dataValues.entrySet()) {
            IField field = featureClass.getFields().findField(data.getKey());
            String condition = null;
            if (data.getValue() == null) {
                condition = field.getName() + " is null";
            } else {
                switch (field.getFieldType()) {
                    case String: 
                    case Text: {
                        condition = field.getName() + "='" + data.getValue() + "'";
                        break;
                    }
                    case Short: 
                    case Int: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case Decimal: {
                        condition = field.getName() + "=" + data.getValue();
                        break;
                    }
                    case DateTime: {
                        String date = data.getValue() instanceof Date ? DateTimeUtil.dateString((Date)((Date)data.getValue()), (String)"yyyy-MM-dd HH:mm:ss.SSS") : data.getValue().toString();
                        condition = field.getName() + "='" + date + "'";
                        break;
                    }
                    default: {
                        this.log.error("\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a" + field.getName() + "-" + field.getFieldType());
                    }
                }
            }
            conditions.add(condition);
        }
        return String.join((CharSequence)" and ", conditions);
    }
}

