/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.dao;

import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.config.AnnoLayerLevel;
import com.geoway.dgt.geodata.annosimplify.dao.WorkspaceUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbOperation {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    private DbOperation() {
    }

    public static DbOperation getDbOperation() {
        return InstanceHolder.dbo;
    }

    public int setLevelToDB(int level, String ids) {
        if (ids.trim().isEmpty()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u6267\u884c\u66f4\u65b0 \uff1asetLevelToDB\u53c2\u6570ids\u4e3a\u7a7a\uff01 ");
            }
            return -1;
        }
        String updateSql = AnnoSimplify.annoParas.updateSqlBase.replaceFirst("\\?", String.valueOf(level));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("\u6267\u884c\u66f4\u65b0 \uff1a " + updateSql);
        }
        Object[] idsArr = ids.split(",");
        ids = StringUtils.join((Object[])idsArr, (String)",");
        String newUpdateSql = updateSql.replaceFirst("\\?", ids);
        Object[] idsIntArr = new Object[idsArr.length];
        StringBuilder qq = new StringBuilder();
        int size = idsArr.length;
        for (int i = 0; i < size; ++i) {
            idsIntArr[i] = Integer.valueOf((String)idsArr[i]);
            qq.append("?").append(",");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u6267\u884c\u66f4\u65b0 \uff1a \u7b2c" + level + "\u5c42\uff1a " + idsArr.length + " \u6761\u8981\u7d20\u6267\u884csql update");
        }
        qq = qq.deleteCharAt(qq.length() - 1);
        updateSql = updateSql.replaceFirst("\\?", qq.toString());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("\u6267\u884c\u66f4\u65b0 \uff1a \u7b2c" + level + "\u5c42 --  \u66f4\u65b0\u8981\u7d20\u4e2a\u6570\uff1a " + idsIntArr.length + " | " + (updateSql.split("\\?").length - 1));
        }
        try {
            String newDsKey = AnnoSimplify.annoParas.newDsKey;
            return WorkspaceUtil.excuteSql(newDsKey, newUpdateSql);
        }
        catch (Exception exx) {
            exx.printStackTrace();
            if (this.logger.isErrorEnabled()) {
                this.logger.error("updateSql  " + updateSql);
                this.logger.error("idsInt  " + idsIntArr.length);
            }
            return -1;
        }
    }

    public double getMathExpectation(int level) {
        BigInteger count = this.getPoiCount(level);
        int simplifyBox = ((AnnoLayerLevel)AnnoSimplify.annoParas.avServer.getLayerMap().get("annoLayer").getLevelMap().get(level)).getGridAtom();
        int boxPerGrid = AnnoSimplify.annoParas.gridSize / simplifyBox;
        boxPerGrid *= boxPerGrid;
        return count.doubleValue() / (double)(AnnoSimplify.annoParas.needToProcessCount * (long)boxPerGrid);
    }

    public BigInteger getPoiCount(int level) {
        BigInteger count = BigInteger.ZERO;
        String updateSql = AnnoSimplify.annoParas.getMathExpectationSql.replaceFirst("\\?", String.valueOf(level));
        try {
            String newDsKey = AnnoSimplify.annoParas.newDsKey;
            List<Map<String, Object>> me = WorkspaceUtil.query(newDsKey, updateSql);
            count = (BigInteger)me.get(0).get("count");
        }
        catch (Exception exx) {
            exx.printStackTrace();
            throw exx;
        }
        return count;
    }

    private static class InstanceHolder {
        public static DbOperation dbo = new DbOperation();

        private InstanceHolder() {
        }
    }
}

