/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.dao.binary;

import com.geoway.dgt.geodata.annosimplify.dao.binary.ByteGetter;

public abstract class ValueGetter {
    ByteGetter data;
    int position;
    public final byte endian;

    public ValueGetter(ByteGetter data, byte endian) {
        this.data = data;
        this.endian = endian;
    }

    public byte getByte() {
        return (byte)this.data.get(this.position++);
    }

    public int getInt() {
        int res = this.getInt(this.position);
        this.position += 4;
        return res;
    }

    public long getLong() {
        long res = this.getLong(this.position);
        this.position += 8;
        return res;
    }

    protected abstract int getInt(int var1);

    protected abstract long getLong(int var1);

    public double getDouble() {
        long bitrep = this.getLong();
        return Double.longBitsToDouble(bitrep);
    }

    public static class NDR
    extends ValueGetter {
        public static final byte NUMBER = 1;

        public NDR(ByteGetter data) {
            super(data, (byte)1);
        }

        @Override
        protected int getInt(int index) {
            return (this.data.get(index + 3) << 24) + (this.data.get(index + 2) << 16) + (this.data.get(index + 1) << 8) + this.data.get(index);
        }

        @Override
        protected long getLong(int index) {
            return ((long)this.data.get(index + 7) << 56) + ((long)this.data.get(index + 6) << 48) + ((long)this.data.get(index + 5) << 40) + ((long)this.data.get(index + 4) << 32) + ((long)this.data.get(index + 3) << 24) + ((long)this.data.get(index + 2) << 16) + ((long)this.data.get(index + 1) << 8) + ((long)this.data.get(index) << 0);
        }
    }

    public static class XDR
    extends ValueGetter {
        public static final byte NUMBER = 0;

        public XDR(ByteGetter data) {
            super(data, (byte)0);
        }

        @Override
        protected int getInt(int index) {
            return (this.data.get(index) << 24) + (this.data.get(index + 1) << 16) + (this.data.get(index + 2) << 8) + this.data.get(index + 3);
        }

        @Override
        protected long getLong(int index) {
            return ((long)this.data.get(index) << 56) + ((long)this.data.get(index + 1) << 48) + ((long)this.data.get(index + 2) << 40) + ((long)this.data.get(index + 3) << 32) + ((long)this.data.get(index + 4) << 24) + ((long)this.data.get(index + 5) << 16) + ((long)this.data.get(index + 6) << 8) + ((long)this.data.get(index + 7) << 0);
        }
    }
}

