/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.frame.util.VectorPathUtil;
import com.geoway.dgt.geodata.util.VectorDbUtil;
import java.io.File;
import org.springframework.util.Assert;

public class VectorCheckUtil {
    public static VectorReadWriteEnum readWriteModel(DataParam inputData, DataParam outputData, boolean isOverwrite) {
        String inputDsKey = inputData.getDsKey();
        String outputDsKey = outputData.getDsKey();
        if (StrUtil.isBlank((CharSequence)inputDsKey)) {
            if (isOverwrite) {
                return VectorReadWriteEnum.F;
            }
            if (StrUtil.isBlank((CharSequence)outputDsKey)) {
                return VectorReadWriteEnum.F2F;
            }
            return VectorReadWriteEnum.F2D;
        }
        if (isOverwrite) {
            return VectorReadWriteEnum.D;
        }
        if (StrUtil.isBlank((CharSequence)outputDsKey)) {
            return VectorReadWriteEnum.D2F;
        }
        return VectorReadWriteEnum.D2D;
    }

    public static void checkDsInput(DataParam inputData) {
        VectorDbUtil.check(inputData.getDsKey());
    }

    public static void checkDsOutput(DataParam outputData) {
        String dsKey = outputData.getDsKey();
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(dsKey);
        dataSourceService.testConnect(dataSourceDTO);
    }

    public static void checkFileInput(DataParam inputData, boolean mustExist, VectorFormatEnum formatEnum) {
        if (mustExist) {
            File file = new File(inputData.getFilePath());
            Assert.state((boolean)FileUtil.exist((File)file), (String)"\u8f93\u5165\u6570\u636e\u4e0d\u5b58\u5728");
            Assert.state((boolean)VectorFileUtil.match((File)file, (VectorFormatEnum)formatEnum), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
        } else {
            Assert.state((boolean)VectorPathUtil.exactlyMatch((String)inputData.getFilePath(), (VectorFormatEnum)formatEnum), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public static void checkFileOutput(DataParam outputData) {
        String outputDataFilePath = outputData.getFilePath();
        File outfile = new File(outputDataFilePath);
        if (outfile.exists()) {
            if (outfile.isFile()) {
                Assert.state((boolean)VectorFileUtil.exactlyMatchFile((File)outfile), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        } else {
            VectorFormatEnum formatEnum = VectorPathUtil.vectorFormat((String)outputDataFilePath);
            if (formatEnum == VectorFormatEnum.Shapefile && !StrUtil.endWithIgnoreCase((CharSequence)outputDataFilePath, (CharSequence)".shp")) {
                FileUtil.mkdir((String)outputDataFilePath);
            }
        }
    }
}

