/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.config;

import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.Constants;
import com.geoway.dgt.geodata.annosimplify.config.AnnoAfterSubtract;
import com.geoway.dgt.geodata.annosimplify.config.AnnoLayerLevel;
import com.geoway.dgt.geodata.annosimplify.config.dataset.DataSet;
import com.geoway.dgt.geodata.annosimplify.config.datasource.DataSource;
import com.geoway.dgt.geodata.annosimplify.config.datasource.impl.DbDataSource;
import com.geoway.dgt.geodata.annosimplify.config.datasource.impl.MongodbDataSource;
import com.geoway.dgt.geodata.annosimplify.config.layer.Label;
import com.geoway.dgt.geodata.annosimplify.config.layer.Layer;
import com.geoway.dgt.geodata.annosimplify.config.layer.LayerDataSet;
import com.geoway.dgt.geodata.annosimplify.config.layer.RoadDeal;
import com.geoway.dgt.geodata.annosimplify.config.server.impl.VectorTileServer;
import com.geoway.dgt.geodata.annosimplify.config.utfgrid.UtfGrid;
import com.geoway.dgt.geodata.annosimplify.dao.WorkspaceUtil;
import com.geoway.dgt.geodata.annosimplify.model.BaseObject;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;

@Component(value="adf.gis.XmlConfigLoaderSource")
public class XmlConfigLoader {
    private Boolean strict = true;

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public void load(String strXmlFile) throws Exception {
        String url = URLDecoder.decode(strXmlFile, "utf-8");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(url));
        Element root = document.getRootElement();
        List items = root.element("VectorTileServers").elements();
    }

    public List<VectorTileServer> getServerListByXml(String strXmlFile) throws Exception {
        String url = URLDecoder.decode(strXmlFile, "utf-8");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(url));
        return this.getServerList(document);
    }

    public List<VectorTileServer> getServerListByStr(String strXmlStr) throws Exception {
        Document document = DocumentHelper.parseText((String)strXmlStr);
        return this.getServerList(document);
    }

    public List<VectorTileServer> getServerList(Document document) throws Exception {
        Element root = document.getRootElement();
        List items = root.element("VectorTileServers").elements();
        ArrayList<VectorTileServer> vectorTileServerArr = new ArrayList<VectorTileServer>();
        for (Object item : items) {
            VectorTileServer vwectorTileServer = this.parseInfo((Element)item);
            vectorTileServerArr.add(vwectorTileServer);
        }
        return vectorTileServerArr;
    }

    public List<String> getServers(String strXmlFile) throws Exception {
        String url = URLDecoder.decode(strXmlFile, "utf-8");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(url));
        Element root = document.getRootElement();
        List items = root.element("VectorTileServers").elements();
        ArrayList<String> serverIdArr = new ArrayList<String>();
        for (Object item : items) {
            String serverId = ((Element)item).attributeValue("Id");
            serverIdArr.add(serverId);
        }
        return serverIdArr;
    }

    private VectorTileServer parseInfo(Element item) {
        UtfGrid utfGrid;
        VectorTileServer vectorTileServer = new VectorTileServer();
        this.getInfoByStr(item, vectorTileServer, VectorTileServer.class, "GridUnit,Name,Desc,Id,TileSaverName", true);
        String gridBase = item.elementText("GridBase");
        if (gridBase != null) {
            if ("256".equalsIgnoreCase(gridBase)) {
                vectorTileServer.setGridBase("base256");
            } else if ("512".equalsIgnoreCase(gridBase)) {
                vectorTileServer.setGridBase("base512");
            } else {
                throw new RuntimeException("GridBase\u5fc5\u987b\u662f256/512");
            }
        }
        if ((utfGrid = this.getUtfGrid(item)) != null) {
            vectorTileServer.setUtfGrid(utfGrid);
        }
        vectorTileServer.setBbox("");
        vectorTileServer.createGrid();
        Map<String, DataSource> dataSourceMap = this.getDataSourceMap(item);
        vectorTileServer.setDataSourceMap(dataSourceMap);
        Map<String, Layer> layerMap = this.getLayerMap(item, null, vectorTileServer.getId());
        vectorTileServer.setLayerMap(layerMap);
        return vectorTileServer;
    }

    private UtfGrid getUtfGrid(Element root) {
        Element item = root.element("UtfGrid");
        if (item == null) {
            return null;
        }
        UtfGrid utfGrid = new UtfGrid();
        this.getInfoByStr(item, utfGrid, UtfGrid.class, "BeginLevel,EndLevel,Sampling", true);
        return utfGrid;
    }

    private DataSet getLayoutDataSet(Element info, Map<String, DataSet> dataSetMap) {
        String layoutDataSetName = info.elementText("layoutDataSet");
        DataSet dataSet = null;
        if (layoutDataSetName == null) {
            layoutDataSetName = "";
        }
        if ("".equalsIgnoreCase(layoutDataSetName)) {
            Element items = (Element)info.element("DataSets").elements().get(0);
            layoutDataSetName = items.attributeValue("Id");
        }
        dataSet = dataSetMap.get(layoutDataSetName);
        return dataSet;
    }

    private Map<String, Layer> getLayerMap(Element root, Map<String, DataSet> dataSetMap, String serverName) {
        HashMap<String, Layer> layerMap = new HashMap<String, Layer>();
        List items = root.element("Layers").elements();
        for (Object item : items) {
            Layer layer = this.createLayer(root, (Element)item, dataSetMap, serverName);
            if (layer == null) continue;
            layerMap.put(layer.getId(), layer);
        }
        return layerMap;
    }

    private LayerDataSet[] buildLayerDataSet(Layer layer, Element root, Map<String, DataSet> dataSetMap) {
        HashSet<Integer> setLayerAllLevel = new HashSet<Integer>();
        Integer i = layer.getBeginLevel();
        while (i <= layer.getEndLevel()) {
            setLayerAllLevel.add(i);
            i = i + 1;
        }
        String groupField = layer.getGroupField();
        HashSet<Integer> dataSetLevel = new HashSet<Integer>();
        ArrayList<LayerDataSet> layerDataSetArr = new ArrayList<LayerDataSet>();
        List items = root.element("DataSet").elements();
        for (Object item : items) {
            String dataSetName = ((Element)item).getStringValue();
            LayerDataSet layerDataSet = new LayerDataSet();
            Integer begin = Integer.valueOf(((Element)item).attributeValue("begin"));
            Integer end = Integer.valueOf(((Element)item).attributeValue("end"));
            String filter = ((Element)item).attributeValue("filter");
            String cutOutScreen = ((Element)item).attributeValue("cutOutScreen");
            if (cutOutScreen != null && "false".equalsIgnoreCase(cutOutScreen)) {
                layerDataSet.setCutOutScreen(false);
            }
            Integer i2 = begin;
            while (i2 <= end) {
                if (dataSetLevel.contains(i2)) {
                    throw new RuntimeException("\u5df2\u7ecf\u914d\u7f6e\u8fc7\u56fe\u5c42 " + layer.getId() + " \u7684 " + i2 + " \u5c42\u6570\u636e\u6e90.");
                }
                dataSetLevel.add(i2);
                i2 = i2 + 1;
            }
            layerDataSet.setBegin(begin);
            layerDataSet.setEnd(end);
            layerDataSet.setDataSet(null);
            layerDataSet.setFilter(filter);
            layerDataSet.setLayerId(layer.getId());
            layerDataSetArr.add(layerDataSet);
        }
        Collections.sort(layerDataSetArr, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((LayerDataSet)o1).getBegin().compareTo(((LayerDataSet)o2).getBegin());
            }
        });
        if (!dataSetLevel.equals(setLayerAllLevel)) {
            throw new RuntimeException("\u6ca1\u6709\u914d\u7f6e\u56fe\u5c42 " + layer.getId() + " \u6240\u6709\u5c42\u7ea7\u7684\u6570\u636e\u6e90.");
        }
        return layerDataSetArr.toArray(new LayerDataSet[layerDataSetArr.size()]);
    }

    private Layer createLayer(Element root, Element info, Map<String, DataSet> dataSetMap, String serverName) {
        List levels = info.element("DataSet").elements("Level");
        String[] fields = null;
        List dataSets = root.element("DataSets").elements("DataSet");
        block8: for (Object ds : dataSets) {
            for (Object level : levels) {
                if (!((Element)level).getText().equals(((Element)ds).attributeValue("Id"))) continue;
                fields = ((Element)ds).element("Fields").getText().toLowerCase().split(",");
                continue block8;
            }
        }
        Layer layer = new Layer();
        layer.setServerName(serverName);
        this.getInfoByStr(info, layer, Layer.class, "Id,BeginLevel,EndLevel", true);
        LayerDataSet[] arr = this.buildLayerDataSet(layer, info, dataSetMap);
        if (arr == null) {
            return null;
        }
        layer.setLayerDataSetArr(arr);
        List items = new ArrayList();
        if (info.element("Levels") != null) {
            items = info.element("Levels").elements();
        }
        HashMap levelMap = new HashMap();
        for (Object item : items) {
            String simplify;
            AnnoLayerLevel layerLevel = new AnnoLayerLevel();
            layerLevel.setFields(fields);
            String filter = ((Element)item).elementText("Filter");
            layerLevel.setFilter(filter);
            String buffer = ((Element)item).elementText("Buffer");
            if (buffer != null) {
                layerLevel.setBuffer(Double.valueOf(buffer));
            }
            if ((simplify = ((Element)item).elementText("Simplify")) != null) {
                layerLevel.setSimplify(Boolean.valueOf(simplify));
            }
            String value = ((Element)item).attributeValue("Id");
            Integer level = 0;
            try {
                level = Integer.valueOf(value);
                layerLevel.setLevel(level);
            }
            catch (Exception e) {
                throw new RuntimeException("\u56fe\u5c42level\u5fc5\u987b\u662f\u6574\u6570\u578b");
            }
            String GridAtom = ((Element)item).elementText("GridAtom");
            Integer GridAtomInt = 0;
            try {
                GridAtomInt = Integer.valueOf(GridAtom);
                layerLevel.setGridAtom(GridAtomInt);
            }
            catch (Exception e) {
                throw new RuntimeException("level" + value + "\u7684GridAtom\u503c\u5fc5\u987b\u662f\u6574\u6570\u578b");
            }
            String GridAtomMaxPoint = ((Element)item).elementText("GridAtomMaxPoint");
            Integer GridAtomMaxPointInt = 0;
            try {
                GridAtomMaxPointInt = Integer.valueOf(GridAtomMaxPoint);
                layerLevel.setGridAtomMaxPoint(GridAtomMaxPointInt);
            }
            catch (Exception e) {
                throw new RuntimeException("level" + value + "\u7684GridAtomMaxPoint\u503c\u5fc5\u987b\u662f\u6574\u6570\u578b");
            }
            List after = new ArrayList();
            if (((Element)item).element("after") != null) {
                after = ((Element)item).element("after").elements();
                ArrayList<AnnoAfterSubtract> subtractLst = new ArrayList<AnnoAfterSubtract>();
                for (Object subtract : after) {
                    AnnoAfterSubtract annoAfter = new AnnoAfterSubtract();
                    Element subEle = (Element)subtract;
                    annoAfter.setValue(subEle.attributeValue("value"));
                    annoAfter.setDesc(subEle.attributeValue("desc"));
                    try {
                        annoAfter.setSubtract(Integer.valueOf(subEle.getTextTrim()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u6700\u5927\u683c\u7f51\u539f\u5b50\u70b9\u503c\u7684\u51cf\u53bb\u503c\u3010level>after>subtrace\u3011\uff1a " + subEle.getTextTrim() + "\u5fc5\u987b\u662f\u6574\u6570\u578b");
                    }
                    annoAfter.setField(subEle.attributeValue("key"));
                    subtractLst.add(annoAfter);
                }
                if (subtractLst.size() > 0) {
                    layerLevel.setSubtractLst(subtractLst);
                }
            }
            if (level > layer.getEndLevel() || level < layer.getBeginLevel()) continue;
            ((Map)levelMap).put(Integer.valueOf(value), layerLevel);
        }
        for (int i = layer.getBeginLevel().intValue(); i <= layer.getEndLevel(); ++i) {
            if (((Map)levelMap).get(i) != null) continue;
            AnnoLayerLevel layerLevel = new AnnoLayerLevel();
            layerLevel.setLevel(i);
            ((Map)levelMap).put(i, layerLevel);
        }
        layer.setLevelMap(levelMap);
        Element lebelElement = info.element("Label");
        if (lebelElement != null) {
            layer.setHaveLabel(true);
            Label label = new Label();
            String type = lebelElement.attributeValue("Type");
            if (type.equalsIgnoreCase(Constants.LabelType.line.name())) {
                label.setType(Constants.LabelType.line);
            }
            if (type.equalsIgnoreCase(Constants.LabelType.point.name())) {
                label.setType(Constants.LabelType.point);
                layer.setLabelOnly(true);
            }
            if (type.equalsIgnoreCase(Constants.LabelType.area.name())) {
                label.setType(Constants.LabelType.area);
            }
            layer.setLabel(label);
        }
        Element roadElement = info.element("road");
        RoadDeal rd = new RoadDeal();
        if (roadElement != null) {
            String isDeal = roadElement.elementText("deal").trim();
            boolean deal = isDeal == null ? false : Boolean.parseBoolean(isDeal);
            rd.setDeal(deal);
            String[] filters = roadElement.elementText("filter").trim().split(",");
            rd.setFilter(filters);
            String separation = roadElement.elementText("separation").trim();
            int s = separation == null ? 1 : Integer.parseInt(separation);
            rd.setSeparation(s);
        } else {
            rd.setDeal(false);
        }
        layer.setRoadDeal(rd);
        return layer;
    }

    private Map<String, DataSet> getDataSetMap(Element root, Map<String, DataSource> dataSourceMap) {
        HashMap<String, DataSet> dataSetMap = new HashMap<String, DataSet>();
        List items = root.element("DataSets").elements();
        for (Object item : items) {
            DataSet dataSet = this.createDataSet((Element)item, dataSourceMap);
            if (dataSet == null) continue;
            dataSetMap.put(dataSet.getId(), dataSet);
        }
        return dataSetMap;
    }

    private DataSet createDataSet(Element info, Map<String, DataSource> dataSourceMap) {
        String dataSourceName = info.elementText("DataSource");
        DataSource dataSource = dataSourceMap.get(dataSourceName);
        if (dataSource == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u540d\u79f0\u4e3a " + dataSourceName + " \u6570\u636e\u6e90");
        }
        if (!(dataSource.getType().equals((Object)Constants.TYPE.oracle) || dataSource.getType().equals((Object)Constants.TYPE.postgre) || dataSource.getType().equals((Object)DataSource.TYPE.oracle) || dataSource.getType().equals((Object)DataSource.TYPE.postgre))) {
            throw new RuntimeException("\u6570\u636e\u96c6\u7684\u6570\u636e\u6e90\u7c7b\u578b\u5fc5\u987b\u662foracle\u6216\u8005\u662fpostgre");
        }
        String oriFields = info.elementText("Fields");
        String refSelectFields = "";
        String annoFild = info.elementText("AnnoFild");
        boolean hasAnnoFild = false;
        boolean autoAddAnnoFile = true;
        if (autoAddAnnoFile) {
            System.out.println("\u68c0\u67e5\u662f\u5426\u6709" + annoFild + "\u5b57\u6bb5");
            if (!hasAnnoFild) {
                System.out.println("\u6ca1\u6709" + annoFild + "\u5b57\u6bb5");
                System.out.println("\u521b\u5efa" + annoFild + "\u5b57\u6bb5");
                String sql = "alter table " + AnnoSimplify.annoParas.newTableName + " ADD COLUMN " + annoFild + " integer";
                System.out.println("sql:" + sql);
                WorkspaceUtil.excuteSql(AnnoSimplify.annoParas.newDsKey, sql);
                try {
                    System.out.println("\u6682\u505c10\u79d2\uff0c\u7ed9\u6570\u636e\u5e93\u8db3\u591f\u65f6\u95f4\u521b\u5efa\u5b57\u6bb5\uff0c\u5426\u5219\u968f\u540e\u83b7\u53d6\u8868\u5143\u6570\u636e\u65f6\uff0c\u6709\u65f6\u83b7\u53d6\u4e0d\u5230\u6700\u65b0\u6dfb\u52a0\u7684\u5b57\u6bb5\uff01");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else {
                System.out.println("\u5b58\u5728" + annoFild + "\u5b57\u6bb5");
                System.out.println("\u6e05\u7a7a" + annoFild + "\u5b57\u6bb5\u7684\u503c");
                String sql = "update " + AnnoSimplify.annoParas.newTableName + " set " + annoFild + " = null where " + annoFild + " is not null";
                System.out.println("sql:" + sql);
                WorkspaceUtil.excuteSql(AnnoSimplify.annoParas.newDsKey, sql);
            }
            if (!oriFields.contains(annoFild)) {
                oriFields = oriFields + "," + annoFild;
            }
        }
        return null;
    }

    private Map<String, DataSource> getDataSourceMap(Element root) {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        List items = root.element("DataSources").elements();
        for (Object item : items) {
            DataSource dataSource = this.createDataSource((Element)item);
            dataSourceMap.put(dataSource.getId(), dataSource);
        }
        return dataSourceMap;
    }

    private DataSource createDataSource(Element info) {
        String type = info.elementText("Type");
        if ("oracle".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type)) {
            DbDataSource dbDataSource = new DbDataSource();
            this.getInfoByStr(info, dbDataSource, DbDataSource.class, "Url,Id,User,Password", true);
            dbDataSource.setDbType(type);
            return dbDataSource;
        }
        if ("mongodb".equalsIgnoreCase(type)) {
            MongodbDataSource mongodbDataSource = new MongodbDataSource();
            this.getInfoByStr(info, mongodbDataSource, MongodbDataSource.class, "Ip,Post,Namespace,Id,User,Password", true);
            return mongodbDataSource;
        }
        throw new RuntimeException("\u73b0\u5728\u4e0d\u652f\u6301 " + type + " \u7684\u6570\u636e\u5e93");
    }

    private <T extends BaseObject> void getInfoByStr(Element item, T t, Class<T> cla, String fieldsStr, Boolean strict) {
        String[] fieldArr;
        for (String field : fieldArr = fieldsStr.split(",")) {
            String value = null;
            value = "Id".equalsIgnoreCase(field) ? item.attributeValue("Id") : item.elementText(field);
            if (value != null) {
                value = value.trim();
            }
            field = field.substring(0, 1).toLowerCase() + field.substring(1);
            try {
                Field fieldRe = null;
                fieldRe = field.equalsIgnoreCase("gridUnit") ? cla.getSuperclass().getDeclaredField(field) : cla.getDeclaredField(field);
                fieldRe.setAccessible(true);
                if (field.equals("beginLevel") || field.equals("endLevel")) {
                    fieldRe.set(t, Integer.valueOf(value));
                    continue;
                }
                fieldRe.set(t, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                try {
                    Field fieldRe = cla.getSuperclass().getDeclaredField(field);
                    fieldRe.setAccessible(true);
                    fieldRe.set(t, value);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

