/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.raster;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.PixelDataType;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.raster.RasterPixelTypeCheckParam;
import com.geoway.dgt.geodata.util.RasterDataScan;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class RasterPixelTypeCheckTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        if (StringUtils.isNotBlank((CharSequence)batchInputData.getName())) {
            String[] nameArray;
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            for (String name : nameArray = batchInputData.getName().split(",")) {
                batchInputData.setName(null);
                batchInputData.setFilePath(new File(batchInputData.getFilePath(), name).getAbsolutePath());
                ToolHelper.callbackOne(batchInputData, new DataParam(), toolParam, oneDataCallback);
            }
        } else {
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            ArrayList<RasterFormatEnum> formats = new ArrayList<RasterFormatEnum>(0);
            formats.add(RasterFormatEnum.IMG);
            formats.add(RasterFormatEnum.TIF);
            formats.add(RasterFormatEnum.GRID);
            RasterDataScan rasterDataScan = new RasterDataScan(batchInputData.getFilePath(), formats, null);
            rasterDataScan.scan(data -> {
                DataParam dataParam = new DataParam();
                dataParam.setFilePath(new File((String)data).getAbsolutePath());
                dataParam.setName(FileUtil.getName((String)data));
                ToolHelper.callbackOne(dataParam, new DataParam(), toolParam, oneDataCallback);
            });
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(inputDataParam.getFilePath());
        IRasterDataset rasterDataset = rasterWorkspace.openRasterDataset(inputDataParam.getFilePath());
        RasterPixelTypeCheckParam rasterPixelTypeCheckParam = (RasterPixelTypeCheckParam)executeParam;
        PixelDataType pixelDataType = rasterDataset.getRasterInfo().getPixelDataType();
        this.invokeExcuteLog("\u6570\u636e\u50cf\u7d20\u7c7b\u578b\uff1a" + pixelDataType);
        executeResult.setSuccess(Boolean.valueOf(pixelDataType == rasterPixelTypeCheckParam.getPixelDataType()));
        if (!executeResult.getSuccess().booleanValue()) {
            this.invokeExcuteLog("\u6570\u636e\u50cf\u7d20\u7c7b\u578b\u4e0e\u6807\u51c6\u50cf\u7d20\u7c7b\u578b\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
        }
        rasterDataset.closeRaster();
        return executeResult;
    }
}

