/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.anno;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.anno.AnnoWrapLineParam;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class AnnoWrapLineTool
extends ToolBase {
    private final Analyzer analyzer = new IKAnalyzer(true);
    private final String wrapCode = " ";
    public static final int CHAR_USELESS = 0;
    public static final int CHAR_ARABIC = 1;
    public static final int CHAR_ENGLISH = 2;
    public static final int CHAR_CHINESE = 4;
    public static final int CHAR_OTHER_CJK = 8;
    public static final int CHAR_PUNCTUATION_CJK = 16;

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName(batchInputData.getName());
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a" + inputDataParam.getName());
        IFeatureWorkspace workspace = null;
        ICursor updateCursor = null;
        int successCount = 0;
        int failCount = 0;
        try {
            GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
            workspace = geoDatabaseService.openGeoWorkspace(inputDataParam.getDsKey());
            ITable table = workspace.openTable(inputDataParam.getName());
            if (table == null) {
                this.invokeExcuteLog("\u6570\u636e\u6253\u5f00\u5931\u8d25", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult2 = executeResult;
                return executeResult2;
            }
            if (table.getOidFieldName() == null) {
                this.invokeExcuteLog("\u6570\u636e\u6ca1\u6709\u4e3b\u952e", TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult3 = executeResult;
                return executeResult3;
            }
            AnnoWrapLineParam annoWrapLineParam = (AnnoWrapLineParam)executeParam;
            IField annoField = table.getFields().findField(annoWrapLineParam.getAnnoField());
            if (annoField == null) {
                this.invokeExcuteLog("\u6ce8\u8bb0\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + annoWrapLineParam.getAnnoField(), TaskLogLevelEnum.Error);
                executeResult.setSuccess(Boolean.valueOf(false));
                ExecuteResult executeResult4 = executeResult;
                return executeResult4;
            }
            IField newAnnoField = table.getFields().findField(annoWrapLineParam.getNewAnnoField());
            if (newAnnoField == null) {
                newAnnoField = new Field();
                newAnnoField.setName(annoWrapLineParam.getNewAnnoField().trim());
                newAnnoField.setAliasName(newAnnoField.getName());
                newAnnoField.setFieldType(FieldType.String);
                newAnnoField.setLength(Integer.valueOf(400));
                if (!table.addField(newAnnoField)) {
                    this.invokeExcuteLog("\u6362\u884c\u5b57\u6bb5\u521b\u5efa\u5931\u8d25", TaskLogLevelEnum.Error);
                    executeResult.setSuccess(Boolean.valueOf(false));
                    ExecuteResult executeResult5 = executeResult;
                    return executeResult5;
                }
                this.invokeExcuteLog("\u521b\u5efa\u6362\u884c\u5b57\u6bb5\uff1a" + annoWrapLineParam.getNewAnnoField());
            }
            workspace.beginTransaction();
            QueryFilter filter = new QueryFilter();
            filter.setSubFields(table.getOidFieldName() + "," + annoField.getName() + "," + newAnnoField.getName());
            updateCursor = table.updateRow((IQueryFilter)filter);
            IRow row = updateCursor.nextRow();
            while (row != null) {
                String value = this.valueOf(row.getValue(annoField.getName()));
                String currentWrapValue = this.valueOf(row.getValue(newAnnoField.getName()));
                String newValue = value;
                boolean success = true;
                if (!StringUtil.isEmpty((String)value) || value.length() > annoWrapLineParam.getMaxLength()) {
                    try {
                        newValue = this.buildNewStr(value, annoWrapLineParam.getMaxLength());
                    }
                    catch (Exception e2) {
                        this.invokeExcuteLog(String.format("[%s]-[%s]\u6362\u884c\u5931\u8d25", row.getObjectId(), value), e2);
                        success = false;
                    }
                }
                if (!StringUtil.equals((String)currentWrapValue, (String)newValue)) {
                    row.setValue(newAnnoField.getName(), (Object)newValue);
                    updateCursor.updateRow(row);
                }
                if (success) {
                    ++successCount;
                } else {
                    ++failCount;
                }
                row = updateCursor.nextRow();
            }
            this.invokeExcuteLog(String.format("[%s]\u6362\u884c\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", inputDataParam.getName(), successCount, failCount));
            executeResult.setSuccess(Boolean.valueOf(failCount == 0));
        }
        catch (Exception e) {
            this.invokeExcuteLog(String.format("[%s]\u6362\u884c\u5931\u8d25", inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
            if (workspace != null) {
                workspace.commitTransaction();
                workspace.close();
            }
        }
        return executeResult;
    }

    private String valueOf(Object value) {
        return value == null ? null : value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildNewStr(String value, int maxLength) throws IOException {
        if (value == null) {
            return null;
        }
        if (this.getStringLength(value = value.trim()) <= maxLength * 2) {
            return value.replaceAll(" ", "&nbsp;");
        }
        String newValue = null;
        TokenStream ts = null;
        try {
            ts = this.analyzer.tokenStream("myfield", (Reader)new StringReader(value));
            CharTermAttribute term = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            String line1 = "";
            String line2 = "";
            String line1_2 = "";
            String line2_2 = "";
            String line1_3 = "";
            String line2_3 = "";
            ArrayList<String> i = new ArrayList<String>();
            while (ts.incrementToken()) {
                i.add(term.toString());
            }
            if (i.size() == 0) {
                String string = value.replaceAll(" ", "&nbsp;");
                return string;
            }
            int l = this.getStringLength(value) / 2;
            for (String string : i) {
                if (line2.isEmpty() && (line1.isEmpty() || this.getStringLength(line1) + this.getStringLength(string) <= l)) {
                    line1 = line1 + string;
                    continue;
                }
                line2 = line2 + string;
            }
            boolean mark = false;
            for (String v : i) {
                if (line2_2.isEmpty() && (line1_2.isEmpty() || !mark)) {
                    if (this.getStringLength(line1_2) + this.getStringLength(v) > l) {
                        mark = true;
                    }
                    line1_2 = line1_2 + v;
                    continue;
                }
                line2_2 = line2_2 + v;
            }
            boolean bl = false;
            int beforeCharType = -1;
            for (String v : i) {
                int n = AnnoWrapLineTool.identifyCharType(v.charAt(0));
                if (line2_3.isEmpty() && (line1_3.isEmpty() || n == beforeCharType || v.trim().isEmpty() || n == 0 || n == 1 || n == 16 || n == 8 || beforeCharType == -1)) {
                    line1_3 = line1_3 + v;
                } else {
                    line2_3 = line2_3 + v;
                }
                if (n != 2 && n != 4) continue;
                beforeCharType = n;
            }
            int len1_3 = this.getStringLength(line1_3);
            int len2_3 = this.getStringLength(line2_3);
            newValue = !line2_3.isEmpty() && Math.abs(len1_3 - len2_3) < len1_3 * 2 && Math.abs(len1_3 - len2_3) / 2 < len2_3 * 2 ? line1_3.trim().replaceAll(" ", "&nbsp;") + this.wrapCode + line2_3.trim().replaceAll(" ", "&nbsp;") : (Math.abs(this.getStringLength(line1) - this.getStringLength(line2)) >= Math.abs(this.getStringLength(line1_2) - this.getStringLength(line2_2)) ? line1_2.trim().replaceAll(" ", "&nbsp;") + this.wrapCode + line2_2.trim().replaceAll(" ", "&nbsp;") : line1.trim().replaceAll(" ", "&nbsp;") + this.wrapCode + line2.trim().replaceAll(" ", "&nbsp;"));
            ts.reset();
            String string = newValue;
            return string;
        }
        finally {
            if (ts != null) {
                try {
                    ts.reset();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int getStringLength(String str) {
        try {
            return str.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str.length();
        }
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> lineStr = new ArrayList<String>();
        lineStr.add("\u901f8\u9152\u5e97\u5317\u4eac\u738b\u5e9c\u4e95\u7f8e\u672f\u9986\u540e\u8857\u5e97\uff08\u5185\u5bbe\uff09");
        lineStr.add("\u5e7f\u4e1c\u7701\u81ea\u7136\u8d44\u6e90\u5385");
        lineStr.add("\u5e7f\u4e1c\u7701\u751f\u6001\u73af\u5883\u5385");
        lineStr.add("\u5e7f\u5dde\u9999\u683c\u91cc\u62c9\u5927\u9152\u5e97");
        lineStr.add("\u5e7f\u4e1c\u7701\u79d1\u5b66\u6280\u672f\u5385");
        lineStr.add("\u8d8a\u79c0\u533a\u56fd\u5bb6\u7a0e\u52a1\u5c40");
        lineStr.add("\u9038\u7c73\u516c\u5bd3\u4e0a\u4e0b\u4e5d\u6b65\u884c\u8857\u4e8c\u5e97");
        lineStr.add("\u5e7f\u4e1c\u7701\u4e2d\u533b\u9662\u6025\u8bca");
        lineStr.add("\u9f99\u6d25\u8857\u6587\u5b89\u793e\u533a\u536b\u751f\u670d\u52a1\u7ad9");
        lineStr.add("\u8354\u6e7e\u533a\u8d28\u91cf\u6280\u672f\u76d1\u7763\u5c40");
        lineStr.add("\u4f5b\u5c71\u5e02\u7b2c\u56db\u4eba\u6c11\u533b\u9662");
        lineStr.add("\u5e7f\u5dde\u5e02\u4e2d\u897f\u533b\u7ed3\u5408\u533b\u9662");
        lineStr.add("\u82b1\u90fd\u533a\u7ecf\u6d4e\u8d38\u6613\u5c40");
        lineStr.add("\u82b1\u90fd\u51fa\u5165\u5883\u68c0\u9a8c\u68c0\u75ab\u5c40");
        lineStr.add("PH\u00d3 \u6b63\u5b97\u8d8a\u5357\u7c89");
        lineStr.add("\u5e03\u4e01\u9152\u5e97\u4e0a\u6d77\u677e\u6c5f\u6b22\u4e50\u8c37\u5927\u5b66\u57ce\u7684\u4f53\u80b2\u9986\u5e97");
        lineStr.add("McDonald's");
        lineStr.add("Holiday Inn Express Shanghai Jinqiao Central");
        lineStr.add("\u4e2d\u56fd\u94f6\u884c=\u7389\u6811\u8def\u652f\u884c");
        lineStr.add("Green Cow \u7eff\u725b\u9910\u5385");
        lineStr.add("Parlor \u9999");
        lineStr.add("\u0627\u0644\u0645\u0633\u0644\u0645\u0648\u0646 \u0627\u0644\u0635\u064a\u0646\u064a\u0648\u0646");
        lineStr.add("Hacker-Pschorr Br\u00e4uhaus");
        lineStr.add("\u91e3\u9b5a\u516c\u77f3 Old Fisherman's Rock");
        lineStr.add("UBND ph\u01b0\u1eddng Tr\u1ea7n Ph\u00fa");
        lineStr.add("Basketballcourt (Leisure Centre)");
        lineStr.add("China Pu'er tea exposition garden \u4e2d\u534e\u666e\u6d31\u8336\u535a\u89c8\u82d1");
        lineStr.add("\u0421\u0442\u0435\u043b\u0430 \"\u0414\u0430\u043b\u044c\u043d\u0435\u0440\u0435\u0447\u0435\u043d\u0441\u043a\"");
        lineStr.add("\u0413\u0435\u0440\u043e\u044f\u043c \u043e. \u0414\u0430\u043c\u0430\u043d\u0441\u043a\u0438\u0439");
        lineStr.add("Public Security Bureau / visa extension");
        lineStr.add("guesthouse/supermarket 30yuan/bed");
        lineStr.add("\u0628\u0627\u0632\u0627\u0631 \u0627\u0633\u062a\u0648\u0643 \u0686\u064a\u0646 \u0641\u0648\u0646\u06af");
        lineStr.add("Ch\u1ee3 Trung t\u00e2m Ho\u00e0ng Su Ph\u00ec");
        lineStr.add("Toys\"R\"Us");
        lineStr.add("Alves Caf\u00e9");
        lineStr.add("\u9ad8\u6d41\u7063(1)\u516c\u5ec1 Ko Lau Wan Site (1) Public Toilet");
        lineStr.add("\u9ad8\u6d41\u7063\uff081\uff09\u516c\u5ec1 Ko Lau Wan Site (1) Public Toilet");
        lineStr.add("\u9ad8\u6d41\u7063\u516c\u5ec1 Ko Lau Wan Site (1) Public Toilet");
        lineStr.add("\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u0435\u043d\u0438\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f");
        lineStr.add("\u041f\u043e\u043b\u0438\u0446\u0438\u044f, \u0413\u0418\u0411\u0414\u0414");
        lineStr.add("\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0420\u0430\u0439\u043e\u043d\u043d\u0430\u044f \u0410\u043f\u0442\u0435\u043a\u0430");
        lineStr.add("24\u5c0f\u65f6\u81ea\u52a9\u94f6\u884c - 24h self-service ATM");
        lineStr.add("L\u00fd Qu\u1ed1c Th\u1eafng homestay");
        lineStr.add("Suning.com");
        lineStr.add("\u826e\u79cb\u58a9\u897f\u5317\u531d\u905302-1\u81ea\u884c\u8f66\u79df\u8d41\u70b9");
        lineStr.add("D\u00e9cathlon");
        AnnoWrapLineTool tool = new AnnoWrapLineTool();
        for (String value : lineStr) {
            System.out.println(tool.buildNewStr(value, 7));
        }
    }

    static int identifyCharType(char input) {
        if (input >= '0' && input <= '9') {
            return 1;
        }
        if (input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z' || input == '-' || input == '_' || input == '\'' || input == '.' || input == '@' || input == '#' || input == '(' || input == ')' || input == '[' || input == ']' || input == '{' || input == '}') {
            return 2;
        }
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(input);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return 4;
        }
        if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HANGUL_JAMO || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || ub == Character.UnicodeBlock.HIRAGANA || ub == Character.UnicodeBlock.KATAKANA || ub == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS) {
            return 8;
        }
        if (ub == Character.UnicodeBlock.BASIC_LATIN) {
            return 16;
        }
        return 2;
    }
}

