/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.postgis;

import com.geoway.dgt.geodata.annosimplify.postgis.ValueGetter;
import com.geoway.dgt.geodata.annosimplify.postgis.binary.ByteGetter;

public class PostGISSpatial2 {
    public static double[] getPoint(byte[] value) throws Exception {
        ByteGetter.BinaryByteGetter bytes = new ByteGetter.BinaryByteGetter(value);
        ValueGetter data = null;
        if (bytes.get(0) == 0) {
            data = new ValueGetter.XDR(bytes);
        } else if (bytes.get(0) == 1) {
            data = new ValueGetter.NDR(bytes);
        } else {
            throw new IllegalArgumentException("Unknown Endian type:" + bytes.get(0));
        }
        byte endian = data.getByte();
        if (endian != data.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveS = (typeword & 0x20000000) != 0;
        int srid = -1;
        if (haveS) {
            srid = data.getInt();
        }
        if (realtype == 1) {
            return new double[]{data.getDouble(), data.getDouble()};
        }
        throw new IllegalArgumentException("\u4e0d\u662f\u70b9\u7c7b\u578b! Unknown type:" + realtype);
    }
}

