/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.supplier;

import com.geoway.dgt.geodata.annosimplify.AnnoLog;
import com.geoway.dgt.geodata.annosimplify.AnnoSimplify;
import com.geoway.dgt.geodata.annosimplify.AnnoType;
import com.geoway.dgt.geodata.annosimplify.grid.extent.GridExtent;
import com.geoway.dgt.geodata.annosimplify.supplier.AnnoSupplier;
import com.geoway.dgt.geodata.annosimplify.supplier.ISupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;

public class StatisticsSupplier
extends AnnoSupplier<List<Double>, Boolean>
implements ISupplier<List<Double>> {
    protected static final AnnoLog logger = new AnnoLog(StatisticsSupplier.class);
    public static final Map<Integer, Long> chp = new TreeMap<Integer, Long>();

    private StatisticsSupplier() {
        this.at = AnnoType.STATISTICS;
    }

    public static ISupplier<List<Double>> getStatisticsSupplier() {
        chp.clear();
        return InstanceHolder.ss;
    }

    @Override
    public BiFunction<List<Double>, List<Double>, List<Double>> combineSupplier() {
        BiFunction<List<Double>, List<Double>, List<Double>> combinSullier = (result1, result2) -> {
            List sb = null;
            if (result1 != null && !result1.isEmpty()) {
                sb = result1;
            }
            if (result2 != null && !result2.isEmpty()) {
                if (sb != null) {
                    sb.set(0, (Double)sb.get(0) + (Double)result2.get(0));
                    sb.set(1, (Double)sb.get(1) + (Double)result2.get(1));
                } else {
                    sb = result2;
                }
            }
            return sb;
        };
        return combinSullier;
    }

    @Override
    protected Boolean handleFeature(int gridAtomMaxPoint, int[][] simplifiedGridNum, int leftNum, int rightNum, Map m, StringBuffer sb) {
        int[] nArray = simplifiedGridNum[leftNum];
        int n = rightNum;
        nArray[n] = nArray[n] + 1;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Double> endCirculateFeatures(int[][] simplifiedGridNum, StringBuffer sb, GridExtent extent, int gridAtomMaxPoint) {
        double expectation = AnnoSimplify.annoParas.expectation[extent.getLevel()];
        Double standardDeviationOfExpectation = 0.0;
        Double standardDeviationOfMax = 0.0;
        int sizej = simplifiedGridNum.length;
        for (int j = 0; j < sizej; ++j) {
            int sizek = simplifiedGridNum[j].length;
            for (int k = 0; k < sizek; ++k) {
                standardDeviationOfMax = standardDeviationOfMax + Math.pow(simplifiedGridNum[j][k] - gridAtomMaxPoint, 2.0);
                standardDeviationOfExpectation = standardDeviationOfExpectation + Math.pow((double)simplifiedGridNum[j][k] - expectation, 2.0);
                Map<Integer, Long> map = chp;
                synchronized (map) {
                    if (chp.containsKey(simplifiedGridNum[j][k])) {
                        chp.put(simplifiedGridNum[j][k], chp.get(simplifiedGridNum[j][k]) + 1L);
                    } else {
                        chp.put(simplifiedGridNum[j][k], 1L);
                    }
                    continue;
                }
            }
        }
        ArrayList<Double> lLst = new ArrayList<Double>();
        lLst.add(standardDeviationOfMax);
        lLst.add(standardDeviationOfExpectation);
        return lLst;
    }

    @Override
    protected Boolean handlerK(Boolean k) {
        return false;
    }

    private static class InstanceHolder {
        public static ISupplier<List<Double>> ss = new StatisticsSupplier();

        private InstanceHolder() {
        }
    }
}

