/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.srs;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.srs.RasterSpatialRefTransferParam;
import com.geoway.dgt.geodata.util.RasterDataScan;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Vector;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.WarpOptions;
import org.gdal.gdal.gdal;
import org.springframework.util.Assert;

public class RasterSpatialRefTransferTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        RasterSpatialRefTransferParam transferParam = (RasterSpatialRefTransferParam)toolParam;
        if (transferParam.getOutputSrid() == null) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8f93\u51fa\u7a7a\u95f4\u53c2\u8003");
        }
        if (StringUtils.isBlank((CharSequence)batchOutputData.getFilePath())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u76ee\u6807\u6570\u636e\u8def\u5f84");
        }
        if (StringUtils.isNotBlank((CharSequence)batchInputData.getName())) {
            String[] nameArray;
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            for (String name : nameArray = batchInputData.getName().split(",")) {
                batchInputData.setName(null);
                batchInputData.setFilePath(new File(batchInputData.getFilePath(), name).getAbsolutePath());
                ToolHelper.callbackOne(batchInputData, batchOutputData, toolParam, oneDataCallback);
            }
        } else {
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            ArrayList<RasterFormatEnum> formats = new ArrayList<RasterFormatEnum>(0);
            formats.add(RasterFormatEnum.IMG);
            formats.add(RasterFormatEnum.TIF);
            formats.add(RasterFormatEnum.GRID);
            RasterDataScan rasterDataScan = new RasterDataScan(batchInputData.getFilePath(), formats, null);
            rasterDataScan.scan(data -> {
                DataParam dataParam = new DataParam();
                dataParam.setFilePath(new File((String)data).getAbsolutePath());
                dataParam.setName(FileUtil.getName((String)data));
                ToolHelper.callbackOne(dataParam, batchOutputData, toolParam, oneDataCallback);
            });
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputDataPath);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(inputDataParam.getFilePath());
        IRasterDataset rasterDataset = rasterWorkspace.openRasterDataset(inputDataParam.getFilePath());
        RasterSpatialRefTransferParam transferParam = (RasterSpatialRefTransferParam)executeParam;
        ISpatialReferenceSystem spatialReferenceSystem = rasterDataset.getRasterInfo().getSpatialReferenceSystem();
        if (spatialReferenceSystem == null) {
            this.invokeExcuteLog("\u539f\u59cb\u6570\u636e\u7a7a\u95f4\u53c2\u8003\u4e3a\u7a7a\uff01", TaskLogLevelEnum.Error);
        } else {
            this.invokeExcuteLog("\u539f\u59cb\u6570\u636e\u7a7a\u95f4\u53c2\u8003\uff1a" + spatialReferenceSystem.getSrid());
        }
        String targetFile = Paths.get(outputDataParam.getFilePath(), FileUtil.getName((String)inputDataParam.getFilePath())).toAbsolutePath().toString();
        this.setOutputSrid(rasterDataset.getRaster(), targetFile, transferParam.getOutputSrid());
        rasterDataset.closeRaster();
        executeResult.setSuccess(Boolean.valueOf(true));
        return executeResult;
    }

    protected void setOutputSrid(Dataset dataset, String targetFile, Integer targetSrid) {
        Vector<String> vector = new Vector<String>();
        vector.add("-t_srs");
        vector.add(String.format("EPSG:%d", targetSrid));
        vector.add("-dstalpha");
        WarpOptions options = new WarpOptions(vector);
        Dataset[] srcDatasets = new Dataset[]{dataset};
        Dataset snapshotDataset = gdal.Warp((String)targetFile, (Dataset[])srcDatasets, (WarpOptions)options);
        this.invokeExcuteLog("\u8f6c\u6362\u540e\u7684\u6570\u636e\u7a7a\u95f4\u53c2\u8003\uff1a" + targetSrid);
        if (snapshotDataset != null) {
            snapshotDataset.delete();
        }
    }
}

