/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.config;

import com.geoway.dgt.geodata.annosimplify.config.AnnoVectorTileServer;
import com.geoway.dgt.geodata.annosimplify.config.XmlConfigLoader;
import com.geoway.dgt.geodata.annosimplify.config.server.impl.VectorTileServer;
import com.geoway.dgt.geodata.annosimplify.exception.ParaException;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AnnoXmlConfigLoader {
    private final XmlConfigLoader config = new XmlConfigLoader();

    public void setStrict(Boolean strict) {
        this.config.setStrict(strict);
    }

    public void load(String strXmlFile) throws Exception {
        this.config.load(strXmlFile);
    }

    public List<AnnoVectorTileServer> getAnnoServerListByXml(String strXmlFile) throws Exception {
        String url = URLDecoder.decode(strXmlFile, "utf-8");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(url));
        return this.getAnnoServerList(document);
    }

    public List<AnnoVectorTileServer> getAnnoServerListByStr(String strXmlStr) throws Exception {
        Document document = DocumentHelper.parseText((String)strXmlStr);
        return this.getAnnoServerList(document);
    }

    private List<AnnoVectorTileServer> getAnnoServerList(Document document) throws Exception {
        Element root = document.getRootElement();
        List items = root.element("VectorTileServers").elements();
        List<VectorTileServer> inLst = this.config.getServerList(document);
        ArrayList<AnnoVectorTileServer> outLst = new ArrayList<AnnoVectorTileServer>();
        int i = 0;
        Iterator it = items.iterator();
        while (it.hasNext()) {
            AnnoVectorTileServer avServer = new AnnoVectorTileServer(inLst.get(i++));
            Element item = (Element)it.next();
            String bbox = item.element("DataSets").element("DataSet").elementText("Box");
            String annoFild = item.element("DataSets").element("DataSet").elementText("AnnoFild");
            avServer.setAnnoFild(annoFild);
            avServer.setBbox(item.elementText("NewBox"));
            avServer.setNewAnnoFild(item.elementText("NewAnnoFild"));
            avServer.setNewBox(item.elementText("NewBox"));
            avServer.setNewFields(item.elementText("NewFields"));
            avServer.setNewIdField(item.elementText("NewIdField"));
            avServer.setNewSort(item.elementText("NewSort"));
            avServer.setNewSrid(item.elementText("NewSrid"));
            avServer.setNewShapeField(item.elementText("NewShapeField"));
            avServer.setNewDsKey(item.elementText("NewDsKey"));
            avServer.setNewTableName(item.elementText("NewTableName"));
            String Simplify = item.elementText("Simplify");
            if (!Simplify.equalsIgnoreCase("true") && !Simplify.equalsIgnoreCase("false")) {
                throw new ParaException("Simplify\u53c2\u6570\u9519\u8bef\uff0c\u5e94\u4e3atrue\u6216false");
            }
            avServer.setSimplify(Boolean.valueOf(Simplify));
            String Statistics = item.elementText("Statistics");
            if (!Statistics.equalsIgnoreCase("true") && !Statistics.equalsIgnoreCase("false")) {
                throw new ParaException("Statistics\u53c2\u6570\u9519\u8bef\uff0c\u5e94\u4e3atrue\u6216false");
            }
            avServer.setStatistics(Boolean.valueOf(Statistics));
            outLst.add(avServer);
        }
        return outLst;
    }
}

