/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterDataScan {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private IFileset path;
    private List<RasterFormatEnum> formats;
    private Pattern fileNamePattern;

    public RasterDataScan(String path, List<RasterFormatEnum> formats, String namePattern) {
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(path, null, null);
        fileStorage.connect();
        this.path = fileStorage.getFile(path);
        this.formats = formats;
        if (formats == null) {
            this.formats = this.getAllFormats();
        }
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    public RasterDataScan(IFileset path, List<RasterFormatEnum> formats, String namePattern) {
        this.path = path;
        this.formats = formats;
        if (formats == null) {
            this.formats = this.getAllFormats();
        }
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    private List<RasterFormatEnum> getAllFormats() {
        ArrayList<RasterFormatEnum> formats = new ArrayList<RasterFormatEnum>(0);
        formats.add(RasterFormatEnum.TIF);
        formats.add(RasterFormatEnum.IMG);
        formats.add(RasterFormatEnum.GRID);
        formats.add(RasterFormatEnum.NSDTFDEM);
        return formats;
    }

    public int scan(Consumer<String> scannedOneData) {
        return this.scanRecursive(this.path, -1, 0, scannedOneData);
    }

    public int scan(int maxDepth, Consumer<String> scannedOneData) {
        return this.scanRecursive(this.path, maxDepth, 0, scannedOneData);
    }

    private int scanRecursive(IFileset currentPath, int maxDepth, int currentDepth, Consumer<String> scannedOneData) {
        List subFiles;
        if (maxDepth >= 0 && currentDepth > maxDepth) {
            return 0;
        }
        int count = 0;
        for (RasterFormatEnum format : this.formats) {
            if (!this.isMatchFormat(currentPath, format)) continue;
            scannedOneData.accept(currentPath.getFullPath());
            return ++count;
        }
        if (currentPath.getIsDirectory() && (subFiles = currentPath.listFiles()) != null) {
            for (IFileset file : subFiles) {
                count += this.scanRecursive(file, maxDepth, currentDepth + 1, scannedOneData);
            }
        }
        return count;
    }

    private boolean isMatchFormat(IFileset file, RasterFormatEnum format) {
        switch (format) {
            case TIF: {
                return this.isFile(file, ".tif") || this.isFile(file, ".tiff");
            }
            case IMG: {
                return this.isFile(file, ".img");
            }
            case GRID: {
                return this.isGrid(file);
            }
            case NSDTFDEM: {
                return this.isFile(file, ".dem");
            }
        }
        this.log.warn("\u4e0d\u652f\u6301\u7684\u6805\u683c\u6570\u636e\u683c\u5f0f\uff1a" + format);
        return false;
    }

    private boolean isFile(IFileset file, String ext) {
        return !file.getIsDirectory() && ext.equalsIgnoreCase(FileUtil.getExtension((String)file.getName())) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)file.getName())).matches());
    }

    private boolean isGrid(IFileset file) {
        IFileStorage fileStorage = file.getFileStorage();
        return file.getIsDirectory() && fileStorage.fileExist(fileStorage.combinePaths(file.getFullPath(), new String[]{"w001001.adf"})) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)file.getName())).matches());
    }
}

