/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorDataScan {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private IFileset path;
    private List<VectorFormatEnum> formats;
    private Pattern fileNamePattern;

    public VectorDataScan(String path, List<VectorFormatEnum> formats, String namePattern) {
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(path, null, null);
        fileStorage.connect();
        this.path = fileStorage.getFile(path);
        this.formats = formats;
        if (formats == null) {
            this.formats = this.getAllFormats();
        }
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    public VectorDataScan(IFileset path, List<VectorFormatEnum> formats, String namePattern) {
        this.path = path;
        this.formats = formats;
        if (formats == null) {
            this.formats = this.getAllFormats();
        }
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    private List<VectorFormatEnum> getAllFormats() {
        ArrayList<VectorFormatEnum> formats = new ArrayList<VectorFormatEnum>(0);
        formats.add(VectorFormatEnum.MDB);
        formats.add(VectorFormatEnum.FileGDB);
        formats.add(VectorFormatEnum.Shapefile);
        formats.add(VectorFormatEnum.GeoPackage);
        formats.add(VectorFormatEnum.GeoJson);
        formats.add(VectorFormatEnum.S57);
        formats.add(VectorFormatEnum.E00);
        formats.add(VectorFormatEnum.DXF);
        formats.add(VectorFormatEnum.Mapgis);
        formats.add(VectorFormatEnum.MapInfo);
        return formats;
    }

    public int scan(Consumer<String> scannedOneData) {
        return this.scanRecursive(this.path, -1, 0, scannedOneData);
    }

    public int scan(int maxDepth, Consumer<String> scannedOneData) {
        return this.scanRecursive(this.path, maxDepth, 0, scannedOneData);
    }

    private int scanRecursive(IFileset currentPath, int maxDepth, int currentDepth, Consumer<String> scannedOneData) {
        List subFiles;
        if (maxDepth >= 0 && currentDepth > maxDepth) {
            return 0;
        }
        int count = 0;
        for (VectorFormatEnum format : this.formats) {
            if (!this.isMatchFormat(currentPath, format)) continue;
            scannedOneData.accept(currentPath.getFullPath());
            return ++count;
        }
        if (currentPath.getIsDirectory() && (subFiles = currentPath.listFiles()) != null) {
            for (IFileset file : subFiles) {
                count += this.scanRecursive(file, maxDepth, currentDepth + 1, scannedOneData);
            }
        }
        return count;
    }

    private boolean isMatchFormat(IFileset file, VectorFormatEnum format) {
        switch (format) {
            case MDB: {
                return this.isFile(file, ".mdb");
            }
            case FileGDB: {
                return this.isFileGDB(file);
            }
            case Shapefile: {
                return this.isShapefile(file);
            }
            case GeoJson: {
                return this.isFile(file, ".geojson");
            }
            case MapInfo: {
                return this.isFile(file, ".mif");
            }
            case GeoPackage: {
                return this.isFile(file, ".gpkg");
            }
            case S57: {
                return this.isFile(file, ".000");
            }
            case E00: {
                return this.isFile(file, ".e00");
            }
            case DXF: {
                return this.isFile(file, ".dxf");
            }
            case Mapgis: {
                return this.isFile(file, ".wat") || this.isFile(file, ".wal") || this.isFile(file, ".wap");
            }
        }
        this.log.warn("\u4e0d\u652f\u6301\u7684\u77e2\u91cf\u6570\u636e\u683c\u5f0f\uff1a" + format);
        return false;
    }

    private boolean isFile(IFileset file, String ext) {
        return !file.getIsDirectory() && ext.equalsIgnoreCase(FileUtil.getExtension((String)file.getName())) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)file.getName())).matches());
    }

    private boolean isFileGDB(IFileset file) {
        IFileStorage fileStorage = file.getFileStorage();
        return file.getIsDirectory() && FileUtil.getExtension((String)file.getName()).equalsIgnoreCase(".gdb") && fileStorage.fileExist(fileStorage.combinePaths(file.getFullPath(), new String[]{"gdb"})) && (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)file.getName())).matches());
    }

    private boolean isShapefile(IFileset file) {
        if (!file.getIsDirectory()) {
            return false;
        }
        List subFiles = file.listFiles();
        if (subFiles != null) {
            for (IFileset subFile : subFiles) {
                if (subFile.getIsDirectory() || !".shp".equalsIgnoreCase(FileUtil.getExtension((String)subFile.getName()))) continue;
                return this.fileNamePattern == null || this.fileNamePattern.matcher(file.getName()).matches();
            }
        }
        return false;
    }
}

