/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.annosimplify.utils;

import java.util.BitSet;
import java.util.HashMap;

public class Geohash {
    private static int numbits = 30;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final HashMap<Character, Integer> lookup = new HashMap();

    public static void main(String[] args) throws Exception {
        System.out.println(new Geohash().encode(30.2587482998942, 120.153782900261));
        System.out.println(new Geohash().encode(30.2523724995912, 120.174004900206));
        System.out.println(new Geohash().decode("wtmknhmmfpd0msendmw0")[1]);
        System.out.println(new Geohash().decode("wtmknhmmfpd0msendmw0")[0]);
        System.out.println(new Geohash().decode("wtmknek0c6bz329cm11h")[1]);
        System.out.println(new Geohash().decode("wtmknek0c6bz329cm11h")[0]);
    }

    public double[] decode(String geohash) {
        boolean isSet;
        int i;
        StringBuilder buffer = new StringBuilder();
        for (char c : geohash.toCharArray()) {
            int i2 = lookup.get(Character.valueOf(c)) + 32;
            buffer.append(Integer.toString(i2, 2).substring(1));
        }
        BitSet lonset = new BitSet();
        BitSet latset = new BitSet();
        int j = 0;
        for (i = 0; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            lonset.set(j++, isSet);
        }
        j = 0;
        for (i = 1; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            latset.set(j++, isSet);
        }
        double lon = this.decode(lonset, -180.0, 180.0)[0];
        double lat = this.decode(latset, -90.0, 90.0)[0];
        return new double[]{lat, lon};
    }

    private double[] decode(BitSet bs, double floor, double ceiling) {
        double mid = 0.0;
        for (int i = 0; i < bs.length(); ++i) {
            mid = (floor + ceiling) / 2.0;
            if (bs.get(i)) {
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return new double[]{mid, ceiling, floor};
    }

    public String encode(double lat, double lon) {
        BitSet latbits = this.getBits(lat, -90.0, 90.0);
        BitSet lonbits = this.getBits(lon, -180.0, 180.0);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numbits; ++i) {
            buffer.append(lonbits.get(i) ? (char)'1' : '0');
            buffer.append(latbits.get(i) ? (char)'1' : '0');
        }
        return Geohash.base32(Long.parseLong(buffer.toString(), 2));
    }

    private BitSet getBits(double lat, double floor, double ceiling) {
        BitSet buffer = new BitSet(numbits);
        for (int i = 0; i < numbits; ++i) {
            double mid = (floor + ceiling) / 2.0;
            if (lat >= mid) {
                buffer.set(i);
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return buffer;
    }

    public static String base32(long i) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = digits[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(Geohash.toByte(achar[pos]) << 4 | Geohash.toByte(achar[pos + 1]));
        }
        return result;
    }

    public static int toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    static {
        int i = 0;
        for (char c : digits) {
            lookup.put(Character.valueOf(c), i++);
        }
    }
}

