/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.extract;

import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorDataTransfer2 {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean clip = false;
    private boolean checkGeometry = false;
    private boolean isErrorContinue = false;
    private Map<String, String> fieldMap;
    private Map<String, Object> defaultValues;
    private Supplier<Boolean> cancelCallback;
    private Consumer<Long> countCallback;
    private BiConsumer<Long, Long> progressCallback;
    private Consumer<String> errorCallback;
    private BiConsumer<IRow, IRow> propertyValueSettingCallback;

    public TransferResult copyFeature(IFeatureClass srcFC, IFeatureClass trgFC, IQueryFilter srcFilter) {
        RefObject extent = new RefObject();
        TransferResult result = this.copyFeature(srcFC, trgFC, srcFilter, null, (RefObject<IEnvelope>)extent);
        if (result.isSuccess()) {
            IEnvelope srcExtent = trgFC.getExtent();
            IEnvelope dataExtent = (IEnvelope)extent.get();
            if (dataExtent != null && !dataExtent.isEmpty()) {
                if (srcExtent != null && !dataExtent.isEmpty()) {
                    this.setEnvelop(dataExtent, srcExtent);
                }
                trgFC.changeExtent(dataExtent);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult copyFeature(IFeatureClass srcFC, IFeatureClass trgFC, IQueryFilter srcFilter, String otherQuery, RefObject<IEnvelope> extent) {
        TransferResult result = new TransferResult();
        IFeatureCursor trgInsertCursor = null;
        IFeatureCursor srcSearchCursor = null;
        boolean success = true;
        long totalCount = 0L;
        long curentCount = 0L;
        long errorCount = 0L;
        long successCount = 0L;
        try {
            if (srcFC.getFeatureType() != trgFC.getFeatureType() && trgFC.getFeatureType() != FeatureType.Unknown) {
                result.setSuccess(false);
                result.setErrorMessage(String.format("[%s]-[%s]\u4e0e[%s]-[%s]\u7c7b\u578b\u4e0d\u4e00\u81f4", srcFC.getName(), srcFC.getFeatureType(), trgFC.getName(), trgFC.getFeatureType()));
                this.invokeCopyError(result.getErrorMessage());
                return result;
            }
            ISpatialReferenceSystem srcRef = srcFC.getSpatialReferenceSystem();
            ISpatialReferenceSystem trgRef = trgFC.getSpatialReferenceSystem();
            boolean isNeedProject = true;
            if (srcRef == null || trgRef == null || SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)srcRef, (ISpatialReferenceSystem)trgRef)) {
                isNeedProject = false;
            }
            IGeometry maskGeometry = null;
            if (this.clip && srcFilter instanceof SpatialQueryFilter) {
                maskGeometry = ((SpatialQueryFilter)srcFilter).getGeometry();
            }
            IEnvelope dataExtent = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
            totalCount = srcFC.featureCount(srcFilter);
            result.setTotalCount(totalCount);
            this.invokeProgressTotalChanged(totalCount);
            if (totalCount == 0L) {
                this.logger.info(srcFC.getName() + "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u6570\u636e");
                this.invokeProgressChanged(0L, 0L);
                result.setSuccess(true);
                result.setErrorMessage("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u6570\u636e");
                return result;
            }
            String querySql = this.getQuerySql(srcFC.getFullName(), srcFilter, otherQuery);
            ICursor iCursor = srcFC.getWorkspace().excuteQuerySql(querySql);
            srcSearchCursor = (IFeatureCursor)iCursor;
            if (!VectorDataTransfer2.startEdit((IGeoDataset)trgFC)) {
                this.invokeCopyError("\u6253\u5f00\u7f16\u8f91\u5931\u8d25");
                result.setSuccess(false);
                result.setErrorMessage("\u6253\u5f00\u7f16\u8f91\u5931\u8d25");
                return result;
            }
            int progressStep = this.getProgressStep(totalCount);
            IFeature srcFeature = null;
            IFeature trgFBuffer = null;
            boolean saveSuccess = true;
            trgInsertCursor = trgFC.batchInsertFeature();
            Map<String, String> inputFlds = this.getCustomAttFields((ICursor)srcSearchCursor, (ICursor)trgInsertCursor, (ITable)trgFC);
            srcFeature = srcSearchCursor.nextFeature();
            Optional<IField> shapeField = Arrays.stream(srcFeature.getFields().toArray()).filter(field -> field.getFieldType() == FieldType.Shape).findFirst();
            while (srcFeature != null) {
                try {
                    if (this.cancelCallback != null && this.cancelCallback.get().booleanValue()) {
                        long var10000 = totalCount - successCount;
                        success = false;
                        this.invokeCopyError("\u8981\u7d20\u62f7\u8d1d\u4e2d\u6b62");
                        break;
                    }
                    if (++curentCount % (long)progressStep == 0L) {
                        this.invokeProgressChanged(curentCount - errorCount, errorCount);
                    }
                    trgFBuffer = trgFC.createFeature();
                    IGeometry pNewShape = srcFeature.getGeometry();
                    if (pNewShape == null && shapeField.isPresent()) {
                        pNewShape = (IGeometry)srcFeature.getValue(shapeField.get().getName());
                    }
                    if (pNewShape != null) {
                        pNewShape = this.changeGeometry(trgFC, pNewShape);
                    }
                    if (isNeedProject && pNewShape != null) {
                        pNewShape.project(srcRef, trgRef);
                    }
                    if (this.clip && maskGeometry != null && pNewShape != null) {
                        IGeometry clipShape = pNewShape.intersection(maskGeometry);
                        if (clipShape != null && FeatureType.getByGeometryType((GeometryType)clipShape.getType()) != FeatureType.getByGeometryType((GeometryType)pNewShape.getType())) {
                            clipShape = null;
                        }
                        pNewShape = clipShape;
                    }
                    boolean valid = true;
                    if (this.checkGeometry && pNewShape != null && !pNewShape.isValid()) {
                        valid = false;
                        this.invokeCopyError(srcFC.getName() + " : " + srcFeature.getObjectId() + " \u8981\u7d20\u51e0\u4f55\u56fe\u5f62\u5b58\u5728\u9519\u8bef");
                    }
                    if (!valid) {
                        ++errorCount;
                        if (!this.isErrorContinue) {
                            success = false;
                            break;
                        }
                        srcFeature = srcSearchCursor.nextFeature();
                        continue;
                    }
                    trgFBuffer.setGeometry(pNewShape);
                    this.copyCustomFlds((IRow)srcFeature, (IRow)trgFBuffer, inputFlds);
                    this.invokePropertyValueSetting((IRow)srcFeature, (IRow)trgFBuffer);
                    saveSuccess = trgInsertCursor.insertFeature(trgFBuffer);
                    if (saveSuccess) {
                        ++successCount;
                        if (pNewShape == null || pNewShape.getEnvelope() == null) continue;
                        this.setEnvelop(dataExtent, pNewShape.getEnvelope());
                        continue;
                    }
                    ++errorCount;
                    if (this.isErrorContinue) continue;
                    success = false;
                    break;
                }
                catch (Exception var33) {
                    this.printErrorData((IRow)trgFBuffer);
                    this.logger.error(srcFeature.getObjectId() + "\u5199\u5165\u8981\u7d20\u5f02\u5e38", (Throwable)var33);
                    if (var33 instanceof SQLException) {
                        throw var33;
                    }
                    ++errorCount;
                    this.invokeCopyError(srcFeature.getObjectId() + "\u5199\u5165\u8981\u7d20\u5f02\u5e38\uff0c" + var33.getMessage());
                    if (this.isErrorContinue) continue;
                    success = false;
                    break;
                }
                finally {
                    srcFeature = srcSearchCursor.nextFeature();
                }
            }
            srcSearchCursor.release();
            trgInsertCursor.release();
            VectorDataTransfer2.stopEdit((IGeoDataset)trgFC, success);
            if (null != extent) {
                extent.set((Object)dataExtent);
            }
            errorCount = totalCount - successCount;
            result.setSuccessCount(successCount);
            result.setFailCount(errorCount);
            this.invokeProgressChanged(successCount, errorCount);
            if (totalCount != 0L && errorCount != 0L) {
                result.setSuccess(false);
            } else {
                result.setSuccess(true);
            }
            return result;
        }
        catch (Exception var35) {
            this.logger.error(srcFC.getName() + "\u8981\u7d20\u62f7\u8d1d\u5f02\u5e38", (Throwable)var35);
            if (var35 instanceof SQLException) {
                successCount = 0L;
            }
            errorCount = totalCount - successCount;
            this.invokeProgressChanged(successCount, errorCount);
            this.invokeCopyError(var35.getMessage());
            if (srcSearchCursor != null) {
                srcSearchCursor.release();
            }
            if (trgInsertCursor != null) {
                trgInsertCursor.release();
            }
            VectorDataTransfer2.stopEdit((IGeoDataset)trgFC, false);
            result.setSuccessCount(successCount);
            result.setFailCount(errorCount);
            result.setSuccess(false);
            result.setErrorMessage(var35.getMessage());
            return result;
        }
    }

    private IGeometry changeGeometry(IFeatureClass featureClass, IGeometry geometry) {
        if (featureClass.getFeatureType() != FeatureType.Unknown && featureClass.getFeatureType() != FeatureType.Annotation) {
            if (FeatureType.getByGeometryType((GeometryType)geometry.getType()) != featureClass.getFeatureType()) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u578b\u4e0d\u4e00\u81f4\uff1a" + geometry.getType() + "->" + featureClass.getFeatureType());
            }
            if (featureClass.getWorkspace() instanceof JdbcWorkspace) {
                switch (featureClass.getFeatureType()) {
                    default: {
                        break;
                    }
                    case Polyline: {
                        if (geometry.getType() != GeometryType.Curve && geometry.getType() != GeometryType.CompoundCurve && geometry.getType() != GeometryType.CircularString) {
                            if (geometry.getType() != GeometryType.MultiCurve) break;
                            geometry = GeometryFunc.forceToMultiLineString((IGeometry)geometry);
                            break;
                        }
                        geometry = GeometryFunc.forceToLineString((IGeometry)geometry);
                        break;
                    }
                    case Polygon: {
                        if (geometry.getType() == GeometryType.CurvePolygon) {
                            geometry = GeometryFunc.forceToPolygon((IGeometry)geometry);
                            break;
                        }
                        if (geometry.getType() != GeometryType.MultiCurvePolygon) break;
                        geometry = GeometryFunc.forceToMultiPolygon((IGeometry)geometry);
                    }
                }
            }
            return geometry;
        }
        return geometry;
    }

    private String getQuerySql(String name, IQueryFilter srcFilter, String otherQuery) {
        String qeuryField = "*";
        if (otherQuery != null && !otherQuery.isEmpty()) {
            qeuryField = qeuryField + otherQuery;
        }
        String whereClause = " 1= 1 ";
        if (srcFilter != null && StringUtils.isNotEmpty((CharSequence)srcFilter.getWhereClause())) {
            whereClause = srcFilter.getWhereClause();
        }
        String querySql = String.format("select %s from %s where %s", qeuryField, name, whereClause);
        return querySql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TransferResult copyTable(ITable srcTable, ITable trgTable, IQueryFilter srcFilter, String otherQuery) {
        TransferResult result = new TransferResult();
        ICursor trgInsertCursor = null;
        ICursor srcSearchCursor = null;
        boolean success = true;
        long totalCount = 0L;
        long curentCount = 0L;
        long errorCount = 0L;
        long successCount = 0L;
        try {
            totalCount = srcTable.count(srcFilter);
            result.setTotalCount(totalCount);
            this.invokeProgressTotalChanged(totalCount);
            if (totalCount == 0L) {
                this.logger.info(srcTable.getName() + "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u6570\u636e");
                this.invokeProgressChanged(0L, 0L);
                result.setSuccess(true);
                return result;
            }
            String querySql = this.getQuerySql(srcTable.getName(), srcFilter, otherQuery);
            srcSearchCursor = srcTable.getWorkspace().excuteQuerySql(querySql);
            if (!VectorDataTransfer2.startEdit((IGeoDataset)trgTable)) {
                this.invokeCopyError("\u6253\u5f00\u7f16\u8f91\u5931\u8d25");
                result.setSuccess(false);
                result.setErrorMessage("\u6253\u5f00\u7f16\u8f91\u5931\u8d25");
                return result;
            }
            int progressStep = this.getProgressStep(totalCount);
            IRow srcRow = null;
            IRow trgBuffer = null;
            boolean saveSuccess = true;
            trgInsertCursor = trgTable.batchInsertRow();
            Map<String, String> inputFlds = this.getCustomAttFields(srcSearchCursor, trgInsertCursor, trgTable);
            srcRow = srcSearchCursor.nextRow();
            while (srcRow != null) {
                block20: {
                    block19: {
                        if (this.cancelCallback == null || !this.cancelCallback.get().booleanValue()) break block19;
                        long var10000 = totalCount - successCount;
                        success = false;
                        this.invokeCopyError("\u8868\u683c\u884c\u62f7\u8d1d\u4e2d\u6b62");
                        srcRow = srcSearchCursor.nextRow();
                        break;
                    }
                    if (++curentCount % (long)progressStep == 0L) {
                        this.invokeProgressChanged(curentCount - errorCount, errorCount);
                    }
                    trgBuffer = trgTable.createRow();
                    this.copyCustomFlds(srcRow, trgBuffer, inputFlds);
                    this.invokePropertyValueSetting(srcRow, trgBuffer);
                    saveSuccess = trgInsertCursor.insertRow(trgBuffer);
                    if (saveSuccess) {
                        ++successCount;
                        break block20;
                    }
                    ++errorCount;
                    if (this.isErrorContinue) break block20;
                    srcRow = srcSearchCursor.nextRow();
                    break;
                }
                try {
                    continue;
                    catch (Exception var26) {
                        this.printErrorData(trgBuffer);
                        this.logger.error(srcRow.getObjectId() + "\u5199\u5165\u5f02\u5e38", (Throwable)var26);
                        if (var26 instanceof SQLException) {
                            throw var26;
                        }
                        ++errorCount;
                        this.invokeCopyError(srcRow.getObjectId() + "\u5199\u5165\u5f02\u5e38\uff0c" + var26.getMessage());
                        if (this.isErrorContinue) continue;
                        long var10000 = totalCount - successCount;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    srcRow = srcSearchCursor.nextRow();
                }
            }
            srcSearchCursor.release();
            trgInsertCursor.release();
            VectorDataTransfer2.stopEdit((IGeoDataset)trgTable, success);
            errorCount = totalCount - successCount;
            result.setSuccessCount(successCount);
            result.setFailCount(errorCount);
            this.invokeProgressChanged(successCount, errorCount);
            if (totalCount != 0L && errorCount != 0L) {
                result.setSuccess(false);
            } else {
                result.setSuccess(true);
            }
            return result;
        }
        catch (Exception var28) {
            this.logger.error(srcTable.getName() + "\u8981\u7d20\u62f7\u8d1d\u5f02\u5e38", (Throwable)var28);
            if (var28 instanceof SQLException) {
                successCount = 0L;
            }
            errorCount = totalCount - successCount;
            this.invokeProgressChanged(successCount, errorCount);
            this.invokeCopyError(var28.getMessage());
            if (srcSearchCursor != null) {
                srcSearchCursor.release();
            }
            if (trgInsertCursor != null) {
                trgInsertCursor.release();
            }
            VectorDataTransfer2.stopEdit((IGeoDataset)trgTable, false);
            result.setSuccessCount(successCount);
            result.setFailCount(errorCount);
            result.setSuccess(false);
            result.setErrorMessage(var28.getMessage());
            return result;
        }
    }

    private void printErrorData(IRow row) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n");
            for (IField fld : row.getFields()) {
                stringBuilder.append(String.format("%s [%s]-[%d]-[%s]:", fld.getName(), fld.getFieldType(), fld.getLength(), fld.getNullable()));
                Object value = row.getValue(fld.getName());
                if (value instanceof IGeometry) {
                    stringBuilder.append(((IGeometry)value).toWkt());
                } else {
                    stringBuilder.append(value == null ? "NULL" : value);
                }
                stringBuilder.append("\n");
            }
            this.logger.debug(stringBuilder.toString());
        }
        catch (Exception var6) {
            this.logger.error("\u6253\u5370\u6570\u636e\u5f02\u5e38", (Throwable)var6);
        }
    }

    private void copyCustomFlds(IRow srcRow, IRow trgBuffer, Map<String, String> inputFlds) {
        for (Map.Entry<String, String> entry : inputFlds.entrySet()) {
            Object objValue = srcRow.getValue(entry.getKey());
            trgBuffer.setValue(entry.getValue(), objValue);
        }
        if (this.defaultValues != null) {
            for (Map.Entry<String, Object> entry : this.defaultValues.entrySet()) {
                trgBuffer.setValue(entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, String> getCustomAttFields(ICursor srcCursor, ICursor trgCursor, ITable trgFc) {
        String tarFld;
        HashMap<String, String> dicInputFld = new HashMap<String, String>();
        ArrayList<String> systemFields = new ArrayList<String>();
        if (trgFc instanceof IFeatureClass) {
            String shapeFieldName = ((IFeatureClass)trgFc).getShapeFieldName();
            if (StringUtil.isEmpty((String)shapeFieldName)) {
                throw new RuntimeException("\u51e0\u4f55\u5b57\u6bb5\u4e3a\u7a7a");
            }
            systemFields.add(shapeFieldName.toUpperCase());
        }
        if (this.fieldMap != null && this.fieldMap.size() > 0) {
            for (Map.Entry<String, String> item : this.fieldMap.entrySet()) {
                if (systemFields.contains(item.getValue().toUpperCase()) || (tarFld = this.findTargetField(srcCursor, trgCursor, item.getKey(), item.getValue())) == null) continue;
                dicInputFld.put(item.getKey(), tarFld);
            }
        } else {
            for (IField srcField : srcCursor.getFields()) {
                tarFld = this.findTargetField(srcCursor, trgCursor, srcField.getName(), srcField.getName());
                if (tarFld == null || systemFields.contains(tarFld.toUpperCase())) continue;
                dicInputFld.put(srcField.getName(), tarFld);
            }
        }
        return dicInputFld;
    }

    private String findTargetField(ICursor srcCursor, ICursor targetFc, String srcFldName, String desFldName) {
        int srcIndex = srcCursor.getFields().findFieldIndex(srcFldName);
        if (srcIndex == -1) {
            return null;
        }
        int desIndex = targetFc.getFields().findFieldIndex(desFldName);
        if (desIndex == -1) {
            switch (desFldName) {
                case "SHAPE_LENGTH": {
                    desFldName = "SHAPE.LEN";
                    break;
                }
                case "SHAPE_AREA": {
                    desFldName = "SHAPE.AREA";
                    break;
                }
                case "SHAPE.LEN": {
                    desFldName = "SHAPE_LENGTH";
                    break;
                }
                case "SHAPE.AREA": {
                    desFldName = "SHAPE_AREA";
                    break;
                }
                default: {
                    return null;
                }
            }
            desIndex = targetFc.getFields().findFieldIndex(desFldName);
        }
        return desIndex == -1 ? null : desFldName;
    }

    private void setEnvelop(IEnvelope newExtent, IEnvelope oldExtent) {
        newExtent.setRange(Double.min(newExtent.getXMin(), oldExtent.getXMin()), Double.min(newExtent.getYMin(), oldExtent.getYMin()), Double.max(newExtent.getXMax(), oldExtent.getXMax()), Double.max(newExtent.getYMax(), oldExtent.getYMax()));
    }

    private int getProgressStep(long totalCount) {
        if (totalCount <= 10L) {
            return 1;
        }
        if (totalCount <= 100L) {
            return 10;
        }
        if (totalCount <= 500L) {
            return 50;
        }
        if (totalCount <= 1000L) {
            return 100;
        }
        if (totalCount <= 2000L) {
            return 200;
        }
        if (totalCount <= 5000L) {
            return 500;
        }
        if (totalCount <= 10000L) {
            return 1000;
        }
        if (totalCount <= 20000L) {
            return 2000;
        }
        return totalCount <= 50000L ? 5000 : 10000;
    }

    static boolean startEdit(IGeoDataset trgFC) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace == null) {
            return false;
        }
        if (!pWorkspace.getInTransaction()) {
            pWorkspace.beginTransaction();
        }
        return true;
    }

    static void stopEdit(IGeoDataset trgFC, boolean isSave) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace != null && pWorkspace.getInTransaction()) {
            if (isSave) {
                pWorkspace.commitTransaction();
            } else {
                pWorkspace.rollbackTransaction();
            }
        }
    }

    protected void invokeProgressChanged(long successCount, long failCount) {
        if (this.progressCallback != null) {
            this.progressCallback.accept(successCount, failCount);
        }
    }

    protected void invokeCopyError(String message) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(message);
        }
    }

    protected void invokeProgressTotalChanged(long iValue) {
        if (this.countCallback != null) {
            this.countCallback.accept(iValue);
        }
    }

    protected void invokePropertyValueSetting(IRow srcData, IRow buffer) {
        if (this.propertyValueSettingCallback != null) {
            this.propertyValueSettingCallback.accept(srcData, buffer);
        }
    }

    public boolean isClip() {
        return this.clip;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    public boolean isCheckGeometry() {
        return this.checkGeometry;
    }

    public void setCheckGeometry(boolean checkGeometry) {
        this.checkGeometry = checkGeometry;
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public Map<String, Object> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Map<String, Object> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setCountCallback(Consumer<Long> countCallback) {
        this.countCallback = countCallback;
    }

    public void setProgressCallback(BiConsumer<Long, Long> progCallback) {
        this.progressCallback = progCallback;
    }

    public void setErrorCallback(Consumer<String> errorCallback) {
        this.errorCallback = errorCallback;
    }

    public void setPropertyValueSettingCallback(BiConsumer<IRow, IRow> callback) {
        this.propertyValueSettingCallback = callback;
    }

    public void setCancelCallback(Supplier<Boolean> callback) {
        this.cancelCallback = callback;
    }
}

