/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.raster;

import cn.hutool.core.io.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.enums.RasterFormatEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.raster.RasterInvalidValueCheckParam;
import com.geoway.dgt.geodata.util.RasterDataScan;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class RasterInvalidValueCheckTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        if (StringUtils.isNotBlank((CharSequence)batchInputData.getName())) {
            String[] nameArray;
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            for (String name : nameArray = batchInputData.getName().split(",")) {
                batchInputData.setName(null);
                batchInputData.setFilePath(new File(batchInputData.getFilePath(), name).getAbsolutePath());
                ToolHelper.callbackOne(batchInputData, new DataParam(), toolParam, oneDataCallback);
            }
        } else {
            Assert.state((boolean)FileUtil.isDirectory((File)new File(batchInputData.getFilePath())), (String)"\u8f93\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            ArrayList<RasterFormatEnum> formats = new ArrayList<RasterFormatEnum>(0);
            formats.add(RasterFormatEnum.IMG);
            formats.add(RasterFormatEnum.TIF);
            formats.add(RasterFormatEnum.GRID);
            RasterDataScan rasterDataScan = new RasterDataScan(batchInputData.getFilePath(), formats, null);
            rasterDataScan.scan(data -> {
                DataParam dataParam = new DataParam();
                dataParam.setFilePath(new File((String)data).getAbsolutePath());
                dataParam.setName(FileUtil.getName((String)data));
                ToolHelper.callbackOne(dataParam, new DataParam(), toolParam, oneDataCallback);
            });
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(inputDataParam.getFilePath());
        IRasterDataset rasterDataset = rasterWorkspace.openRasterDataset(inputDataParam.getFilePath());
        RasterInvalidValueCheckParam rasterInvalidValueCheckParam = (RasterInvalidValueCheckParam)executeParam;
        String checkInvalidValueStr = rasterInvalidValueCheckParam.invalidValue;
        boolean dataHasInvalidValue = rasterDataset.getRasterInfo().getHasInvalidValue();
        Object[] dataInvalidValue = rasterDataset.getRasterInfo().getInvalidValue();
        this.invokeExcuteLog("\u6570\u636e\u65e0\u6548\u503c\uff1a" + (dataHasInvalidValue ? Arrays.toString(dataInvalidValue) : ""));
        if (StringUtil.isEmptyOrWhiteSpace((String)checkInvalidValueStr)) {
            if (dataHasInvalidValue) {
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u6570\u636e\u65e0\u6548\u503c\u4e0e\u6807\u51c6\u65e0\u6548\u503c\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
                return executeResult;
            }
            executeResult.setSuccess(Boolean.valueOf(true));
            return executeResult;
        }
        if (!dataHasInvalidValue) {
            executeResult.setSuccess(Boolean.valueOf(false));
            this.invokeExcuteLog("\u6570\u636e\u65e0\u6548\u503c\u4e0e\u6807\u51c6\u65e0\u6548\u503c\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
            return executeResult;
        }
        String[] checkInvalidValueStrArr = checkInvalidValueStr.trim().split(",");
        for (int i = 0; i < checkInvalidValueStrArr.length; ++i) {
            try {
                if (Double.parseDouble(checkInvalidValueStrArr[i].trim()) == (Double)dataInvalidValue[i]) continue;
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u6570\u636e\u65e0\u6548\u503c\u4e0e\u6807\u51c6\u65e0\u6548\u503c\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
                return executeResult;
            }
            catch (Exception e) {
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u6570\u636e\u65e0\u6548\u503c\u4e0e\u6807\u51c6\u65e0\u6548\u503c\u4e0d\u4e00\u81f4\uff01", TaskLogLevelEnum.Error);
                return executeResult;
            }
        }
        rasterDataset.closeRaster();
        return executeResult;
    }
}

