/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.geodata.spatialization;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.enums.VectorFormatEnum;
import com.geoway.dgt.frame.enums.VectorReadWriteEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.frame.util.VectorFileUtil;
import com.geoway.dgt.frame.util.VectorPathUtil;
import com.geoway.dgt.geodata.ToolHelper;
import com.geoway.dgt.geodata.dto.FeatureClassMeta;
import com.geoway.dgt.geodata.dto.TableMeta;
import com.geoway.dgt.geodata.dto.ToolFeatureWorkspaceDTO;
import com.geoway.dgt.geodata.spatialization.DataSpatializationParam;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.springframework.util.Assert;

public class DataSpatializationTool
extends ToolBase {
    private static final String shapeFieldName = "shape";

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataSpatializationTool.checkInput(batchInputData, true);
        String inputFileMainName = FileUtil.mainName((File)new File(batchInputData.getFilePath()));
        DataSpatializationTool.checkOutput(batchOutputData, (DataSpatializationParam)toolParam, inputFileMainName);
        ToolHelper.callbackOne(batchInputData, batchOutputData, toolParam, oneDataCallback);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        DataSpatializationTool.checkInput(inputData, false);
        String inputFileMainName = FileUtil.mainName((File)new File(inputData.getFilePath()));
        DataSpatializationTool.checkOutput(outputData, (DataSpatializationParam)toolParam, inputFileMainName);
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setInputData(inputData);
        executeParam.setOutputData(outputData);
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    private static void checkInput(DataParam batchInputData, boolean mustExist) {
        File inputFile = new File(batchInputData.getFilePath());
        if (mustExist) {
            Assert.state((boolean)FileUtil.isFile((File)inputFile), (String)"\u8f93\u5165\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String suffix = FileUtil.getSuffix((File)inputFile);
        Assert.state((boolean)StrUtil.equalsAnyIgnoreCase((CharSequence)suffix, (CharSequence[])new CharSequence[]{"txt", "csv", "xls", "xlsx"}), (String)("\u4e0d\u652f\u6301\u7684\u6570\u636e\u683c\u5f0f : " + suffix));
    }

    private static void checkOutput(DataParam batchOutputData, DataSpatializationParam param, String inputFileMainName) {
        File outFile = new File(batchOutputData.getFilePath());
        if (!VectorFileUtil.exactlyMatchAny((File)outFile)) {
            if (outFile.exists()) {
                Assert.state((boolean)FileUtil.isDirectory((File)outFile), (String)"\u8f93\u51fa\u6570\u636e\u683c\u5f0f\u6709\u8bef");
            }
            String outputFilePath = VectorPathUtil.getOutputFilePath((String)inputFileMainName, (String)batchOutputData.getFilePath(), (VectorFormatEnum)param.getTargetFormat());
            batchOutputData.setFilePath(outputFilePath);
        }
    }

    public ExecuteResult execute(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteResult executeResult = new ExecuteResult();
        executeResult.setOutDataParam(outputData);
        try {
            String inFilePath = inputData.getFilePath();
            String suffix = FileUtil.getSuffix((String)inFilePath);
            if ("txt".equalsIgnoreCase(suffix)) {
                this.txt2File(inputData, outputData, (DataSpatializationParam)toolParam, executeResult);
            } else {
                this.csvOrXls2File(inputData, outputData, (DataSpatializationParam)toolParam, executeResult);
            }
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog("\u6570\u636e\u7a7a\u95f4\u5316\u5931\u8d25", e);
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txt2File(DataParam inputData, DataParam outputData, DataSpatializationParam toolParam, ExecuteResult executeResult) {
        String separator = "\t";
        File file = new File(inputData.getFilePath());
        Assert.state((boolean)FileUtil.exist((File)file), (String)("\u6587\u4ef6\u4e0d\u5b58\u5728 : " + file.getAbsolutePath()));
        FileReader fileReader = new FileReader(file);
        TableMeta tableMeta = new TableMeta();
        tableMeta.setName(FileUtil.mainName((File)file));
        IFeatureWorkspace targetWorkspace = ToolHelper.getFileWorkspace(outputData.getFilePath());
        Assert.notNull((Object)targetWorkspace, (String)("\u6253\u5f00\u6587\u4ef6\u5931\u8d25 : " + outputData.getFilePath()));
        this.invokeExcuteLog(tableMeta.getName() + "\u5f00\u59cb\u7a7a\u95f4\u5316...");
        targetWorkspace.beginTransaction();
        IFeatureClass featureClass = null;
        try {
            List list = fileReader.readLines();
            for (String line : list) {
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                String[] title = tableMeta.getTitle();
                List split = StrUtil.split((CharSequence)line, (CharSequence)separator);
                if (title == null) {
                    tableMeta.setTitle(split.toArray(new String[0]));
                    continue;
                }
                if (featureClass == null) {
                    featureClass = this.createFeatureClass(tableMeta, targetWorkspace, toolParam);
                }
                Assert.notNull(featureClass, (String)"\u521b\u5efa\u8981\u7d20\u7c7b\u5931\u8d25");
                this.invokeExcuteLog("\u521b\u5efa\u8981\u7d20\u7c7b" + tableMeta.getName());
                String[] data = split.size() > title.length ? split.subList(0, title.length).toArray(new String[title.length]) : split.toArray(new String[title.length]);
                IFeatureCursor featureCursor = featureClass.batchInsertFeature();
                IFeature feature = featureClass.createFeature();
                double x = 0.0;
                double y = 0.0;
                for (int i = 0; i < title.length; ++i) {
                    String fieldName = title[i];
                    String valueStr = data[i];
                    if (StrUtil.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)toolParam.getxField())) {
                        x = Double.parseDouble(data[i]);
                        feature.setValue(fieldName, (Object)x);
                    } else if (StrUtil.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)toolParam.getyField())) {
                        y = Double.parseDouble(data[i]);
                        feature.setValue(fieldName, (Object)y);
                    } else {
                        feature.setValue(fieldName, (Object)data[i]);
                    }
                    if (i != title.length - 1) continue;
                    feature.setGeometry(GeometryFunc.createGeometry((String)String.format("POINT(%s %s)", x, y)));
                }
                featureCursor.insertFeature(feature);
            }
            targetWorkspace.commitTransaction();
            this.invokeExcuteLog(tableMeta.getName() + "\u7a7a\u95f4\u5316\u5b8c\u6210\uff01");
            executeResult.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            targetWorkspace.rollbackTransaction();
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog("\u6570\u636e\u7a7a\u95f4\u5316\u5931\u8d25", e);
        }
        finally {
            targetWorkspace.close();
        }
    }

    private IFeatureClass createFeatureClass(TableMeta tableMeta, IFeatureWorkspace targetWorkspace, DataSpatializationParam toolParam) {
        Fields newFields = new Fields();
        for (String fieldName : tableMeta.getTitle()) {
            Field field = new Field();
            field.setName(fieldName);
            if (StrUtil.equalsAnyIgnoreCase((CharSequence)fieldName, (CharSequence[])new CharSequence[]{toolParam.getxField(), toolParam.getyField()})) {
                field.setFieldType(FieldType.Double);
            } else {
                field.setFieldType(FieldType.String);
            }
            newFields.addField((IField)field);
        }
        newFields.addField((IField)DataSpatializationTool.buildGeometryField(toolParam));
        return targetWorkspace.createFeatureClass(tableMeta.getName(), (IFields)newFields, FeatureType.Point, shapeFieldName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void csvOrXls2File(DataParam inputData, DataParam outputData, DataSpatializationParam toolParam, ExecuteResult executeResult) {
        ToolFeatureWorkspaceDTO workspaceDTO = ToolHelper.getWorkspace(inputData, outputData, VectorReadWriteEnum.F2F);
        IFeatureWorkspace sourceWorkspace = workspaceDTO.getSourceWorkspace();
        IFeatureWorkspace targetWorkspace = workspaceDTO.getTargetWorkspace();
        int totalCount = 0;
        int successCount = 0;
        int failCount = 0;
        boolean success = true;
        try {
            List datasets = sourceWorkspace.getDatasets();
            for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType;
                if (this.isAborted()) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                }
                if (StrUtil.isNotEmpty((CharSequence)inputData.getName()) && !StrUtil.equals((CharSequence)dataset.getName(), (CharSequence)inputData.getName()) || (geoDatasetType = dataset.getType()) != GeoDatasetType.Table) continue;
                ITable table = (ITable)dataset;
                String datasetName = dataset.getName();
                if (datasetName == null) {
                    datasetName = FileUtil.mainName((String)inputData.getFilePath());
                }
                ++totalCount;
                this.invokeExcuteLog(datasetName + "\u5f00\u59cb\u7a7a\u95f4\u5316...");
                try {
                    IFeatureClass featureClass = this.createFeatureClass(datasetName, table, targetWorkspace, toolParam);
                    ICursor searchCursor = table.searchRow(null);
                    IFeatureCursor featureCursor = featureClass.batchInsertFeature();
                    IRow row = searchCursor.nextRow();
                    while (row != null) {
                        if (this.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                        }
                        double x = 0.0;
                        double y = 0.0;
                        IFeature newFeature = featureClass.createFeature();
                        for (int i = 0; i < row.getFields().getFieldCount(); ++i) {
                            String fieldName = row.getFields().getField(i).getName();
                            int srcIndex = table.getFields().findFieldIndex(fieldName);
                            if (srcIndex < 0) continue;
                            Object value = row.getValue(srcIndex);
                            newFeature.setValue(fieldName, value);
                            if (fieldName.equalsIgnoreCase(toolParam.getxField())) {
                                x = Double.parseDouble(String.valueOf(value));
                            } else if (fieldName.equalsIgnoreCase(toolParam.getyField())) {
                                y = Double.parseDouble(String.valueOf(value));
                            }
                            if (i != row.getFields().getFieldCount() - 1) continue;
                            String wkt = String.format("POINT(%s %s)", x, y);
                            newFeature.setGeometry(GeometryFunc.createGeometry((String)wkt));
                        }
                        featureCursor.insertFeature(newFeature);
                        row = searchCursor.nextRow();
                    }
                    this.invokeExcuteLog(datasetName + "\u7a7a\u95f4\u5316\u5b8c\u6210\uff01");
                    ++successCount;
                }
                catch (Exception e) {
                    this.invokeExcuteLog(datasetName + "\u7a7a\u95f4\u5316\u5931\u8d25\uff01" + e.getMessage(), e);
                    ++failCount;
                    success = false;
                }
            }
            executeResult.setSuccess(Boolean.valueOf(success));
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
            executeResult.setOutDataParam(outputData);
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.invokeExcuteLog(String.format("\u5171%d\uff0c\u6210\u529f%d\uff0c\u5931\u8d25%d", totalCount, successCount, failCount));
        }
        finally {
            workspaceDTO.close();
        }
    }

    private static GeometryField buildGeometryField(DataSpatializationParam toolParam) {
        GeometryField geometryField = new GeometryField();
        geometryField.setName(shapeFieldName);
        geometryField.setCoordinateType(CoordinateType.XY);
        geometryField.setGeometryType(GeometryType.Point);
        ISpatialReferenceSystem srs = StrUtil.isNotEmpty((CharSequence)toolParam.getStrWKT()) ? SpatialReferenceSystemFunc.createSpatialReference((String)toolParam.getStrWKT()) : SpatialReferenceSystemFunc.createSpatialReference((int)toolParam.getSrid());
        geometryField.setSpatialReferenceSystem(srs);
        geometryField.setFieldType(FieldType.Shape);
        return geometryField;
    }

    private IFeatureClass createFeatureClass(String datasetName, ITable table, IFeatureWorkspace targetWorkspace, DataSpatializationParam toolParam) {
        Fields newFields = new Fields();
        IntStream.range(0, table.getFields().getFieldCount()).mapToObj(i -> table.getFields().getField(i).clone()).forEach(arg_0 -> ((IFields)newFields).addField(arg_0));
        newFields.addField((IField)DataSpatializationTool.buildGeometryField(toolParam));
        return targetWorkspace.createFeatureClass(datasetName, (IFields)newFields, FeatureType.Point, shapeFieldName, null);
    }

    private Boolean vectorTransfer(IFeatureClass srcFeatureClass, FeatureClassMeta featureClassMeta, DataSpatializationParam iToolParam, String outputName) {
        try {
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setCancelCallback(() -> ((DataSpatializationTool)this).isAborted());
            IFeatureClass targetFeatureClass = ToolHelper.getTargetFeatureClass(srcFeatureClass, featureClassMeta, outputName);
            TransferResult transferResult = vectorDataTransfer.copyFeature(srcFeatureClass, targetFeatureClass, null);
            Assert.state((boolean)transferResult.isSuccess(), (String)transferResult.getErrorMessage());
            return true;
        }
        catch (Exception e) {
            this.invokeExcuteLog("\u77e2\u91cf\u6570\u636e\u8f6c\u6362\u5931\u8d25", e);
            return false;
        }
    }
}

