/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.globemodel.vectorto3dtiles;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.globemodel.ConfigPathUtil;
import com.geoway.dgt.globemodel.HttpHelper;
import com.geoway.dgt.globemodel.vectorto3dtiles.param.TextureClassifyFilter;
import com.geoway.dgt.globemodel.vectorto3dtiles.param.VectorTo3dtilesDataTypeEnum;
import com.geoway.dgt.globemodel.vectorto3dtiles.param.VectorTo3dtilesParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class VectorTo3dtilesTool
extends ToolBase {
    private Boolean isRunning = false;
    private String modelTaskId = "";

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName("\u4e09\u7ef4\u6a21\u578b\u6279\u91cf\u6784\u5efa");
        item.setPriority(100);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        VectorTo3dtilesParam param = (VectorTo3dtilesParam)executeParam;
        MultipartFile configFile = this.createConfigFile(param);
        try {
            String url = EnvironmentConfig.getProperty((String)"project.vector-to-3dtiles-tool-url");
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            this.invokeExcuteLog(url);
            String result = HttpHelper.doPost(String.format("%sstartByConfig", url), configFile, null);
            if (StringUtil.isEmptyOrWhiteSpace((String)result)) {
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u542f\u52a8\u767d\u6a21\u5de5\u5177\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
                executeResult.setErrorMessage("\u542f\u52a8\u767d\u6a21\u5de5\u5177\u5931\u8d25\uff01");
                return executeResult;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            this.modelTaskId = jsonObject.getJSONObject("data").get((Object)"id").toString();
            this.invokeExcuteLog("\u767d\u6a21\u5de5\u5177\u8fdb\u7a0b\uff1a" + this.modelTaskId);
            this.isRunning = true;
            while (this.isRunning.booleanValue()) {
                try {
                    String resultString = HttpHelper.doGet(String.format("%sdetail?id=%s", url, this.modelTaskId));
                    if (StringUtil.isEmptyOrWhiteSpace((String)resultString)) {
                        this.invokeExcuteLog("\u83b7\u53d6\u767d\u6a21\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
                        executeResult.setErrorMessage("\u83b7\u53d6\u767d\u6a21\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01");
                        continue;
                    }
                    JSONObject taskJsonObject = JSONObject.parseObject((String)resultString);
                    if (taskJsonObject == null || taskJsonObject.getJSONObject("data") == null) continue;
                    Object endTimeObj = taskJsonObject.getJSONObject("data").get((Object)"endTime");
                    Object exitValueObj = taskJsonObject.getJSONObject("data").get((Object)"exitValue");
                    if (endTimeObj == null || exitValueObj == null) continue;
                    this.isRunning = false;
                    JSONArray messages = taskJsonObject.getJSONObject("data").getJSONArray("message");
                    for (int i = 0; i < messages.size(); ++i) {
                        this.invokeExcuteLog(messages.getString(i));
                    }
                    if ("0".equals(exitValueObj.toString())) continue;
                    executeResult.setSuccess(Boolean.valueOf(false));
                }
                catch (Exception e) {
                    executeResult.setSuccess(Boolean.valueOf(false));
                    this.log.error(e.getMessage(), (Throwable)e);
                    this.invokeExcuteLog("\u83b7\u53d6\u767d\u6a21\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
                    executeResult.setErrorMessage("\u83b7\u53d6\u767d\u6a21\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage());
                    this.isRunning = false;
                }
            }
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            this.log.error(e.getMessage(), (Throwable)e);
            this.invokeExcuteLog("\u542f\u52a8\u767d\u6a21\u5de5\u5177\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
            executeResult.setErrorMessage("\u542f\u52a8\u767d\u6a21\u5de5\u5177\u5931\u8d25\uff01" + e.getMessage());
        }
        return executeResult;
    }

    public void abort() {
        super.abort();
        this.invokeExcuteLog("\u7ec8\u6b62\u767d\u6a21\u5de5\u5177", TaskLogLevelEnum.Error);
        this.isRunning = false;
        if (!StringUtil.isEmptyOrWhiteSpace((String)this.modelTaskId)) {
            try {
                String url = EnvironmentConfig.getProperty((String)"project.vector-to-3dtiles-tool-url");
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add((NameValuePair)new BasicNameValuePair("id", this.modelTaskId));
                String string = HttpHelper.doPost(String.format("%sstop", url), null, params);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private MultipartFile createConfigFile(VectorTo3dtilesParam param) {
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        File configFile = Paths.get(ConfigPathUtil.getConfigPath().toString(), System.currentTimeMillis() + "_VectorTo3dtiles.json").toFile();
        JSONObject jsonObject = new JSONObject();
        VectorTo3dtilesDataTypeEnum inDataType = VectorTo3dtilesDataTypeEnum.getByValue(param.getInDataType());
        switch (inDataType) {
            case shp: {
                jsonObject.put("inShapeFile", (Object)param.getInShapeFilePath());
                this.invokeExcuteLog("shp\u8def\u5f84 " + param.getInShapeFilePath());
                if (StringUtil.isEmptyOrWhiteSpace((String)param.getTerrainUrl())) break;
                jsonObject.put("terrainUrl", (Object)param.getTerrainUrl());
                break;
            }
            case postgres: {
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)param.getInTableDatasetId());
                DataSourceDTO dataSource = dataSourceService.getDataSourceDetail(nameInfo.getDsKey());
                if (!(dataSource instanceof DatabaseDTO)) {
                    throw new RuntimeException("\u6570\u636e\u5e93\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
                }
                DatabaseDTO database = (DatabaseDTO)dataSource;
                String tableName = nameInfo.getName();
                if (tableName.indexOf(".") > 0) {
                    tableName = tableName.substring(tableName.indexOf(".") + 1);
                }
                String tablePrimaryFieldName = "";
                DatasetDTO datasetDTO = dataSourceService.getDatasetDetail(nameInfo.getDsKey(), nameInfo.getShortName());
                if (datasetDTO instanceof TableDatasetDTO) {
                    tablePrimaryFieldName = ((TableDatasetDTO)datasetDTO).getOidField();
                } else if (datasetDTO instanceof FeatureClassDTO) {
                    tablePrimaryFieldName = ((FeatureClassDTO)datasetDTO).getOidField();
                }
                JSONObject inDbJson = new JSONObject();
                inDbJson.put("dbConnectionStr", (Object)String.format("dbname = %s user = %s password = %s host = %s port = %s", database.getDbName(), database.getUserName(), database.getPassword(), database.getHost(), database.getPort()));
                inDbJson.put("tableName", (Object)tableName);
                JSONArray fldArray = new JSONArray();
                if (param.getInFieldNames() != null && param.getInFieldNames().length > 0) {
                    fldArray.addAll(Arrays.asList(param.getInFieldNames()));
                }
                inDbJson.put("tableFieldNames", (Object)fldArray);
                jsonObject.put("tablePrimaryFieldName", (Object)tablePrimaryFieldName);
                jsonObject.put("inDB", (Object)inDbJson);
                break;
            }
            default: {
                throw new RuntimeException("\u6570\u636e\u6e90\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
            }
        }
        jsonObject.put("heightFieldName", (Object)param.getHeightFieldName());
        DataSourceDTO outDataSource = dataSourceService.getDataSourceDetail(param.getOutDataSourceKey());
        JSONObject outDbJson = new JSONObject();
        if (StringUtil.isEmptyOrWhiteSpace((String)outDataSource.getUserName())) {
            outDbJson.put("dbConnectionStr", (Object)String.format("mongodb://%s", outDataSource.getUrl()));
        } else {
            outDbJson.put("dbConnectionStr", (Object)String.format("mongodb://%s:%s@%s", outDataSource.getUserName(), outDataSource.getPassword(), outDataSource.getUrl()));
        }
        outDbJson.put("tableName", (Object)param.getOutDatasetName());
        jsonObject.put("outToDB", (Object)outDbJson);
        if (param.getUseTexture().booleanValue()) {
            JSONObject textureJson = new JSONObject();
            textureJson.put("defaultWallImagePath", (Object)param.getDefaultWallImageName());
            textureJson.put("defaultRoofImagePath", (Object)param.getDefaultRoofImageName());
            textureJson.put("roofImageWidthLength", (Object)param.getRoofImageWidthLength());
            textureJson.put("roofImageHeightLength", (Object)param.getRoofImageHeightLength());
            textureJson.put("wallImageWidthLength", (Object)param.getWallImageWidthLength());
            textureJson.put("wallImageHeightLength", (Object)param.getWallImageHeightLength());
            String alphaMode = param.getTransparency() != false ? "BLEND" : "OPAQUE";
            textureJson.put("alphaMode", (Object)alphaMode);
            if (param.getTextureClassifyFilters() != null && param.getTextureClassifyFilters().length > 0) {
                JSONArray filterArray = new JSONArray();
                for (TextureClassifyFilter filter : param.getTextureClassifyFilters()) {
                    JSONObject filterJson = new JSONObject();
                    filterJson.put("filter", (Object)filter.getFilter());
                    filterJson.put("wallImagePath", (Object)filter.getWallImage());
                    filterJson.put("roofImagePath", (Object)filter.getRoofImage());
                    filterArray.add((Object)filterJson);
                }
                textureJson.put("imageClassifyFilters", (Object)filterArray);
            }
            jsonObject.put("texture", (Object)textureJson);
        }
        jsonObject.put("heightScale", (Object)param.getHeightScale());
        jsonObject.put("defaultTerrain", (Object)param.getDefaultTerrain());
        jsonObject.put("defaultHeight", (Object)param.getDefaultHeight());
        jsonObject.put("useTexture", (Object)param.getUseTexture());
        jsonObject.put("useLight", (Object)param.getUseLight());
        jsonObject.put("useOutline", (Object)param.getUseOutline());
        jsonObject.put("threadCount", (Object)param.getThreadCount());
        jsonObject.put("leafLevel", (Object)14);
        BufferedWriter writer = null;
        try {
            if (configFile.exists()) {
                boolean alphaMode = configFile.delete();
            }
            boolean isCreate = configFile.createNewFile();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8), 1024);
            writer.write(jsonObject.toJSONString());
            writer.close();
            FileInputStream fileInputStream = new FileInputStream(configFile);
            return new MockMultipartFile("file", configFile.getName(), "text/plain", IOUtils.toByteArray((InputStream)fileInputStream));
        }
        catch (Exception e) {
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff01");
        }
    }
}

