/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.globemodel.tiltphotography;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.globemodel.ConfigPathUtil;
import com.geoway.dgt.globemodel.HttpHelper;
import com.geoway.dgt.globemodel.tiltphotography.param.TiltInData;
import com.geoway.dgt.globemodel.tiltphotography.param.TiltPhotographyLightweightParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class TiltPhotographyLightweightTool
extends ToolBase {
    private String modelTaskId = "";

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        Object item;
        TiltPhotographyLightweightParam param = (TiltPhotographyLightweightParam)toolParam;
        param.setConfigPath(this.createConfigFile(param, null));
        if (param.getUseModel0().booleanValue()) {
            item = new DataStripingResult();
            item.setName("\u8ba1\u7b97\u5143\u6570\u636e");
            item.setPriority(100);
            param.setExecuteModel(0);
            item.setToolExecuteParam((IToolParam)param);
            oneDataCallback.accept((DataStripingResult)item);
        }
        if (param.getUseModel1().booleanValue()) {
            for (TiltInData data : param.getInDataList()) {
                File[] subFiles;
                File dir = new File(data.getDataPath());
                if (!dir.exists() || !dir.isDirectory() || (subFiles = dir.listFiles()) == null) continue;
                for (File item2 : subFiles) {
                    if (!item2.isDirectory()) continue;
                    DataStripingResult taskItem = new DataStripingResult();
                    taskItem.setName(data.getLayerName() + "-" + item2.getName());
                    taskItem.setPriority(50);
                    taskItem.setFailRetryNumber(3000);
                    param.setExecuteModel(1);
                    param.setLayerName(data.getLayerName());
                    param.setTilePath(item2.getPath());
                    taskItem.setToolExecuteParam((IToolParam)param);
                    oneDataCallback.accept(taskItem);
                }
            }
        }
        if (param.getUseModel2().booleanValue()) {
            item = new DataStripingResult();
            item.setName("\u5408\u5e76\u9876\u5c42\u5757-\u6784\u5efa\u7d22\u5f15");
            item.setPriority(0);
            param.setExecuteModel(2);
            item.setToolExecuteParam((IToolParam)param);
            oneDataCallback.accept((DataStripingResult)item);
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        TiltPhotographyLightweightParam param = (TiltPhotographyLightweightParam)executeParam;
        File file = new File(param.getConfigPath());
        if (!file.exists()) {
            this.createConfigFile(param, param.getConfigPath());
        }
        MultipartFile configFile = this.convertToMultipartFile(param.getConfigPath());
        try {
            String cmd = " -e 1";
            if (param.getExecuteModel() == 0) {
                cmd = " -m 0 -e 1";
            } else if (param.getExecuteModel() == 1) {
                cmd = String.format(" -m 1 -i %s -l %s -e 1", param.getTilePath(), param.getLayerName());
            } else if (param.getExecuteModel() == 2) {
                cmd = " -m 2 -e 1";
            }
            String url = EnvironmentConfig.getProperty((String)"project.vector-to-3dtiles-tool-url");
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("index", "1"));
            params.add((NameValuePair)new BasicNameValuePair("extParam", cmd));
            this.invokeExcuteLog(url);
            this.invokeExcuteLog(cmd);
            String result = HttpHelper.doPost(String.format("%sstartByConfig", url), configFile, params);
            if (StringUtil.isEmptyOrWhiteSpace((String)result)) {
                executeResult.setSuccess(Boolean.valueOf(false));
                this.invokeExcuteLog("\u542f\u52a8\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
                executeResult.setErrorMessage("\u542f\u52a8\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u5931\u8d25\uff01");
                return executeResult;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            this.modelTaskId = jsonObject.getJSONObject("data").get((Object)"id").toString();
            this.invokeExcuteLog("\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u8fdb\u7a0b\uff1a" + this.modelTaskId);
            while (!this.isAborted) {
                try {
                    String resultString = HttpHelper.doGet(String.format("%sdetail?id=%s", url, this.modelTaskId));
                    if (StringUtil.isEmptyOrWhiteSpace((String)resultString)) {
                        this.invokeExcuteLog("\u83b7\u53d6\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
                        executeResult.setErrorMessage("\u83b7\u53d6\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01");
                        continue;
                    }
                    JSONObject taskJsonObject = JSONObject.parseObject((String)resultString);
                    if (taskJsonObject == null || taskJsonObject.getJSONObject("data") == null) continue;
                    Object endTimeObj = taskJsonObject.getJSONObject("data").get((Object)"endTime");
                    Object exitValueObj = taskJsonObject.getJSONObject("data").get((Object)"exitValue");
                    if (endTimeObj == null || exitValueObj == null) continue;
                    this.isAborted = true;
                    JSONArray messages = taskJsonObject.getJSONObject("data").getJSONArray("message");
                    for (int i = 0; i < messages.size(); ++i) {
                        if ("Tiling".equals(messages.getString(i))) continue;
                        this.invokeExcuteLog(messages.getString(i));
                    }
                    if ("0".equals(exitValueObj.toString())) continue;
                    executeResult.setSuccess(Boolean.valueOf(false));
                }
                catch (Exception e) {
                    executeResult.setSuccess(Boolean.valueOf(false));
                    this.log.error(e.getMessage(), (Throwable)e);
                    this.invokeExcuteLog("\u83b7\u53d6\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
                    executeResult.setErrorMessage("\u83b7\u53d6\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u6267\u884c\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage());
                    this.isAborted = true;
                }
            }
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            this.log.error(e.getMessage(), (Throwable)e);
            this.invokeExcuteLog("\u542f\u52a8\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
            executeResult.setErrorMessage("\u542f\u52a8\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177\u5931\u8d25\uff01" + e.getMessage());
        }
        return executeResult;
    }

    public void abort() {
        super.abort();
        this.invokeExcuteLog("\u7ec8\u6b62\u4e09\u7ef4\u6a21\u578b\u8f7b\u91cf\u5316\u5de5\u5177", TaskLogLevelEnum.Error);
        if (!StringUtil.isEmptyOrWhiteSpace((String)this.modelTaskId)) {
            try {
                String url = EnvironmentConfig.getProperty((String)"project.vector-to-3dtiles-tool-url");
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add((NameValuePair)new BasicNameValuePair("id", this.modelTaskId));
                String string = HttpHelper.doPost(String.format("%sstop", url), null, params);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String createConfigFile(TiltPhotographyLightweightParam param, String configFilePath) {
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        DataSourceDTO dataSource = dataSourceService.getDataSourceDetail(param.getOutDataSourceKey());
        String url = dataSource.getUrl();
        if (!StringUtil.isEmptyOrWhiteSpace((String)dataSource.getUserName())) {
            url = String.format("%s:%s@%s", dataSource.getUserName(), dataSource.getPassword(), dataSource.getUrl());
        }
        String storagePath = String.format("mongodb://%s/%s/tileset.json", url, param.getOutDatasetName());
        if (StringUtil.isEmptyOrWhiteSpace((String)configFilePath)) {
            configFilePath = Paths.get(ConfigPathUtil.getConfigPath().toString(), System.currentTimeMillis() + "_GW3DTilesBuilder.txt").toString();
        }
        File configFile = new File(configFilePath);
        ArrayList<String> paraLst = new ArrayList<String>();
        paraLst.add(String.format("DatasetName=%s", param.getOutDatasetName()));
        paraLst.add(String.format("OutputPath=\"%s\"", storagePath));
        paraLst.add("");
        paraLst.add(String.format("NumThreads=%s", param.getConcurrentCount()));
        paraLst.add(String.format("MergeLevels=%s", param.getMergeLevels()));
        paraLst.add(String.format("MergeMode=%s", param.getMergeMode()));
        int mergeTileRootValue = param.getMergeTileRoot() != false ? 1 : 0;
        paraLst.add(String.format("MergeTileRoot = %s", mergeTileRootValue));
        String enableSmooth = param.getEnableSmooth() != false ? "true" : "false";
        paraLst.add(String.format("EnableSmooth = %s", enableSmooth));
        if (param.getEnableSmooth().booleanValue()) {
            paraLst.add(String.format("SmoothIterateNum = %s", param.getSmoothIterateNum()));
        }
        paraLst.add("");
        paraLst.add("Scene:");
        paraLst.add(String.format("CollapseLevels = %s", param.getCollapseLevels()));
        paraLst.add("");
        paraLst.add("3DTiles:");
        paraLst.add("GeoErrorScale = " + param.getGeoErrorScale());
        paraLst.add(String.format("GeoCurveThreshold = %s", param.getGeoCurveThreshold()));
        paraLst.add("");
        paraLst.add("SMS:");
        paraLst.add("BeginDepth = 4");
        paraLst.add("TargetError = 0.5");
        paraLst.add("TargetError_Light = 1.0");
        paraLst.add("");
        paraLst.add("GLTF:");
        paraLst.add(String.format("EnableDraco = %s", param.getEnableDraco() != false ? "true" : "false"));
        paraLst.add("");
        paraLst.add("Texture:");
        paraLst.add(String.format("MimeType = %s", param.getMimeType()));
        paraLst.add("");
        paraLst.add("Layers:");
        for (TiltInData data : param.getInDataList()) {
            paraLst.add(String.format("%s = %s,%s", data.getLayerName(), data.getDataPath(), data.getMetaDataPath()));
        }
        paraLst.add("LayerArguments:");
        for (TiltInData data : param.getInDataList()) {
            int level = data.getRemoveSingleLevel();
            if (!data.getRemoveSingleFork().booleanValue()) {
                level = 0;
            }
            paraLst.add(String.format("%s = %s", data.getLayerName(), level));
        }
        BufferedWriter writer = null;
        try {
            if (configFile.exists()) {
                boolean data = configFile.delete();
            }
            boolean isCreate = configFile.createNewFile();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8), 1024);
            for (String line : paraLst) {
                writer.write(line);
                writer.newLine();
            }
            writer.close();
            return configFile.getPath();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private MultipartFile convertToMultipartFile(String configFilePath) {
        try {
            File configFile = new File(configFilePath);
            FileInputStream fileInputStream = new FileInputStream(configFile);
            return new MockMultipartFile("file", configFile.getName(), "text/plain", IOUtils.toByteArray((InputStream)fileInputStream));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

