/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.globemodel.modelrange;

import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.SystemUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.globemodel.modelrange.param.ModelDataTypeEnum;
import com.geoway.dgt.globemodel.modelrange.param.ModelRangeCollectorParam;
import com.github.mreutegg.laszip4j.LASHeader;
import com.github.mreutegg.laszip4j.LASReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class ModelRangeCollectorTool
extends ToolBase {
    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        DataStripingResult item = new DataStripingResult();
        item.setName("\u5206\u533a\u8303\u56f4\u91c7\u96c6");
        item.setPriority(100);
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        item.setToolExecuteParam(toolParam);
        oneDataCallback.accept(item);
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u6570\u636e\u8def\u5f84\uff1a" + inputDataParam.getFilePath());
        ModelRangeCollectorParam param = (ModelRangeCollectorParam)executeParam;
        ModelDataTypeEnum modelDataTypeEnum = ModelDataTypeEnum.getByValue(param.getModelDataType());
        File folder = new File(inputDataParam.getFilePath());
        String toolDir = Paths.get(EnvironmentConfig.getProperty((String)"project.globe-model-tool-path"), new String[0]).toAbsolutePath().toString();
        Path outFile = Paths.get(outputDataParam.getFilePath(), param.getTargetDataName() + ".shp");
        switch (modelDataTypeEnum) {
            case ObliqueModelData: {
                Path workingDir = Paths.get(toolDir, "Real3D");
                String obliqueToolFile = Paths.get(toolDir, "Real3D", "Earth", "gwearth_conv").toString();
                if (folder.isDirectory() && folder.exists()) {
                    File[] subFiles = folder.listFiles();
                    if (subFiles == null || subFiles.length == 0) {
                        this.invokeExcuteLog("\u6570\u636e\u6587\u4ef6\u5939\u4e3a\u7a7a\uff01", TaskLogLevelEnum.Error);
                        executeResult.setSuccess(Boolean.valueOf(false));
                        return executeResult;
                    }
                    String xmlFilePath = this.findXmlFile(subFiles);
                    if (StringUtil.isEmptyOrWhiteSpace((String)xmlFilePath)) {
                        this.invokeExcuteLog("\u672a\u627e\u5230xml\u6587\u4ef6\uff01", TaskLogLevelEnum.Error);
                        executeResult.setSuccess(Boolean.valueOf(false));
                        return executeResult;
                    }
                    String excuteParams = String.format("--type CombineTable --in %s --out %s", xmlFilePath, outFile.toString());
                    int exitCode = this.doExecuteTool(obliqueToolFile, excuteParams, workingDir.toString());
                    executeResult.setSuccess(Boolean.valueOf(exitCode == 0));
                } else if (folder.isFile() && folder.exists() && inputDataParam.getFilePath().toLowerCase(Locale.ROOT).endsWith(".xml")) {
                    String excuteParams = String.format("--type CombineTable --in %s --out %s", inputDataParam.getFilePath(), outFile.toString());
                    int exitCode = this.doExecuteTool(obliqueToolFile, excuteParams, workingDir.toString());
                    executeResult.setSuccess(Boolean.valueOf(exitCode == 0));
                } else {
                    this.invokeExcuteLog("\u672a\u627e\u5230xml\u6587\u4ef6\uff01", TaskLogLevelEnum.Error);
                    executeResult.setSuccess(Boolean.valueOf(false));
                }
                return executeResult;
            }
            case PointCloudModelData: {
                Integer srid = param.getSpatialRef();
                ISpatialReferenceSystem srcSystem = null;
                if (srid == null || srid == 0) {
                    this.invokeExcuteLog("\u672a\u6307\u5b9a\u70b9\u4e91\u6570\u636e\u7684\u7a7a\u95f4\u53c2\u8003\uff01", TaskLogLevelEnum.Warning);
                } else {
                    srcSystem = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
                }
                Path pWorkingDir = Paths.get(toolDir, "lasInfo");
                String pointCloudTool = Paths.get(toolDir, "lasInfo", "lasinfo64").toString();
                FileFilter pattern = pathname -> pathname.isFile() && pathname.getPath().toLowerCase(Locale.ROOT).endsWith(".las");
                List<File> files = this.searchFileData(inputDataParam.getFilePath(), pattern);
                if (files == null || files.size() == 0) {
                    this.invokeExcuteLog("\u672a\u627e\u5230las\u6587\u4ef6\uff01", TaskLogLevelEnum.Error);
                    executeResult.setSuccess(Boolean.valueOf(false));
                    return executeResult;
                }
                IFeatureWorkspace targetWorkspace = null;
                IFeatureCursor cursor = null;
                try {
                    targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)outFile.toString());
                    Fields newFields = new Fields();
                    newFields.addField(FieldUtil.buildObjectIdField((String)"objectId", (String)"objectId"));
                    newFields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.MultiPolygon, (int)4490));
                    newFields.addField((IField)new Field("name", "name", FieldType.String, 200));
                    IFeatureClass featureClass = targetWorkspace.createFeatureClass(param.getTargetDataName(), (IFields)newFields, FeatureType.Polygon, "shape", "");
                    if (featureClass == null) {
                        this.invokeExcuteLog("\u521b\u5efashp\u6587\u4ef6\u5931\u8d25\uff01", TaskLogLevelEnum.Error);
                        executeResult.setSuccess(Boolean.valueOf(false));
                        ExecuteResult executeResult2 = executeResult;
                        return executeResult2;
                    }
                    featureClass.createSpatialIndex();
                    ISpatialReferenceSystem tarSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
                    cursor = featureClass.insertFeature();
                    for (File file : files) {
                        String name = FileUtil.getFileNameWithoutExtension((String)file.getName());
                        IFeature feature = featureClass.createFeature();
                        feature.setValue("name", (Object)name);
                        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                            LASHeader header = LASReader.getHeader((InputStream)in);
                            double xMin = header.getMinX();
                            double yMin = header.getMinY();
                            double zMin = header.getMinZ();
                            double xMax = header.getMaxX();
                            double yMax = header.getMaxY();
                            double zMax = header.getMaxZ();
                            IEnvelope envelope = GeometryFunc.createEnvelope((double)xMin, (double)yMin, (double)xMax, (double)yMax);
                            feature.setGeometry(envelope.clone());
                        }
                        catch (Exception e) {
                            this.log.error("\u8bfb\u53d6las\u6587\u4ef6\u8303\u56f4\u5931\u8d25", (Throwable)e);
                            this.invokeExcuteLog("\u8bfb\u53d6las\u6587\u4ef6\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage(), TaskLogLevelEnum.Error);
                            continue;
                        }
                        if (srcSystem != null) {
                            feature.getGeometry().project(srcSystem, tarSystem);
                        }
                        cursor.insertFeature(feature);
                    }
                }
                catch (Exception e) {
                    this.invokeExcuteLog("\u8981\u7d20\u5199\u5165\u5931\u8d25\uff01" + e.getMessage(), TaskLogLevelEnum.Error);
                    executeResult.setSuccess(Boolean.valueOf(false));
                }
                finally {
                    if (cursor != null) {
                        cursor.release();
                    }
                    if (targetWorkspace != null) {
                        targetWorkspace.close();
                    }
                }
                return executeResult;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6a21\u578b\u6570\u636e\u7c7b\u578b\uff01");
    }

    private Integer doExecuteTool(String toolFileName, String excuteParams, String workingDirectory) {
        try {
            String line;
            ProcessBuilder processBuilder;
            String charsetName = "GBK";
            if (SystemUtil.isWindows()) {
                processBuilder = new ProcessBuilder("cmd", "/c", toolFileName + " " + excuteParams);
                processBuilder.directory(new File(workingDirectory));
            } else {
                processBuilder = new ProcessBuilder("sh", "-c", toolFileName + " " + excuteParams);
                Map<String, String> environment = processBuilder.environment();
                environment.put("LD_LIBRARY_PATH", FileUtil.getDirectoryName((String)toolFileName));
                charsetName = "UTF-8";
            }
            processBuilder.redirectErrorStream(true);
            this.log.info("\u6267\u884c\u5de5\u5177\uff1a{} {}", (Object)toolFileName, (Object)excuteParams);
            Process process = processBuilder.start();
            InputStream in = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, charsetName));
            while ((line = br.readLine()) != null) {
                this.invokeExcuteLog(line);
            }
            in.close();
            process.waitFor();
            int exitCode = process.exitValue();
            this.log.info("\u6267\u884c\u5de5\u5177\u9000\u51fa\u7801\uff1a{}", (Object)exitCode);
            return exitCode;
        }
        catch (IOException | InterruptedException e) {
            this.invokeExcuteLog(String.format("\u4efb\u52a1\u6267\u884c\u5931\u8d25 : %s", e.getMessage()));
            return -2;
        }
    }

    private Integer doExecuteLasInfoTool(String toolFileName, String excuteParams, String workingDirectory, IFeature feature) {
        try {
            String line;
            ProcessBuilder processBuilder;
            String charsetName = "GBK";
            if (SystemUtil.isWindows()) {
                processBuilder = new ProcessBuilder("cmd", "/c", toolFileName + " " + excuteParams);
                processBuilder.directory(new File(workingDirectory));
            } else {
                processBuilder = new ProcessBuilder("sh", "-c", toolFileName + " " + excuteParams);
                Map<String, String> environment = processBuilder.environment();
                environment.put("LD_LIBRARY_PATH", FileUtil.getDirectoryName((String)toolFileName));
                charsetName = "UTF-8";
            }
            processBuilder.redirectErrorStream(true);
            this.log.info("\u6267\u884c\u5de5\u5177\uff1a{} {}", (Object)toolFileName, (Object)excuteParams);
            Process process = processBuilder.start();
            InputStream in = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, charsetName));
            Double xMin = null;
            Double yMin = null;
            Double xMax = null;
            Double yMax = null;
            while ((line = br.readLine()) != null) {
                String[] arr;
                this.invokeExcuteLog(line);
                if (line.trim().startsWith("min x y z")) {
                    arr = line.split(" ");
                    xMin = Double.parseDouble(arr[arr.length - 3]);
                    yMin = Double.parseDouble(arr[arr.length - 2]);
                    continue;
                }
                if (!line.trim().startsWith("max x y z")) continue;
                arr = line.split(" ");
                xMax = Double.parseDouble(arr[arr.length - 3]);
                yMax = Double.parseDouble(arr[arr.length - 2]);
            }
            if (xMin != null && xMax != null) {
                IEnvelope envelope = GeometryFunc.createEnvelope((double)xMin, (double)yMin, (double)xMax, (double)yMax);
                feature.setGeometry(envelope.clone());
            }
            in.close();
            process.waitFor();
            int exitCode = process.exitValue();
            this.log.info("\u6267\u884c\u5de5\u5177\u9000\u51fa\u7801\uff1a{}", (Object)exitCode);
            return exitCode;
        }
        catch (IOException | InterruptedException e) {
            this.invokeExcuteLog(String.format("\u4efb\u52a1\u6267\u884c\u5931\u8d25 : %s", e.getMessage()));
            return -2;
        }
    }

    private String findXmlFile(File[] subFiles) {
        String xmlFilePath = "";
        for (File rootFile : subFiles) {
            String name = rootFile.getName();
            if (rootFile.isDirectory()) {
                File[] files = rootFile.listFiles((file, fileName) -> file.isFile() && file.getPath().toLowerCase(Locale.ROOT).endsWith(".xml"));
                if (files == null || files.length <= 0) continue;
                xmlFilePath = files[0].getPath();
                break;
            }
            if (!rootFile.isFile() || !name.contains(".") || !".xml".equalsIgnoreCase(name.substring(name.lastIndexOf(".")))) continue;
            xmlFilePath = rootFile.getPath();
            break;
        }
        return xmlFilePath;
    }

    private List<File> searchFileData(String path, FileFilter pattern) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            File parentFolder = new File(path);
            File[] subFiles = parentFolder.listFiles(pattern);
            if (subFiles == null) {
                return files;
            }
            for (File file : subFiles) {
                if (!file.isFile()) continue;
                files.add(file);
            }
            FileFilter filter = File::isDirectory;
            File[] allFile = parentFolder.listFiles(filter);
            if (allFile == null) {
                return files;
            }
            for (File item : allFile) {
                files.addAll(this.searchFileData(item.getPath(), pattern));
            }
            return files;
        }
        catch (Exception ex) {
            this.invokeExcuteLog(ex.getMessage());
            return files;
        }
    }
}

