/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.onecode.service;

import cn.hutool.core.convert.NumberChineseFormatter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.dgt.onecode.dao.CodeEntityClassDao;
import com.geoway.dgt.onecode.dto.EntityClassEditDTO;
import com.geoway.dgt.onecode.dto.EntityClassSpecialDataDTO;
import com.geoway.dgt.onecode.entity.CodeEntityClass;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CodeEntityClassService {
    private static final Logger log = LoggerFactory.getLogger(CodeEntityClassService.class);
    @Resource
    private CodeEntityClassDao codeEntityClassDao;

    public List<CodeEntityClass> list() {
        List<CodeEntityClass> entityClassList = this.codeEntityClassDao.selectAll();
        entityClassList.forEach(this::setEntityClassConfig);
        return entityClassList;
    }

    public List<CodeEntityClass> tree() {
        List<CodeEntityClass> entityClassList = this.codeEntityClassDao.selectAll();
        Map<String, List<CodeEntityClass>> map = entityClassList.stream().collect(Collectors.groupingBy(c -> c.getPid() == null ? "" : c.getPid()));
        for (CodeEntityClass codeEntityClass : entityClassList) {
            this.setEntityClassConfig(codeEntityClass);
            codeEntityClass.setChildren(map.get(codeEntityClass.getId()));
        }
        return map.get("");
    }

    public Map<String, String> getClassNames() {
        List<CodeEntityClass> entityClassList = this.codeEntityClassDao.selectAll();
        HashMap<String, String> classNameMap = new HashMap<String, String>();
        for (CodeEntityClass codeEntityClass : entityClassList) {
            if (StringUtil.isEmpty((String)codeEntityClass.getCode()) || ListUtil.exist(entityClassList, c -> codeEntityClass.getId().equals(c.getPid()))) continue;
            classNameMap.put(codeEntityClass.getName(), codeEntityClass.getCode());
        }
        return classNameMap;
    }

    public List<CodeEntityClass> getEntityClassTree(String keyword) {
        List<CodeEntityClass> allClass = this.codeEntityClassDao.selectAll();
        if (allClass == null || allClass.size() == 0) {
            return new ArrayList<CodeEntityClass>();
        }
        allClass.forEach(this::setEntityClassConfig);
        return this.completeChildren(allClass, "", keyword);
    }

    public Boolean importEntityClass(MultipartFile file) {
        ArrayList<CodeEntityClass> list = new ArrayList<CodeEntityClass>();
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            List dataList = ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().sheetNo(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doReadSync();
            HashMap levelPidMap = new HashMap(0);
            dataList.forEach(m -> {
                CodeEntityClass entityClass = new CodeEntityClass();
                entityClass.setId(UUID.randomUUID().toString().replace("-", ""));
                Object[] values = m.values().toArray();
                for (int i = 0; i < values.length; ++i) {
                    if (StringUtil.isEmptyOrWhiteSpace(values[i] == null ? null : values[i].toString())) continue;
                    if (i == m.values().size() - 1) {
                        entityClass.setCode(values[i].toString());
                        continue;
                    }
                    entityClass.setName(values[i].toString());
                    entityClass.setLevel(i + 1);
                }
                levelPidMap.put(entityClass.getLevel(), entityClass.getId());
                entityClass.setPid(levelPidMap.getOrDefault(entityClass.getLevel() - 1, ""));
                list.add(entityClass);
            });
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream});
        if (list.size() > 0) {
            this.codeEntityClassDao.deleteAll();
            this.codeEntityClassDao.batchInsert(list);
        }
        return list.size() > 0;
    }

    public void exportEntityClass() {
        List<CodeEntityClass> allClass = this.codeEntityClassDao.selectAll();
        if (allClass == null || allClass.size() == 0) {
            return;
        }
        Integer maxLevel = this.codeEntityClassDao.queryMaxLevel();
        LinkedList data = new LinkedList();
        LinkedList<String> title = new LinkedList<String>();
        for (int i = 0; i < maxLevel + 1; ++i) {
            if (i == maxLevel) {
                title.add("6\u4f4d\u5206\u7c7b\u7801");
                continue;
            }
            String number = NumberChineseFormatter.format((long)(i + 1), (boolean)false);
            title.add(String.format("%s\u7ea7\u7c7b", number));
        }
        data.add(title);
        for (CodeEntityClass entityClass : allClass) {
            LinkedList<String> item = new LinkedList<String>();
            for (int i = 0; i < maxLevel + 1; ++i) {
                if (i + 1 == entityClass.getLevel()) {
                    item.add(entityClass.getName());
                    continue;
                }
                if (i == maxLevel) {
                    item.add(entityClass.getCode());
                    continue;
                }
                item.add("");
            }
            data.add(item);
        }
        DownloadUtil.downloadExcelFile((String)"\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801.xlsx", data);
    }

    public CodeEntityClass getEntityClass(String id) {
        CodeEntityClass codeEntityClass = this.codeEntityClassDao.selectByPrimaryKey(id);
        if (codeEntityClass == null) {
            return null;
        }
        this.setEntityClassConfig(codeEntityClass);
        return codeEntityClass;
    }

    public void saveEntityClass(EntityClassEditDTO entityClassEditDTO) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entityClassEditDTO.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entityClassEditDTO.getName()), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CodeEntityClass existCodeEntityClass = this.codeEntityClassDao.selectByPrimaryKey(entityClassEditDTO.getId());
        Assert.notNull((Object)existCodeEntityClass, (String)"\u5b9e\u4f53\u5206\u7c7b\u4e0d\u5b58\u5728");
        if (!entityClassEditDTO.getCode().equals(existCodeEntityClass.getCode()) && this.codeEntityClassDao.selectByCode(entityClassEditDTO.getId()) != null) {
            throw new RuntimeException(entityClassEditDTO.getCode() + "\u7f16\u7801\u5df2\u5b58\u5728");
        }
        existCodeEntityClass.setCode(entityClassEditDTO.getCode());
        existCodeEntityClass.setName(entityClassEditDTO.getName());
        if (entityClassEditDTO.getSpecialDatasets() != null) {
            existCodeEntityClass.setStrSpecialDatasets(JSON.toJSONString(entityClassEditDTO.getSpecialDatasets()));
        }
        this.codeEntityClassDao.updateByPrimaryKey(existCodeEntityClass);
    }

    public void deleteEntityClass(String id) {
        List<CodeEntityClass> entityClassList = this.codeEntityClassDao.selectAll();
        if (entityClassList == null || entityClassList.size() == 0) {
            return;
        }
        CodeEntityClass codeEntityClass = (CodeEntityClass)ListUtil.find(entityClassList, c -> c.getId().equals(id));
        if (codeEntityClass == null) {
            return;
        }
        Map<String, List<CodeEntityClass>> map = entityClassList.stream().collect(Collectors.groupingBy(c -> c.getPid() == null ? "" : c.getPid()));
        List<CodeEntityClass> subList = this.getAllSubEntityClass(codeEntityClass, map);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(codeEntityClass.getId());
        ids.addAll(ListUtil.convertAll(subList, c -> c.getId()));
        this.codeEntityClassDao.batchDeleteByIds(ids);
    }

    private List<CodeEntityClass> getAllSubEntityClass(CodeEntityClass codeEntityClass, Map<String, List<CodeEntityClass>> classGroups) {
        ArrayList<CodeEntityClass> result = new ArrayList<CodeEntityClass>();
        List<CodeEntityClass> subList = classGroups.get(codeEntityClass.getId());
        for (CodeEntityClass sub : subList) {
            if (!classGroups.containsKey(sub.getId())) continue;
            result.addAll(this.getAllSubEntityClass(sub, classGroups));
        }
        return result;
    }

    private void setEntityClassConfig(CodeEntityClass entityClass) {
        try {
            if (StringUtil.isNotEmpty((String)entityClass.getStrSpecialDatasets())) {
                entityClass.setSpecialDatasets(JSONArray.parseArray((String)entityClass.getStrSpecialDatasets(), EntityClassSpecialDataDTO.class));
            }
        }
        catch (Exception e) {
            log.error(entityClass.getCode(), (Throwable)e);
        }
    }

    private List<CodeEntityClass> completeChildren(List<CodeEntityClass> allEntityClass, String pId, String keyword) {
        ArrayList<CodeEntityClass> dtoList = new ArrayList<CodeEntityClass>();
        List subEntityClass = ListUtil.findAll(allEntityClass, t -> StringUtil.equals((String)pId, (String)t.getPid()));
        for (CodeEntityClass entityClass : subEntityClass) {
            List<CodeEntityClass> children = this.completeChildren(allEntityClass, entityClass.getId(), keyword);
            entityClass.setChildren(new ArrayList<CodeEntityClass>());
            if (StringUtil.isEmpty((String)keyword) || entityClass.getName().toLowerCase().contains(keyword.toLowerCase()) || entityClass.getCode().equals(keyword) || children.size() > 0) {
                entityClass.setChildren(children);
                dtoList.add(entityClass);
            }
            if (entityClass.getChildren().size() == 0) {
                entityClass.setCount(1);
                continue;
            }
            int count = 1;
            for (CodeEntityClass child : entityClass.getChildren()) {
                count += child.getCount().intValue();
            }
            entityClass.setCount(count);
        }
        return dtoList;
    }
}

