/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.extract;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.geosrv.AtlasServer;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileDataSource;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileMeta;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileStorageFormat;
import com.geoway.adf.gis.tile.guobiao.GuoBiaoTileDataSource;
import com.geoway.adf.gis.tile.mbtiles.MBTilesTileDataSource;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.TileTransform;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.adf.gis.tile.wmts.VectorTileDataSource;
import com.geoway.adf.gis.tile.wmts.WMTSTileDataSource;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.tile.constant.StorageTypeEnum;
import com.geoway.dgt.tile.dto.TileStorageInfo;
import com.geoway.dgt.tile.extract.ExtractTileParam;
import com.geoway.dgt.tile.util.TileTaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ExtractTileTool
extends ToolBase {
    private DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        ITileDataset tileDataset = this.openSourceTileDataset(batchInputData);
        TileSchema tileSchema = tileDataset.getTileMeta().getTileSchema();
        ExtractTileParam extractTileParam = (ExtractTileParam)toolParam;
        MapExtent extractExtent = extractTileParam.getExtractExtent();
        IGeometry filterGeometry = null;
        if (!StringUtil.isEmptyOrWhiteSpace((String)extractTileParam.getExtractGeometry())) {
            filterGeometry = GeometryFunc.createGeometry((String)extractTileParam.getExtractGeometry());
            IEnvelope envelope = filterGeometry.getEnvelope();
            extractExtent = new MapExtent(Double.valueOf(envelope.getXMin()), Double.valueOf(envelope.getYMin()), Double.valueOf(envelope.getXMax()), Double.valueOf(envelope.getYMax()));
        }
        MapExtent dataExtent = null;
        if (tileDataset.getTileMeta().getXmin() != null) {
            dataExtent = new MapExtent(tileDataset.getTileMeta().getXmin(), tileDataset.getTileMeta().getYmin(), tileDataset.getTileMeta().getXmax(), tileDataset.getTileMeta().getYmax());
        }
        int extentId = 1;
        if (extractTileParam.getStorageInfo().getStorageTypeEnum().equals((Object)StorageTypeEnum.MBTiles)) {
            this.distributionTask(dataExtent, extractExtent, filterGeometry, extractTileParam.getFromLevel(), extractTileParam.getToLevel(), extentId, extractTileParam, batchInputData, batchOutputData, oneDataCallback);
        } else {
            for (int level = extractTileParam.getFromLevel().intValue(); level <= extractTileParam.getToLevel(); ++level) {
                List<MapExtent> tileExtents = TileTaskHelper.parseToBundleMultiPartExtent(tileSchema, level, extractExtent);
                extentId = 1;
                for (MapExtent regionExtent : tileExtents) {
                    extentId = this.distributionTask(dataExtent, regionExtent, filterGeometry, level, level, extentId, extractTileParam, batchInputData, batchOutputData, oneDataCallback);
                }
            }
        }
        this.createTargetTileDataset(extractTileParam, tileDataset.getTileMeta());
    }

    private int distributionTask(MapExtent dataExtent, MapExtent regionExtent, IGeometry filterGeometry, Integer begeinLevel, Integer endLevel, int extentId, ExtractTileParam extractTileParam, DataParam batchInputData, DataParam batchOutputData, Consumer<DataStripingResult> oneDataCallback) {
        if (dataExtent != null && !this.intersect(dataExtent, regionExtent)) {
            return extentId;
        }
        IGeometry regionGeometry = null;
        if (filterGeometry != null) {
            if (!this.intersect(filterGeometry, regionExtent)) {
                return extentId;
            }
            regionGeometry = filterGeometry.intersection((IGeometry)GeometryFunc.createEnvelope((double)regionExtent.getMinX().doubleValue(), (double)regionExtent.getMinY().doubleValue(), (double)regionExtent.getMaxX().doubleValue(), (double)regionExtent.getMaxY().doubleValue()));
        }
        DataStripingResult item = new DataStripingResult();
        item.setName(String.format("\u7b2c%d\u7ea7-\u7b2c%d\u7ea7-\u533a\u57df%d", begeinLevel, endLevel, extentId));
        item.setPriority(100);
        ExtractTileParam executeParam = new ExtractTileParam();
        executeParam.setExtractExtent(regionExtent);
        executeParam.setExtractGeometry(regionGeometry == null ? null : regionGeometry.toWkt());
        executeParam.setFromLevel(begeinLevel);
        executeParam.setToLevel(endLevel);
        executeParam.setStorageInfo(extractTileParam.getStorageInfo());
        executeParam.setStyleId(extractTileParam.getStyleId());
        executeParam.setHasMap(extractTileParam.getHasMap());
        executeParam.setHasLabel(extractTileParam.getHasLabel());
        item.setToolExecuteParam((IToolParam)executeParam);
        item.setInputData(batchInputData);
        item.setOutputData(batchOutputData);
        oneDataCallback.accept(item);
        return ++extentId;
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputDataPath, IToolParam toolParam) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        this.invokeExcuteLog("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a" + inputDataParam.getName());
        ITileDataset srcTileDataset = null;
        ITileDataset targetTileDataset = null;
        try {
            ExtractTileParam extractTileParam = (ExtractTileParam)executeParam;
            int beginLevel = extractTileParam.getFromLevel();
            int endLevel = extractTileParam.getToLevel();
            srcTileDataset = this.openSourceTileDataset(inputDataParam);
            TileMeta tileMeta = srcTileDataset.getTileMeta();
            MapExtent mapExtent = extractTileParam.getExtractExtent();
            IGeometry filterGeometry = null;
            MapExtent filterExtent = null;
            if (!StringUtil.isEmptyOrWhiteSpace((String)extractTileParam.getExtractGeometry())) {
                filterGeometry = GeometryFunc.createGeometry((String)extractTileParam.getExtractGeometry());
                IEnvelope envelope = filterGeometry.getEnvelope();
                filterExtent = new MapExtent(Double.valueOf(envelope.getXMin()), Double.valueOf(envelope.getYMin()), Double.valueOf(envelope.getXMax()), Double.valueOf(envelope.getYMax()));
            }
            if ((targetTileDataset = this.getTargetTileDataset(inputDataParam, extractTileParam)) == null) {
                throw new RuntimeException("\u76ee\u6807\u74e6\u7247\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25");
            }
            TileSchema tileSchema = srcTileDataset.getTileMeta().getTileSchema();
            targetTileDataset.startWrite();
            int count = 0;
            for (int level = beginLevel; level <= endLevel; ++level) {
                if (level > tileMeta.getEndLevel() || level < tileMeta.getStartLevel()) {
                    throw new RuntimeException("\u8d85\u51fa\u5c42\u7ea7\u8303\u56f4");
                }
                TileRange tileRange = TileTransform.worldToTile((MapExtent)mapExtent, (int)level, (TileSchema)tileSchema);
                for (int i = tileRange.getFirstRow(); i < tileRange.getFirstRow() + tileRange.getRowCount(); ++i) {
                    for (int j = tileRange.getFirstCol(); j < tileRange.getFirstCol() + tileRange.getColCount(); ++j) {
                        if (super.isAborted()) {
                            throw new RuntimeException("\u4efb\u52a1\u5df2\u88ab\u4e2d\u6b62");
                        }
                        MapExtent oneExtent = TileTransform.tileToWorld((TileRange)new TileRange(j, i), (int)level, (TileSchema)tileSchema);
                        if (filterExtent != null && !this.intersect(filterExtent, oneExtent) || filterGeometry != null && !this.intersect(filterGeometry, oneExtent)) continue;
                        TileData tileData = srcTileDataset.getDataSource() instanceof VectorTileDataSource ? (Boolean.TRUE.equals(extractTileParam.getHasMap()) && !Boolean.TRUE.equals(extractTileParam.getHasLabel()) ? ((VectorTileDataSource)srcTileDataset.getDataSource()).getTile(srcTileDataset.getName(), level, i, j, extractTileParam.getStyleId(), "mapImg", null) : (!Boolean.TRUE.equals(extractTileParam.getHasMap()) && Boolean.TRUE.equals(extractTileParam.getHasLabel()) ? ((VectorTileDataSource)srcTileDataset.getDataSource()).getTile(srcTileDataset.getName(), level, i, j, extractTileParam.getStyleId(), "labelImg", null) : ((VectorTileDataSource)srcTileDataset.getDataSource()).getTile(srcTileDataset.getName(), level, i, j, extractTileParam.getStyleId(), "all", null))) : srcTileDataset.getTile(level, i, j);
                        if (tileData == null) continue;
                        targetTileDataset.writeTile(tileData, true);
                        ++count;
                    }
                }
            }
            targetTileDataset.commitWrite(true);
            this.invokeExcuteLog(String.format("\u63d0\u53d6\u74e6\u7247%d\u5f20", count));
        }
        catch (Exception e) {
            if (targetTileDataset != null) {
                targetTileDataset.commitWrite(true);
            }
            this.invokeExcuteLog(String.format("[%s]\u74e6\u7247\u63d0\u53d6\u5931\u8d25\uff1a" + e.getMessage(), inputDataParam.getName()), e);
            executeResult.setSuccess(Boolean.valueOf(false));
        }
        finally {
            if (srcTileDataset != null) {
                srcTileDataset.getDataSource().close();
            }
            if (targetTileDataset != null) {
                targetTileDataset.getDataSource().close();
            }
        }
        return executeResult;
    }

    private ITileDataset openSourceTileDataset(DataParam inputDataParam) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(inputDataParam.getDsKey(), inputDataParam.getName());
        if (datasetDTO instanceof ServiceDatasetDTO) {
            ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
            if (serviceDatasetDTO.getServiceType().intValue() == ServiceType.VectorTileService.getValue()) {
                VectorTileDataSource vectorTileDataSource;
                String serverUrl = serviceDatasetDTO.getDataSource().getUrl();
                if (serviceDatasetDTO.getDataSource().getDataSourceType().intValue() == DataSourceTypeEnum.AtlasServer.getValue()) {
                    AtlasServer atlasServer = new AtlasServer(serverUrl, serviceDatasetDTO.getDataSource().getUserName(), serviceDatasetDTO.getDataSource().getPassword());
                    if (atlasServer.getVTileServer() == null || !atlasServer.getVTileServer().testConnect()) {
                        throw new RuntimeException("\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u8fde\u63a5\u5931\u8d25");
                    }
                    serverUrl = atlasServer.getVTileServer().getUrl();
                }
                if (!(vectorTileDataSource = new VectorTileDataSource(serverUrl)).connect()) {
                    throw new RuntimeException(datasetDTO.getDataSource().getUrl() + "\u8fde\u63a5\u5931\u8d25");
                }
                ITileDataset tileDataset = vectorTileDataSource.getDataset(datasetDTO.getName());
                if (tileDataset == null) {
                    throw new RuntimeException("\u672a\u8bfb\u53d6\u5230\u670d\u52a1\u56fe\u5c42");
                }
                return tileDataset;
            }
            if (serviceDatasetDTO.getServiceType().intValue() == ServiceType.RasterTileService.getValue()) {
                WMTSTileDataSource wmtsTileDataSource = new WMTSTileDataSource(serviceDatasetDTO.getServiceUrl());
                if (!wmtsTileDataSource.connect()) {
                    throw new RuntimeException(datasetDTO.getDataSource().getUrl() + "\u8fde\u63a5\u5931\u8d25");
                }
                ITileDataset tileDataset = wmtsTileDataSource.getDataset(datasetDTO.getName());
                if (tileDataset == null) {
                    throw new RuntimeException("\u672a\u8bfb\u53d6\u5230\u670d\u52a1\u56fe\u5c42");
                }
                return tileDataset;
            }
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6b64\u6570\u636e\u7c7b\u578b");
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6b64\u6570\u636e\u7c7b\u578b");
    }

    private ITileDataset getTargetTileDataset(DataParam inputDataParam, ExtractTileParam params) {
        GuoBiaoTileDataSource tileDataSource;
        TileStorageInfo tileStorageInfo = params.getStorageInfo();
        String datasetName = inputDataParam.getName();
        File targetFile = new File(tileStorageInfo.getStoragePath(), inputDataParam.getName());
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case LocalGuobiaoExploded: {
                tileDataSource = new GuoBiaoTileDataSource(targetFile.getAbsolutePath());
                break;
            }
            case LocalArcGISExploded: {
                tileDataSource = new ArcGISTileDataSource(targetFile.getAbsolutePath());
                break;
            }
            case LocalCompact: {
                tileDataSource = new ArcGISTileDataSource(targetFile.getAbsolutePath());
                break;
            }
            case MBTiles: {
                targetFile = new File(tileStorageInfo.getStoragePath(), datasetName + ".mbtiles");
                tileDataSource = new MBTilesTileDataSource(targetFile.getAbsolutePath());
                break;
            }
            case MongoDB: {
                DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                tileDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                datasetName = tileStorageInfo.getDatasetName();
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u74e6\u7247\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)tileStorageInfo.getStorageTypeEnum()));
            }
        }
        if (!tileDataSource.connect()) {
            throw new RuntimeException("\u76ee\u6807\u74e6\u7247\u6570\u636e\u6e90\u6253\u5f00\u5931\u8d25");
        }
        return tileDataSource.getDataset(datasetName);
    }

    private ITileDataset createTargetTileDataset(ExtractTileParam params, TileMeta srcTileMetadata) {
        TileMeta targetTileMeta = srcTileMetadata.clone();
        GuoBiaoTileDataSource tileDataSource = null;
        TileStorageInfo tileStorageInfo = params.getStorageInfo();
        String datasetName = srcTileMetadata.getName();
        File targetFile = new File(tileStorageInfo.getStoragePath(), datasetName);
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case LocalGuobiaoExploded: {
                if (!targetFile.exists()) {
                    targetFile.mkdirs();
                }
                tileDataSource = new GuoBiaoTileDataSource(targetFile.getAbsolutePath());
                return tileDataSource.createDataset(srcTileMetadata);
            }
            case LocalArcGISExploded: {
                if (!targetFile.exists()) {
                    targetFile.mkdirs();
                }
                tileDataSource = new ArcGISTileDataSource(targetFile.getAbsolutePath());
                ArcGISTileMeta meta = new ArcGISTileMeta();
                meta.copyFrom(srcTileMetadata);
                meta.setStorageFormat(ArcGISTileStorageFormat.Exploded);
                targetTileMeta = meta;
                break;
            }
            case LocalCompact: {
                if (!targetFile.exists()) {
                    targetFile.mkdirs();
                }
                tileDataSource = new ArcGISTileDataSource(targetFile.getAbsolutePath());
                ArcGISTileMeta metaV2 = new ArcGISTileMeta();
                metaV2.copyFrom(srcTileMetadata);
                metaV2.setStorageFormat(ArcGISTileStorageFormat.Compact);
                targetTileMeta = metaV2;
                break;
            }
            case MBTiles: {
                targetFile = new File(tileStorageInfo.getStoragePath(), datasetName + ".mbtiles");
                if (!targetFile.exists()) {
                    // empty if block
                }
                tileDataSource = new MBTilesTileDataSource(targetFile.getAbsolutePath());
                break;
            }
            case MongoDB: {
                DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                tileDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                datasetName = tileStorageInfo.getDatasetName();
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u74e6\u7247\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)tileStorageInfo.getStorageTypeEnum()));
            }
        }
        if (!tileDataSource.connect()) {
            throw new RuntimeException("\u76ee\u6807\u74e6\u7247\u6570\u636e\u6e90\u6253\u5f00\u5931\u8d25");
        }
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int l = params.getFromLevel().intValue(); l <= params.getToLevel(); ++l) {
            levels.add(l);
        }
        targetTileMeta.setLevels(levels);
        targetTileMeta.setStartLevel(params.getFromLevel());
        targetTileMeta.setEndLevel(params.getToLevel());
        MapExtent mapExtent = params.getExtractExtent();
        if (!StringUtil.isEmptyOrWhiteSpace((String)params.getExtractGeometry())) {
            IGeometry filterGeometry = GeometryFunc.createGeometry((String)params.getExtractGeometry());
            IEnvelope envelope = filterGeometry.getEnvelope();
            mapExtent = new MapExtent(Double.valueOf(envelope.getXMin()), Double.valueOf(envelope.getYMin()), Double.valueOf(envelope.getXMax()), Double.valueOf(envelope.getYMax()));
        }
        targetTileMeta.setXmin(Double.valueOf(mapExtent.getMinX().doubleValue()));
        targetTileMeta.setYmin(Double.valueOf(mapExtent.getMinY().doubleValue()));
        targetTileMeta.setXmax(Double.valueOf(mapExtent.getMaxX().doubleValue()));
        targetTileMeta.setYmax(Double.valueOf(mapExtent.getMaxY().doubleValue()));
        ITileDataset tileDataset = tileDataSource.getDataset(datasetName);
        if (tileDataset == null) {
            targetTileMeta.setName(datasetName);
            targetTileMeta.setAliasName(datasetName);
            tileDataset = tileDataSource.createDataset(targetTileMeta);
        } else {
            TileMeta tileMeta = tileDataset.getTileMeta();
            if (tileMeta == null) {
                tileDataset.updateTileMeta(targetTileMeta);
            } else {
                tileDataset.getTileMeta().setXmin(Double.valueOf(Math.min(targetTileMeta.getXmin(), tileMeta.getXmin())));
                tileDataset.getTileMeta().setYmin(Double.valueOf(Math.min(targetTileMeta.getYmin(), tileMeta.getYmin())));
                tileDataset.getTileMeta().setXmax(Double.valueOf(Math.max(targetTileMeta.getXmax(), tileMeta.getXmax())));
                tileDataset.getTileMeta().setYmax(Double.valueOf(Math.max(targetTileMeta.getYmax(), tileMeta.getYmax())));
                if (tileMeta.getLevels() == null) {
                    tileMeta.setLevels(targetTileMeta.getLevels());
                }
                for (Integer level : tileMeta.getLevels()) {
                    if (tileMeta.getLevels().contains(level)) continue;
                    tileMeta.getLevels().add(level);
                }
                targetTileMeta.getLevels().sort(Integer::compareTo);
                targetTileMeta.setStartLevel((Integer)targetTileMeta.getLevels().get(0));
                targetTileMeta.setEndLevel((Integer)targetTileMeta.getLevels().get(targetTileMeta.getLevels().size() - 1));
                tileDataset.updateTileMeta(tileMeta);
            }
        }
        return tileDataset;
    }

    private boolean intersect(MapExtent extent1, MapExtent extent2) {
        return !(extent1.getMinX().doubleValue() >= extent2.getMaxX().doubleValue() || extent2.getMinX().doubleValue() >= extent1.getMaxX().doubleValue() || extent1.getMinY().doubleValue() >= extent2.getMaxY().doubleValue()) && !(extent2.getMinY().doubleValue() >= extent1.getMaxY().doubleValue());
    }

    private boolean intersect(IGeometry filterGeometry, MapExtent tileExtent) {
        return GeometryFunc.createEnvelope((double)tileExtent.getMinX().doubleValue(), (double)tileExtent.getMinY().doubleValue(), (double)tileExtent.getMaxX().doubleValue(), (double)tileExtent.getMaxY().doubleValue()).intersects(filterGeometry);
    }
}

