/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.generator;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.dgt.tile.terrain.generator.BaseTerrainTileGenerator;
import com.geoway.dgt.tile.terrain.generator.ITerrainTileSample;
import com.geoway.dgt.tile.terrain.generator.TileTileSampleFactory;
import com.geoway.dgt.tile.terrain.param.TerrainRasterInfo;
import com.geoway.dgt.tile.util.GDALSpatialOperator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gdal.gdal.Dataset;

public class GDALTerrainTileGenerator
extends BaseTerrainTileGenerator {
    private org.gdal.osr.SpatialReference tileSpatialRef = null;
    private List<TerrainRasterInfo> terrainRasterInfos = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTile(int level, MapExtent updateExtent, Consumer<String> msgCallback, Supplier<Boolean> abortedCallback) {
        this.abortedCallback = abortedCallback;
        this.terrainRasterInfos = new ArrayList<TerrainRasterInfo>();
        this.tileSpatialRef = new org.gdal.osr.SpatialReference(this.tileSchema.getSpatialReference().getWkt());
        List<String> imagePaths = this.tileParameter.getRasterList();
        msgCallback.accept(String.format("\u8fc7\u6ee4\u524d\u603b\u5171\u6709%d\u5f20\u5f71\u50cf", imagePaths.size()));
        this.log.debug(String.format("\u8fc7\u6ee4\u524d\u603b\u5171\u6709%d\u5f20\u5f71\u50cf", imagePaths.size()));
        for (String imagePath : imagePaths) {
            RasterFileWorkspace workspace = new RasterFileWorkspace(imagePath);
            IRasterDataset rasterDataset = workspace.openRasterDataset(imagePath);
            IEnvelope envelope = rasterDataset.getRasterInfo().getExtent();
            MapExtent dataExtent = new MapExtent();
            dataExtent.setMinX(BigDecimal.valueOf(envelope.getXMin()));
            dataExtent.setMaxX(BigDecimal.valueOf(envelope.getXMax()));
            dataExtent.setMinY(BigDecimal.valueOf(envelope.getYMin()));
            dataExtent.setMaxY(BigDecimal.valueOf(envelope.getYMax()));
            SpatialReference sourceSp = new SpatialReference();
            sourceSp.setWkt(rasterDataset.getRasterInfo().getSpatialReferenceSystem().getWkt());
            MapExtent dataExtentProject = GDALSpatialOperator.project(dataExtent, sourceSp, this.tileSchema.getSpatialReference());
            if (!this.isIntersect(dataExtentProject, updateExtent)) continue;
            TerrainRasterInfo terrainRasterInfo = new TerrainRasterInfo();
            terrainRasterInfo.setExtent(dataExtent);
            terrainRasterInfo.setExtentInTileSpatialReference(dataExtentProject);
            org.gdal.osr.SpatialReference dataSpatialReference = new org.gdal.osr.SpatialReference(rasterDataset.getRasterInfo().getSpatialReferenceSystem().getWkt());
            terrainRasterInfo.setSameSpatialReference(!this.isNeedProject(dataSpatialReference, this.tileSpatialRef));
            terrainRasterInfo.setRasterDataset(rasterDataset);
            this.terrainRasterInfos.add(terrainRasterInfo);
        }
        try {
            boolean bl = super.updateTile(level, updateExtent, msgCallback, abortedCallback);
            return bl;
        }
        finally {
            for (TerrainRasterInfo terrainRasterInfo : this.terrainRasterInfos) {
                terrainRasterInfo.getRasterDataset().closeRaster();
            }
        }
    }

    @Override
    protected List<Float> getValues(MapExtent extent, int samplesPerTile, int level, int startCol, int startRow) {
        double[][] result = null;
        for (TerrainRasterInfo terrainRasterInfo : this.terrainRasterInfos) {
            if (!this.isIntersect(extent, terrainRasterInfo.getExtentInTileSpatialReference())) continue;
            ITerrainTileSample tileSampleModel = TileTileSampleFactory.createTerrainTileSampleModel(terrainRasterInfo, extent, samplesPerTile, this.tileSchema.getSpatialReference(), this.msgCallBack);
            tileSampleModel.setTileSpatialReferenceSystem(this.tileSchema.getSpatialReference());
            tileSampleModel.setLstDemValueMatch(this.lstDemValueMatch);
            tileSampleModel.setInvalidData(this.invalidData);
            tileSampleModel.setDemMinValue(this.demMinValue.floatValue());
            tileSampleModel.setDemMaxValue(this.demMaxValue.floatValue());
            double[][] tempResult = tileSampleModel.getValues(terrainRasterInfo, extent, this.tileSchema.getSpatialReference(), samplesPerTile, level, startCol, startRow, this.msgCallBack);
            if (this.hasNodataValue(result = result == null ? tempResult : this.merge(result, tempResult))) continue;
            return this.toList(result);
        }
        if (result != null) {
            return this.toList(result);
        }
        return this.toList(this.createTransparentValues(samplesPerTile));
    }

    private boolean isNeedProject(org.gdal.osr.SpatialReference spatialReferenceSystem1, org.gdal.osr.SpatialReference spatialReferenceSystem2) {
        return spatialReferenceSystem1.IsProjected() != 0 || spatialReferenceSystem2.IsProjected() != 0;
    }

    private ExtentDTO getRasterEnvelope(Dataset ds) {
        ExtentDTO mapExtent = new ExtentDTO();
        int xSize = ds.getRasterXSize();
        int ySize = ds.getRasterYSize();
        double[] gt = new double[6];
        ds.GetGeoTransform(gt);
        double xMin = gt[0] + 0.0 * gt[1] + 0.0 * gt[2];
        double yMin = gt[3] + 0.0 * gt[4] + (double)ySize * gt[5];
        double xMax = gt[0] + (double)xSize * gt[1] + 0.0 * gt[2];
        double yMax = gt[3] + 0.0 * gt[4] + 0.0 * gt[5];
        mapExtent.setXmin(Double.valueOf(xMin));
        mapExtent.setXmax(Double.valueOf(xMax));
        mapExtent.setYmin(Double.valueOf(yMin));
        mapExtent.setYmax(Double.valueOf(yMax));
        return mapExtent;
    }

    private double[][] createTransparentValues(int samplesPerTile) {
        double[][] result = new double[samplesPerTile][samplesPerTile];
        for (int i = 0; i < samplesPerTile; ++i) {
            for (int j = 0; j < samplesPerTile; ++j) {
                result[i][j] = this.invalidData;
            }
        }
        return result;
    }

    private double[][] merge(double[][] values1, double[][] values2) {
        double[][] result = new double[values1.length][values1[0].length];
        for (int i = 0; i < values1.length; ++i) {
            for (int j = 0; j < values1[0].length; ++j) {
                result[i][j] = values1[i][j] != this.invalidData ? values1[i][j] : values2[i][j];
            }
        }
        return result;
    }

    private List<Float> toList(double[][] values) {
        ArrayList<Float> valueList = new ArrayList<Float>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                valueList.add(Float.valueOf((float)values[i][j]));
            }
        }
        return valueList;
    }

    private boolean hasNodataValue(double[][] values) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                if (values[i][j] != this.invalidData) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIntersect(MapExtent sourceExtent, MapExtent anotherExtent) {
        double zx = Math.abs(sourceExtent.getMinX().add(sourceExtent.getMaxX()).subtract(anotherExtent.getMinX()).subtract(anotherExtent.getMaxX()).doubleValue());
        double x = Math.abs(sourceExtent.getMaxX().subtract(sourceExtent.getMinX()).doubleValue()) + Math.abs(anotherExtent.getMaxX().subtract(anotherExtent.getMinX()).doubleValue());
        double zy = Math.abs(sourceExtent.getMinY().add(sourceExtent.getMaxY()).subtract(anotherExtent.getMinY()).subtract(anotherExtent.getMaxY()).doubleValue());
        double y = Math.abs(sourceExtent.getMaxY().subtract(sourceExtent.getMinY()).doubleValue()) + Math.abs(anotherExtent.getMaxY().subtract(anotherExtent.getMinY()).doubleValue());
        return zx <= x && zy <= y;
    }
}

