/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.generator;

import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.dgt.tile.terrain.generator.ITerrainTileSample;
import com.geoway.dgt.tile.terrain.generator.TerrainTileSampleOneByBatch;
import com.geoway.dgt.tile.terrain.generator.TerrainTileSampleOneByOne;
import com.geoway.dgt.tile.terrain.param.TerrainRasterInfo;
import com.geoway.dgt.tile.util.GDALSpatialOperator;
import java.util.function.Consumer;

public class TileTileSampleFactory {
    public static ITerrainTileSample createTerrainTileSampleModel(TerrainRasterInfo terrainRasterInfo, MapExtent extent, int samplesPerTile, SpatialReference tileSpatialRef, Consumer<String> msgCallback) {
        int size;
        MapExtent copyExtent = new MapExtent();
        copyExtent.setMinX(extent.getMinX());
        copyExtent.setMaxX(extent.getMaxX());
        copyExtent.setMinY(extent.getMinY());
        copyExtent.setMaxY(extent.getMaxY());
        if (!terrainRasterInfo.getSameSpatialReference().booleanValue()) {
            SpatialReference dataSpatialReference = new SpatialReference();
            dataSpatialReference.setWkt(terrainRasterInfo.getRasterDataset().getRasterInfo().getSpatialReferenceSystem().getWkt());
            copyExtent = GDALSpatialOperator.project(extent, tileSpatialRef, dataSpatialReference);
        }
        if ((size = (int)(copyExtent.getMaxY().subtract(copyExtent.getMinY()).doubleValue() / Math.abs(terrainRasterInfo.getRasterDataset().getRasterInfo().getYResolution()))) > 5000) {
            return new TerrainTileSampleOneByOne();
        }
        return new TerrainTileSampleOneByBatch();
    }
}

