/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.param;

import java.util.ArrayList;
import java.util.List;

public class Mat {
    private List<Float> values;
    private double[][] data;
    private int rows;
    private int cols;

    public Mat(List<Float> values) {
        this.values = values;
        this.rows = (int)Math.sqrt(values.size());
        this.cols = (int)Math.sqrt(values.size());
        this.data = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                int index = this.rows * i + j;
                this.data[i][j] = values.get(index).floatValue();
            }
        }
    }

    public Mat(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.data = new double[rows][cols];
    }

    public Mat(Mat mat, int startRow, int startCol, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.data = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = mat.getValue(startRow + i, startCol + j);
            }
        }
    }

    public double getValue(int row, int col) {
        return this.data[row][col];
    }

    public void setValue(int row, int col, double value) {
        this.data[row][col] = value;
    }

    public List<Float> getValues() {
        if (this.data != null) {
            this.values = new ArrayList<Float>();
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    int index = this.rows * i + j;
                    this.values.add(Float.valueOf((float)this.data[i][j]));
                }
            }
        }
        return this.values;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }
}

