/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.image.generator;

import cn.hutool.core.thread.NamedThreadFactory;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.TileTransform;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.dgt.tile.constant.SliceSchemeEnum;
import com.geoway.dgt.tile.constant.TileFormatEnum;
import com.geoway.dgt.tile.dto.TileStorageInfo;
import com.geoway.dgt.tile.image.ImageSliceParam;
import com.geoway.dgt.tile.image.param.ImageInfo;
import com.geoway.dgt.tile.util.ImageUtil;
import com.geoway.dgt.tile.util.TileTaskHelper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseImageTileGenerator {
    protected Consumer<String> msgCallBack = null;
    protected Supplier<Boolean> abortedCallback = null;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean finish = false;
    private boolean hasException = false;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileCount = 8;
    protected ImageSliceParam tileParameter;
    protected TileSchema tileSchema = null;
    protected String maskWkt = "";
    protected ITileDataset tileReader = null;
    protected ITileDataset tileWriter = null;

    public void setTileParameter(ImageSliceParam param) {
        this.tileSchema = TileSchema.Tianditu;
        SliceSchemeEnum sliceSchemeEnum = SliceSchemeEnum.getByValue(param.getSliceScheme());
        if (sliceSchemeEnum != null) {
            switch (sliceSchemeEnum) {
                case GuoBiao: {
                    this.tileSchema = TileSchema.Tianditu;
                    break;
                }
                case ArcGIS: {
                    this.tileSchema = TileSchema.ArcGIS;
                    break;
                }
                case WebMercator: {
                    this.tileSchema = TileSchema.WebMercator;
                    break;
                }
            }
        }
        this.tileParameter = param;
        int firstLevel = ((LODInfo)this.tileSchema.getLodInfos().get(0)).getLevelID();
        this.tileWidth = 256;
        this.tileHeight = 256;
        if (!StringUtil.isEmptyOrWhiteSpace((String)this.tileParameter.getMaskFilePath())) {
            this.maskWkt = WorkspaceUtil.readLocalFileGeometry((String)this.tileParameter.getMaskFilePath()).toWkt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTile(int level, MapExtent mapExtent, Consumer<String> msgCallback, Supplier<Boolean> abortedCallback) {
        this.abortedCallback = abortedCallback;
        this.msgCallBack = msgCallback;
        TileStorageInfo tileStorageInfo = this.tileParameter.getStorageInfo();
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        MongoTileDataSource readerDataSource = null;
        MongoTileDataSource writeDataSource = null;
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case MongoDB: {
                DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                readerDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                readerDataSource.connect();
                this.tileReader = readerDataSource.getDataset(tileStorageInfo.getDatasetName());
                writeDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                writeDataSource.connect();
                this.tileWriter = readerDataSource.getDataset(tileStorageInfo.getDatasetName());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u683c\u5f0f\uff01");
            }
        }
        try {
            this.msgCallBack.accept(String.format("\u5b50\u4efb\u52a1\u8303\u56f4\uff1a%s", this.getMapExtentWkt(mapExtent)));
            boolean dataSourceDTO = this.handleTile(level, mapExtent);
            return dataSourceDTO;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            msgCallback.accept(e.getMessage());
        }
        finally {
            readerDataSource.close();
            writeDataSource.close();
        }
        return false;
    }

    private boolean handleTile(final int level, MapExtent updateExtent) {
        block6: {
            RefObject refTileRange = new RefObject();
            if (!this.isNeedHandleTile(level, updateExtent, (RefObject<TileRange>)refTileRange)) {
                return true;
            }
            TileRange tileRange = (TileRange)refTileRange.get();
            final int startRow = tileRange.getFirstRow();
            final int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
            final int startCol = tileRange.getFirstCol();
            final int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
            final ArrayBlockingQueue imageInfos = new ArrayBlockingQueue(20);
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 1, 5000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("image-tile-pool", false), new ThreadPoolExecutor.AbortPolicy());
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        block5: for (int row = startRow; row <= endRow; row += BaseImageTileGenerator.this.tileCount) {
                            if (BaseImageTileGenerator.this.abortedCallback.get().booleanValue()) {
                                break;
                            }
                            RefObject refYMin = new RefObject();
                            RefObject refYMax = new RefObject();
                            RefObject refRowTileCount = new RefObject();
                            BaseImageTileGenerator.this.getSuperTileRowInfo(row, endRow, level, (RefObject<Double>)refYMin, (RefObject<Double>)refYMax, (RefObject<Integer>)refRowTileCount);
                            int rowTileCount = (Integer)refRowTileCount.get();
                            double ymin = (Double)refYMin.get();
                            double ymax = (Double)refYMax.get();
                            if (rowTileCount <= 0) {
                                BaseImageTileGenerator.this.msgCallBack.accept("\u884c\u957f\u4e3a0\uff01");
                                continue;
                            }
                            for (int col = startCol; col <= endCol && !BaseImageTileGenerator.this.abortedCallback.get().booleanValue(); col += BaseImageTileGenerator.this.tileCount) {
                                RefObject refXMin = new RefObject();
                                RefObject refXMax = new RefObject();
                                RefObject refColTileCount = new RefObject();
                                BaseImageTileGenerator.this.getSuperTileColInfo(col, endCol, level, (RefObject<Double>)refXMin, (RefObject<Double>)refXMax, (RefObject<Integer>)refColTileCount);
                                int colTileCount = (Integer)refColTileCount.get();
                                double xmin = (Double)refXMin.get();
                                double xmax = (Double)refXMax.get();
                                if (colTileCount <= 0) {
                                    BaseImageTileGenerator.this.msgCallBack.accept("\u5217\u5bbd\u4e3a0\uff01");
                                    continue;
                                }
                                MapExtent extent = new MapExtent();
                                extent.setMinX(BigDecimal.valueOf(xmin));
                                extent.setMaxX(BigDecimal.valueOf(xmax));
                                extent.setMinY(BigDecimal.valueOf(ymin));
                                extent.setMaxY(BigDecimal.valueOf(ymax));
                                if (BaseImageTileGenerator.this.abortedCallback.get().booleanValue()) continue block5;
                                Image multiImage = BaseImageTileGenerator.this.createMultiTileImage(extent, colTileCount, rowTileCount, level);
                                if (multiImage == null) {
                                    BaseImageTileGenerator.this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u7b2c%d-%d\u884c%d-%d\u5217\u751f\u6210\u56fe\u7247\u4e3a\u7a7a\u3002", level, row, row + rowTileCount - 1, col, col + colTileCount - 1));
                                    continue;
                                }
                                if (BaseImageTileGenerator.this.abortedCallback.get().booleanValue()) continue block5;
                                imageInfos.put(new ImageInfo(multiImage, row, col));
                            }
                        }
                    }
                    catch (Exception e) {
                        BaseImageTileGenerator.this.hasException = true;
                        BaseImageTileGenerator.this.msgCallBack.accept(e.getMessage());
                        BaseImageTileGenerator.this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        BaseImageTileGenerator.this.finish = true;
                    }
                }
            });
            do {
                try {
                    if (imageInfos.size() > 0) {
                        ImageInfo multiImage = (ImageInfo)imageInfos.take();
                        this.exportImages(multiImage.getImage(), level, multiImage.getRow(), multiImage.getCol());
                    }
                }
                catch (Exception e) {
                    this.log.error("\u5199\u74e6\u7247\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    this.hasException = true;
                    this.msgCallBack.accept("\u5199\u74e6\u7247\u5f02\u5e38\uff1a" + e.getMessage());
                }
                if (this.abortedCallback.get().booleanValue()) break block6;
            } while (imageInfos.size() != 0 || !this.finish);
            executorService.shutdown();
        }
        if (this.abortedCallback.get().booleanValue() || this.hasException) {
            return false;
        }
        this.msgCallBack.accept(String.format("\u7ed3\u675f\u521b\u5efa\u7b2c%d\u7ea7\u74e6\u7247\u7f13\u5b58", level));
        return true;
    }

    protected Image createMultiTileImage(MapExtent mapExt, int colCount, int rowCount, int level) {
        return null;
    }

    private void exportImages(Image multiImage, int level, int row, int col) {
        int width = this.tileWidth;
        int height = this.tileHeight;
        BufferedImage bufferedImage = (BufferedImage)multiImage;
        for (int i = 0; i < bufferedImage.getWidth() / width; ++i) {
            for (int j = 0; j < bufferedImage.getHeight() / height; ++j) {
                int transparentState;
                BufferedImage tileImage = new BufferedImage(width, height, 2);
                int x = width * i;
                int y = height * j;
                Graphics2D g2d = tileImage.createGraphics();
                g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
                g2d.drawImage(bufferedImage, 0, 0, width, height, x, y, x + width, y + height, null);
                int rowCode = j + row;
                int colCode = i + col;
                if (this.tileParameter.getTileFormatEnum() == TileFormatEnum.WEBP || (transparentState = ImageUtil.getTransparentState(tileImage)) == -1) continue;
                BufferedImage theImage = this.handleImage(tileImage, rowCode, colCode);
                String imageFormat = "png";
                BufferedImage resultImage = null;
                switch (this.tileParameter.getTileFormatEnum()) {
                    case PNG8: 
                    case PNG24: 
                    case PNG32: {
                        imageFormat = "png";
                        resultImage = theImage;
                        break;
                    }
                    case JPG: {
                        imageFormat = "jpg";
                        resultImage = ImageUtil.convertToJpg(theImage);
                        break;
                    }
                    case MIXED: {
                        if (ImageUtil.hasTransparentBounds(theImage)) {
                            imageFormat = "png";
                            resultImage = theImage;
                            break;
                        }
                        imageFormat = "jpg";
                        resultImage = ImageUtil.convertToJpg(theImage);
                        break;
                    }
                }
                if (resultImage == null) continue;
                TileData tileInfo = new TileData();
                tileInfo.setLevel(level);
                tileInfo.setRow(rowCode);
                tileInfo.setCol(colCode);
                tileInfo.setFormat(imageFormat);
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)resultImage, tileInfo.getFormat(), outputStream);
                    byte[] byteArray = outputStream.toByteArray();
                    tileInfo.setData(byteArray);
                    outputStream.close();
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    this.msgCallBack.accept(e.getMessage());
                    continue;
                }
                this.tileWriter.writeTile(tileInfo, true);
            }
        }
    }

    private BufferedImage handleImage(BufferedImage tileImage, int rowCode, int colCode) {
        if (this.tileReader == null) {
            return tileImage;
        }
        ColorModel colorModel = tileImage.getColorModel();
        if (!colorModel.hasAlpha()) {
            return tileImage;
        }
        BufferedImage sourceImage = null;
        try {
            TileData tileData = this.tileReader.getTile(this.tileCount, rowCode, colCode);
            if (tileData != null && tileData.getData() != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(tileData.getData());
                sourceImage = ImageIO.read(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (sourceImage != null) {
            BufferedImage combineImage = ImageUtil.combineImage2(tileImage, sourceImage);
            return combineImage == null ? tileImage : combineImage;
        }
        return tileImage;
    }

    protected boolean isNeedHandleTile(int level, MapExtent updateExtent, RefObject<TileRange> refTileRange) {
        int bundleStartRow;
        int bundleEndRow;
        int bundleStartCol;
        TileRange tileRange = TileTransform.worldToTile((MapExtent)updateExtent, (int)level, (TileSchema)this.tileSchema);
        refTileRange.set((Object)tileRange);
        boolean handledTileCount = false;
        int totalTileCount = 0;
        int startRow = tileRange.getFirstRow();
        int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
        int startCol = tileRange.getFirstCol();
        int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
        totalTileCount = tileRange.getRowCount() * tileRange.getColCount();
        String sourceWkt = this.maskWkt;
        if (StringUtil.isEmptyOrWhiteSpace((String)sourceWkt)) {
            sourceWkt = this.getMapExtentWkt(this.tileParameter.getSliceExtent());
        }
        MapExtent mapExtent = new MapExtent();
        mapExtent.setMinX(BigDecimal.valueOf(Math.max(this.tileParameter.getSliceExtent().getMinX().doubleValue(), updateExtent.getMinX().doubleValue())));
        mapExtent.setMaxX(BigDecimal.valueOf(Math.min(this.tileParameter.getSliceExtent().getMaxX().doubleValue(), updateExtent.getMaxX().doubleValue())));
        mapExtent.setMinY(BigDecimal.valueOf(Math.max(this.tileParameter.getSliceExtent().getMinY().doubleValue(), updateExtent.getMinY().doubleValue())));
        mapExtent.setMaxY(BigDecimal.valueOf(Math.min(this.tileParameter.getSliceExtent().getMaxY().doubleValue(), updateExtent.getMaxY().doubleValue())));
        String extentWkt = this.getMapExtentWkt(mapExtent);
        if (!this.isIntersect(sourceWkt, extentWkt)) {
            this.msgCallBack.accept(sourceWkt);
            this.msgCallBack.accept(extentWkt);
            this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u8303\u56f4\u4e0e\u591a\u8fb9\u5f62\u533a\u57df\u4e0d\u76f8\u4ea4\uff0c\u76f4\u63a5\u8df3\u8fc7\u3002", level));
            return false;
        }
        int tilePreCount = TileTaskHelper.getTilePreCount(tileRange);
        int bundleEndCol = endCol / tilePreCount;
        int count = (bundleEndCol - (bundleStartCol = startCol / tilePreCount) + 1) * ((bundleEndRow = endRow / tilePreCount) - (bundleStartRow = startRow / tilePreCount) + 1);
        if (count != 1) {
            this.msgCallBack.accept(String.format("\u5207\u7247\u8303\u56f4(%s)\u8de8\u8d8a\u591a\u4e2aBundle\u6587\u4ef6\u8303\u56f4\u3002", this.getMapExtentWkt(updateExtent)));
        }
        if (updateExtent.getMinX().equals(updateExtent.getMaxX())) {
            this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u5207\u7247\u4efb\u52a1\u3002", level));
            return false;
        }
        return true;
    }

    protected boolean isIntersect(String sourceShapeWkt, String anotherShapeWkt) {
        IGeometry sourceGeo = GeometryFunc.createGeometry((String)sourceShapeWkt);
        IGeometry anotherGeo = GeometryFunc.createGeometry((String)anotherShapeWkt);
        return sourceGeo.intersects(anotherGeo);
    }

    protected String getMapExtentWkt(MapExtent mapExtent) {
        return String.format("POLYGON((%s %s,%s %s,%s %s,%s %s,%s %s))", mapExtent.getMinX(), mapExtent.getMinY(), mapExtent.getMinX(), mapExtent.getMaxY(), mapExtent.getMaxX(), mapExtent.getMaxY(), mapExtent.getMaxX(), mapExtent.getMinY(), mapExtent.getMinX(), mapExtent.getMinY());
    }

    protected void getSuperTileColInfo(int col, int maxCol, int levelId, RefObject<Double> xmin, RefObject<Double> xmax, RefObject<Integer> colTileCount) {
        if (col + this.tileCount < maxCol + 1) {
            colTileCount.set((Object)this.tileCount);
        } else {
            colTileCount.set((Object)(maxCol - col + 1));
        }
        TileRange tileRange = new TileRange(col, 0, ((Integer)colTileCount.get()).intValue(), 1);
        MapExtent extent = TileTransform.tileToWorld((TileRange)tileRange, (int)levelId, (TileSchema)this.tileSchema);
        xmin.set((Object)extent.getMinX().doubleValue());
        xmax.set((Object)extent.getMaxX().doubleValue());
    }

    protected void getSuperTileRowInfo(int row, int maxRow, int levelId, RefObject<Double> ymin, RefObject<Double> ymax, RefObject<Integer> rowTileCount) {
        if (row + this.tileCount < maxRow + 1) {
            rowTileCount.set((Object)this.tileCount);
        } else {
            rowTileCount.set((Object)(maxRow - row + 1));
        }
        TileRange tileRange = new TileRange(0, row, 0, ((Integer)rowTileCount.get()).intValue());
        MapExtent extent = TileTransform.tileToWorld((TileRange)tileRange, (int)levelId, (TileSchema)this.tileSchema);
        ymin.set((Object)extent.getMinY().doubleValue());
        ymax.set((Object)extent.getMaxY().doubleValue());
    }
}

