/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.generator;

import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.dgt.tile.terrain.generator.ITerrainTileSample;
import com.geoway.dgt.tile.terrain.param.BlockPixelInfo;
import com.geoway.dgt.tile.terrain.param.DemValueMatch;
import com.geoway.dgt.tile.terrain.param.TerrainRasterInfo;
import com.geoway.dgt.tile.terrain.param.VertexCollection;
import com.geoway.dgt.tile.util.GDALSpatialOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class TerrainTileSampleBase
implements ITerrainTileSample {
    protected Double invalidData = -9999.0;
    protected com.geoway.adf.gis.tile.meta.SpatialReference tileSpatialReferenceSystem;
    protected List<DemValueMatch> listDemValueMatch = new ArrayList<DemValueMatch>();
    protected Double demMaxValue = 9999.0;
    protected Double demMinValue = -9999.0;
    protected Consumer<String> msgCallBack = null;

    @Override
    public double[][] getValues(TerrainRasterInfo terrainRasterInfo, MapExtent extent, com.geoway.adf.gis.tile.meta.SpatialReference tileSpatialRef, int samplesPerTile, int level, int startCol, int startRow, Consumer<String> msgCallback) {
        this.msgCallBack = msgCallback;
        return new double[0][];
    }

    @Override
    public void setInvalidData(double invalidData) {
        this.invalidData = invalidData;
    }

    @Override
    public void setTileSpatialReferenceSystem(com.geoway.adf.gis.tile.meta.SpatialReference tileSpatialReferenceSystem) {
        this.tileSpatialReferenceSystem = tileSpatialReferenceSystem;
    }

    @Override
    public void setLstDemValueMatch(List<DemValueMatch> listDemValueMatch) {
        this.listDemValueMatch = listDemValueMatch;
    }

    @Override
    public void setDemMaxValue(double demMaxValue) {
        this.demMaxValue = demMaxValue;
    }

    @Override
    public void setDemMinValue(double demMinValue) {
        this.demMinValue = demMinValue;
    }

    protected BlockPixelInfo getBlockPixelInfo(TerrainRasterInfo terrainRasterInfo, MapExtent extent, com.geoway.adf.gis.tile.meta.SpatialReference spatialReference, int level, int startCol, int startRow) {
        BlockPixelInfo blockPixelInfo = new BlockPixelInfo();
        if (!terrainRasterInfo.getSameSpatialReference().booleanValue()) {
            com.geoway.adf.gis.tile.meta.SpatialReference dataSpatialReference = new com.geoway.adf.gis.tile.meta.SpatialReference();
            dataSpatialReference.setWkt(terrainRasterInfo.getRasterDataset().getRasterInfo().getSpatialReferenceSystem().getWkt());
            extent = GDALSpatialOperator.project(extent, spatialReference, dataSpatialReference);
        }
        double xMin = extent.getMinX().doubleValue();
        double yMax = extent.getMaxY().doubleValue();
        int blockHeight = (int)(extent.getHeight().doubleValue() / Math.abs(terrainRasterInfo.getRasterDataset().getRasterInfo().getYResolution()));
        int blockWidth = (int)(extent.getWidth().doubleValue() / terrainRasterInfo.getRasterDataset().getRasterInfo().getXResolution());
        blockPixelInfo.setWidth(blockWidth);
        blockPixelInfo.setHeight(blockHeight);
        RefObject x = new RefObject();
        x.set((Object)0);
        RefObject y = new RefObject();
        y.set((Object)0);
        if (!this.geoToPixelPoint(terrainRasterInfo.getRasterDataset().getRaster().GetGeoTransform(), xMin, yMax, (RefObject<Integer>)x, (RefObject<Integer>)y).booleanValue()) {
            this.msgCallBack.accept(String.format("\u5c42\u7ea7%d\uff0c\u884c\u53f7\uff1a%d\uff0c\u5217\u53f7\uff1a%d\uff0c\u5728\u5f71\u50cf\u3010%s\u3011\u4e0a\uff0c\u6279\u91cf\u91c7\u6837\u65f6\u51fa\u9519", level, startRow, startCol, terrainRasterInfo.getRasterDataset().getFullName()));
            blockPixelInfo.setStartRow((Integer)x.get());
            blockPixelInfo.setStartCol((Integer)y.get());
            blockPixelInfo.setValues(this.createTransparentValues(blockWidth, blockHeight));
            return blockPixelInfo;
        }
        if ((Integer)x.get() >= terrainRasterInfo.getRasterDataset().getRasterInfo().getWidth() || (Integer)y.get() >= terrainRasterInfo.getRasterDataset().getRasterInfo().getHeight()) {
            this.msgCallBack.accept(String.format("\u5c42\u7ea7%d\uff0c\u884c\u53f7\uff1a%d\uff0c\u5217\u53f7\uff1a%d\uff0c\u5728\u5f71\u50cf\u3010%s\u3011\u4e0a\uff0c\u6279\u91cf\u91c7\u6837\u65f6\u8d8a\u754c\u4e86", level, startRow, startCol, terrainRasterInfo.getRasterDataset().getFullName()));
            blockPixelInfo.setStartRow((Integer)x.get());
            blockPixelInfo.setStartCol((Integer)y.get());
            blockPixelInfo.setValues(this.createTransparentValues(blockWidth, blockHeight));
            return blockPixelInfo;
        }
        blockPixelInfo.setStartRow((Integer)x.get());
        blockPixelInfo.setStartCol((Integer)y.get());
        int readBlockWidth = blockWidth;
        int readBlockHeight = blockHeight;
        int readX = (Integer)x.get();
        int readY = (Integer)y.get();
        int resultStartX = 0;
        int resultStartY = 0;
        if ((Integer)x.get() < 0) {
            readBlockWidth = blockWidth + (Integer)x.get();
            readX = 0;
            resultStartX = -((Integer)x.get()).intValue();
        } else if ((Integer)x.get() + readBlockWidth > terrainRasterInfo.getRasterDataset().getRasterInfo().getWidth()) {
            readBlockWidth = terrainRasterInfo.getRasterDataset().getRasterInfo().getWidth() - (Integer)x.get();
            readX = (Integer)x.get();
        }
        if ((Integer)y.get() < 0) {
            readBlockHeight = blockHeight + (Integer)y.get();
            resultStartY = -((Integer)y.get()).intValue();
            readY = 0;
        } else if ((Integer)y.get() + readBlockHeight > terrainRasterInfo.getRasterDataset().getRasterInfo().getHeight()) {
            readBlockHeight = terrainRasterInfo.getRasterDataset().getRasterInfo().getHeight() - (Integer)y.get();
            readY = (Integer)y.get();
        }
        Double[][] readResult = new Double[blockWidth][blockHeight];
        for (int i = 0; i < blockWidth; ++i) {
            for (int j = 0; j < blockHeight; ++j) {
                readResult[i][j] = this.invalidData;
            }
        }
        double[] dataBufDouble = new double[readBlockWidth * readBlockHeight];
        terrainRasterInfo.getRasterDataset().getRaster().GetRasterBand(1).ReadRaster(readX, readY, readBlockWidth, readBlockHeight, dataBufDouble);
        for (int i = 0; i < readBlockWidth; ++i) {
            for (int j = 0; j < readBlockHeight; ++j) {
                int index = j * readBlockWidth + i;
                double value = dataBufDouble[index];
                readResult[resultStartX + i][resultStartY + j] = value;
            }
        }
        blockPixelInfo.setValues(readResult);
        return blockPixelInfo;
    }

    protected VertexCollection createCollection(MapExtent mapExtent, int samplePerTile) {
        double[] x = new double[samplePerTile * samplePerTile];
        double[] y = new double[samplePerTile * samplePerTile];
        double[] z = new double[samplePerTile * samplePerTile];
        double scaleFactor = 1.0 / (double)(samplePerTile - 1);
        double widthPerPixel = scaleFactor * mapExtent.getWidth().doubleValue();
        double heightPerPixel = scaleFactor * mapExtent.getHeight().doubleValue();
        double currentX = mapExtent.getMinX().doubleValue();
        double currentY = mapExtent.getMaxY().doubleValue();
        for (int pixelcolumn = 0; pixelcolumn < samplePerTile; ++pixelcolumn) {
            currentX = mapExtent.getMinX().doubleValue();
            for (int pixelrow = 0; pixelrow < samplePerTile; ++pixelrow) {
                x[pixelcolumn * samplePerTile + pixelrow] = currentX;
                y[pixelcolumn * samplePerTile + pixelrow] = currentY;
                z[pixelcolumn * samplePerTile + pixelrow] = 0.0;
                currentX += widthPerPixel;
            }
            currentY -= heightPerPixel;
        }
        return new VertexCollection(x, y, z);
    }

    protected Boolean geoToPixelPoint(double[] geoTransform, double xCoord, double yCoord, RefObject<Integer> x, RefObject<Integer> y) {
        try {
            x.set((Object)((int)Math.floor((xCoord - geoTransform[0]) / geoTransform[1])));
            y.set((Object)((int)Math.floor((yCoord - geoTransform[3]) / geoTransform[5])));
            return true;
        }
        catch (Exception e) {
            this.msgCallBack.accept(e.getMessage());
            return false;
        }
    }

    protected boolean project(VertexCollection coords, com.geoway.adf.gis.tile.meta.SpatialReference sourceSpatialReference, com.geoway.adf.gis.tile.meta.SpatialReference targetSpatialReference) {
        try {
            SpatialReference sourceSp = new SpatialReference(sourceSpatialReference.getWkt());
            SpatialReference targetSp = new SpatialReference(targetSpatialReference.getWkt());
            if (sourceSp.equals((Object)targetSp) || sourceSp.IsGeographic() > 0 && targetSp.IsGeographic() > 0) {
                return true;
            }
            CoordinateTransformation coordinateTransformation = new CoordinateTransformation(sourceSp, targetSp);
            for (int i = 0; i < coords.x.length; ++i) {
                double[] point = coordinateTransformation.TransformPoint(coords.x[i], coords.y[i], coords.z[i]);
                coords.x[i] = point[0];
                coords.y[i] = point[1];
                coords.z[i] = point[2];
            }
            return true;
        }
        catch (Exception e) {
            this.msgCallBack.accept(e.getMessage());
            return false;
        }
    }

    protected double[][] handleSpecialValues(double[][] values, int samplesPerTile, TerrainRasterInfo terrainRasterInfo) {
        for (int i = 0; i < samplesPerTile; ++i) {
            for (int j = 0; j < samplesPerTile; ++j) {
                double value = values[i][j];
                if (value == terrainRasterInfo.getRasterDataset().getRasterInfo().getInvalidValue()[0] || Double.isNaN(value) || Double.isInfinite(value)) {
                    values[i][j] = this.invalidData;
                    continue;
                }
                if (this.listDemValueMatch != null) {
                    boolean flag = false;
                    for (DemValueMatch valueMatch : this.listDemValueMatch) {
                        if (!(value >= valueMatch.getStartValue()) || !(value <= valueMatch.getEndValue())) continue;
                        values[i][j] = valueMatch.getMatchValue();
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                if (!(value > this.demMaxValue) && !(value < this.demMinValue)) continue;
                values[i][j] = this.invalidData;
            }
        }
        return values;
    }

    private Double[][] createTransparentValues(int width, int height) {
        Double[][] result = new Double[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                result[i][j] = this.invalidData;
            }
        }
        return result;
    }

    protected short byte2short(byte[] bytes) {
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            s = (short)(s << 8);
            s = (short)(s | bytes[i] & 0xFF);
        }
        return s;
    }
}

