/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);

    public static BufferedImage convertToJpg(BufferedImage source) {
        try {
            BufferedImage image = new BufferedImage(source.getWidth(), source.getHeight(), 1);
            Graphics2D g2d = image.createGraphics();
            g2d.drawImage((Image)source, 0, 0, null);
            g2d.dispose();
            return image;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u56fe\u7247\u4e3ajpg\u683c\u5f0f\u5931\u8d25\uff01");
            return null;
        }
    }

    public static int getTransparentState(BufferedImage source) {
        boolean hasValid = false;
        boolean hasTransparent = false;
        try {
            for (int y = 0; y < source.getHeight(); ++y) {
                for (int x = 0; x < source.getWidth(); ++x) {
                    int updatePixel = ImageUtil.getPixel(source, x, y);
                    int alpha = updatePixel >> 24 & 0xFF;
                    if (alpha == 0) {
                        hasTransparent = true;
                    } else {
                        hasValid = true;
                    }
                    if (!hasTransparent || !hasValid) continue;
                    return 0;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u56fe\u7247\u900f\u660e\u72b6\u6001\u5931\u8d25\uff01", (Throwable)e);
        }
        if (hasValid) {
            return 1;
        }
        return -1;
    }

    public static boolean hasTransparentBounds(BufferedImage source) {
        try {
            for (int y = 0; y < source.getHeight(); ++y) {
                for (int x = 0; x < source.getWidth(); ++x) {
                    int updatePixel = ImageUtil.getPixel(source, x, y);
                    int alpha = updatePixel >> 24 & 0xFF;
                    if (alpha != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u56fe\u7247\u662f\u5426\u6709\u900f\u660e\u533a\u57df\u5931\u8d25\uff01", (Throwable)e);
        }
        return false;
    }

    public static BufferedImage combineImage2(BufferedImage updateImage, BufferedImage sourceImage) {
        if (updateImage.getHeight() != sourceImage.getHeight()) {
            throw new RuntimeException("\u56fe\u7247\u9ad8\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        if (updateImage.getWidth() != sourceImage.getWidth()) {
            throw new RuntimeException("\u56fe\u7247\u5bbd\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        try {
            int width = sourceImage.getWidth();
            int height = sourceImage.getHeight();
            BufferedImage mergedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int sourcePixel = ImageUtil.getPixel(sourceImage, x, y);
                    int updatePixel = ImageUtil.getPixel(updateImage, x, y);
                    int alpha = updatePixel >> 24 & 0xFF;
                    if (alpha == 0) {
                        mergedImage.setRGB(x, y, sourcePixel);
                        continue;
                    }
                    mergedImage.setRGB(x, y, updatePixel);
                }
            }
            return mergedImage;
        }
        catch (Exception e) {
            log.error("\u5408\u5e76\u56fe\u7247\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static int getPixel(BufferedImage image, int x, int y) {
        if (x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
            return image.getRGB(x, y);
        }
        return 0;
    }
}

