/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import com.geoway.dgt.tile.constant.TerrainTileVersionEnum;
import com.geoway.dgt.tile.constant.TransparentStateEnum;
import com.geoway.dgt.tile.terrain.param.Mat;
import com.geoway.dgt.tile.util.BitConverter;
import com.geoway.dgt.tile.util.CompressData;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TerrainTileUtil {
    private static final String COMPRESSMETHOD = "zlib";

    public static List<Float> getValues(TerrainTileVersionEnum version, byte[] data) {
        ArrayList<Float> values = new ArrayList<Float>();
        switch (version) {
            case V20: {
                byte[] zlib = TerrainTileUtil.getRange(data, 0, 4);
                String zlibMethod = new String(zlib, StandardCharsets.UTF_8);
                byte[] valueBytes = TerrainTileUtil.getRange(data, 16, data.length - 16);
                byte[] minBytes = TerrainTileUtil.getRange(data, 4, 4);
                byte[] paraBytes = TerrainTileUtil.getRange(data, 8, 8);
                float min = BitConverter.toSingle(minBytes);
                double para = BitConverter.toDouble(paraBytes);
                byte[] realValueBytes = CompressData.deCompressBytes(valueBytes);
                for (int i = 0; i < realValueBytes.length; i += 2) {
                    byte[] shortBytes = TerrainTileUtil.getRange(realValueBytes, i, 2);
                    short shortValue = BitConverter.toInt16(shortBytes);
                    float value = (float)((double)shortValue * para + (double)min);
                    values.add(Float.valueOf(value));
                }
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff01" + version.getDesc());
            }
        }
        return values;
    }

    public static byte[] convertToTileInfoBytes(TerrainTileVersionEnum version, List<Float> values) {
        switch (version) {
            case V20: {
                byte[] convertValues = null;
                byte[] convertCompressMethod = null;
                byte[] convertOPERATORPARA = null;
                byte[] convertMin = null;
                byte[] result = null;
                try {
                    int i;
                    if (values == null || values.size() == 0) {
                        return null;
                    }
                    float min = Collections.min(values).floatValue();
                    float max = Collections.max(values).floatValue();
                    double para = (max - min) / 32767.0f;
                    ArrayList<Short> shortValues = new ArrayList<Short>();
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        shortValues.add((short)((double)(values.get(i2).floatValue() - min) / para));
                    }
                    convertValues = CompressData.compressDataUsingDeflate(shortValues, (int)Math.sqrt(values.size()));
                    convertCompressMethod = COMPRESSMETHOD.getBytes(StandardCharsets.UTF_8);
                    convertOPERATORPARA = BitConverter.double2bytes(para);
                    convertMin = BitConverter.float2bytes(min);
                    result = new byte[convertCompressMethod.length + convertMin.length + convertOPERATORPARA.length + convertValues.length];
                    int nSeek = 0;
                    for (i = 0; i < convertCompressMethod.length; ++i) {
                        result[i + nSeek] = convertCompressMethod[i];
                    }
                    nSeek += convertCompressMethod.length;
                    for (i = 0; i < convertMin.length; ++i) {
                        result[i + nSeek] = convertMin[i];
                    }
                    nSeek += convertMin.length;
                    for (i = 0; i < convertOPERATORPARA.length; ++i) {
                        result[i + nSeek] = convertOPERATORPARA[i];
                    }
                    nSeek += convertOPERATORPARA.length;
                    for (i = 0; i < convertValues.length; ++i) {
                        result[i + nSeek] = convertValues[i];
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                return result;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff01" + version.getDesc());
    }

    public static TransparentStateEnum getTransparentState(List<Float> values, int nodataValue) {
        TransparentStateEnum state = TransparentStateEnum.Transparent;
        if (!values.contains(Float.valueOf(nodataValue))) {
            state = TransparentStateEnum.NotTransparent;
        } else {
            for (float value : values) {
                if ((double)nodataValue == (double)value) continue;
                state = TransparentStateEnum.Semitransparent;
                break;
            }
        }
        return state;
    }

    public static List<Float> combineTileInfo(List<Float> sourceValues, List<Float> undateValues, int sourceNodataValue, int undateNodataValue) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < undateValues.size(); ++i) {
            float undateValue = undateValues.get(i).floatValue();
            float sourceValue = sourceValues.get(i).floatValue();
            if ((double)(undateValue - (float)undateNodataValue) == 0.0) {
                if ((double)(sourceValue - (float)sourceNodataValue) == 0.0) {
                    result.add(Float.valueOf(undateNodataValue));
                    continue;
                }
                result.add(Float.valueOf(sourceValue));
                continue;
            }
            result.add(Float.valueOf(undateValue));
        }
        return result;
    }

    public static Mat combineTileInfo(Mat sourceMat, Mat updateMat, int sourceNodataValue) {
        for (int i = 0; i < sourceMat.getRows(); ++i) {
            for (int j = 0; j < sourceMat.getCols(); ++j) {
                double sourceValue = sourceMat.getValue(i, j);
                if (sourceValue != (double)sourceNodataValue) continue;
                sourceMat.setValue(i, j, updateMat.getValue(i, j));
            }
        }
        return sourceMat;
    }

    public static List<Mat> spiltOne2Four(Mat mat) {
        ArrayList<Mat> fourMats = new ArrayList<Mat>();
        Mat resizeMat = new Mat(mat.getRows() * 2 - 1, mat.getCols() * 2 - 1);
        TerrainTileUtil.bilinearInterpolation(mat, resizeMat);
        for (int i = 0; i < resizeMat.getRows(); ++i) {
            for (int j = 0; j < resizeMat.getCols(); ++j) {
                if (i == 0) {
                    if (j == 0) {
                        resizeMat.setValue(i, j, mat.getValue(0, 0));
                        continue;
                    }
                    if (j == resizeMat.getCols() - 1) {
                        resizeMat.setValue(i, j, mat.getValue(0, mat.getRows() - 1));
                        continue;
                    }
                    resizeMat.setValue(i, j, (mat.getValue(0, j / 2) + mat.getValue(0, j / 2 + 1)) / 2.0);
                    continue;
                }
                if (j == 0) {
                    if (i == resizeMat.getRows() - 1) {
                        resizeMat.setValue(i, j, mat.getValue(mat.getRows() - 1, 0));
                        continue;
                    }
                    resizeMat.setValue(i, j, (mat.getValue(i / 2, 0) + mat.getValue(i / 2 + 1, 0)) / 2.0);
                    continue;
                }
                if (i == resizeMat.getRows() - 1) {
                    if (j == resizeMat.getCols() - 1) {
                        resizeMat.setValue(i, j, mat.getValue(mat.getRows() - 1, mat.getCols() - 1));
                        continue;
                    }
                    resizeMat.setValue(i, j, (mat.getValue(mat.getRows() - 1, j / 2) + mat.getValue(mat.getRows() - 1, j / 2 + 1)) / 2.0);
                    continue;
                }
                if (j != resizeMat.getCols() - 1) continue;
                resizeMat.setValue(i, j, (mat.getValue(i / 2, mat.getCols() - 1) + mat.getValue(i / 2 + 1, mat.getCols() - 1)) / 2.0);
            }
        }
        Mat leftTop = new Mat(resizeMat, 0, 0, mat.getRows(), mat.getCols());
        Mat rightTop = new Mat(resizeMat, 0, mat.getCols() - 1, mat.getRows(), mat.getCols());
        Mat leftBottom = new Mat(resizeMat, mat.getCols() - 1, 0, mat.getRows(), mat.getCols());
        Mat rightBottom = new Mat(resizeMat, mat.getCols() - 1, mat.getCols() - 1, mat.getRows(), mat.getCols());
        fourMats.add(leftTop);
        fourMats.add(rightTop);
        fourMats.add(leftBottom);
        fourMats.add(rightBottom);
        return fourMats;
    }

    private static void bilinearInterpolation(Mat sourceMat, Mat targetMat) {
        int targetWidth = targetMat.getCols();
        int targetHeight = targetMat.getRows();
        for (int y = 0; y < targetHeight; ++y) {
            for (int x = 0; x < targetWidth; ++x) {
                double ySrcReal = ((double)y + 0.5) * ((double)sourceMat.getRows() / (double)targetHeight) - 0.5;
                double xSrcReal = ((double)x + 0.5) * ((double)sourceMat.getCols() / (double)targetWidth) - 0.5;
                int ySrcInt = (int)ySrcReal;
                int xSrcInt = (int)xSrcReal;
                double xt = xSrcReal - (double)xSrcInt;
                double yt = ySrcReal - (double)ySrcInt;
                double q12 = sourceMat.getValue(ySrcInt, xSrcInt);
                double q22 = sourceMat.getValue(ySrcInt, xSrcInt + 1 > sourceMat.getCols() - 1 ? xSrcInt : xSrcInt + 1);
                double q11 = sourceMat.getValue(ySrcInt + 1 > sourceMat.getCols() - 1 ? ySrcInt : ySrcInt + 1, xSrcInt);
                double q21 = sourceMat.getValue(ySrcInt + 1 > sourceMat.getCols() - 1 ? ySrcInt : ySrcInt + 1, xSrcInt + 1 > sourceMat.getCols() - 1 ? xSrcInt : xSrcInt + 1);
                double r1 = TerrainTileUtil.lerp(q11, q21, xt);
                double r2 = TerrainTileUtil.lerp(q12, q22, xt);
                double value = TerrainTileUtil.lerp(r2, r1, yt);
                targetMat.setValue(y, x, value);
            }
        }
    }

    private static double lerp(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    private static byte[] getRange(byte[] data, int index, int count) {
        byte[] result = new byte[count];
        System.arraycopy(data, index, result, 0, count);
        return result;
    }
}

