/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.generator;

import cn.hutool.core.thread.NamedThreadFactory;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.TileTransform;
import com.geoway.adf.gis.tile.meta.YAxis;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.dgt.tile.constant.MergeModeEnum;
import com.geoway.dgt.tile.constant.StorageTypeEnum;
import com.geoway.dgt.tile.constant.TerrainTileVersionEnum;
import com.geoway.dgt.tile.constant.TransparentStateEnum;
import com.geoway.dgt.tile.dto.TileStorageInfo;
import com.geoway.dgt.tile.terrain.TerrainSliceParam;
import com.geoway.dgt.tile.terrain.param.DemValueMatch;
import com.geoway.dgt.tile.terrain.param.Mat;
import com.geoway.dgt.tile.terrain.param.TerrainTileInfo;
import com.geoway.dgt.tile.util.TerrainTileUtil;
import com.geoway.dgt.tile.util.TileTaskHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTerrainTileGenerator {
    protected Consumer<String> msgCallBack = null;
    protected Supplier<Boolean> abortedCallback = null;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected int tileCount = 1;
    private boolean finish = false;
    private boolean hasException = false;
    protected int samplePerTile = 33;
    protected Float demMaxValue = null;
    protected Float demMinValue = null;
    protected List<Integer> lstInterNodataValue = null;
    protected List<ITileDataSource> lstInterDataSource = null;
    protected List<ITileDataset> lstInterReader = null;
    protected List<TileSchema> lstInterSchemas = null;
    protected List<List<Integer>> lstInterLevels = null;
    protected List<DemValueMatch> lstDemValueMatch = null;
    protected MergeModeEnum mergeMode = MergeModeEnum.NewFirst;
    protected double invalidData = 0.0;
    protected int currentTileCol = -1;
    protected int currentTileRow = -1;
    protected int currentTileLevel = -1;
    protected TerrainSliceParam tileParameter = null;
    protected TileSchema tileSchema = null;
    protected String maskWkt = "";
    protected ITileDataSource dataSource = null;
    protected ITileDataset tileReader = null;
    protected ITileDataSource writeDataSource = null;
    protected ITileDataset tileInfoWriter = null;
    private final SysParamsService sysParamsService = (SysParamsService)SpringContextUtil.getBean(SysParamsService.class);
    private final DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
    private List<String> canDeleteKeys = new ArrayList<String>();
    private Map<String, Mat> caches = new HashMap<String, Mat>(0);
    private final int maxCacheSize = 400;
    private int canDeleteCacheSize = 0;

    public void setTileParameter(TerrainSliceParam tileParameter) {
        this.tileParameter = tileParameter;
        this.tileSchema = TileSchema.TerrainV20;
        TileStorageInfo tileStorageInfo = tileParameter.getStorageInfo();
        DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case MongoDB: {
                DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                this.dataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                this.dataSource.connect();
                this.tileReader = this.dataSource.getDataset(tileStorageInfo.getDatasetName());
                this.writeDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                this.writeDataSource.connect();
                this.tileInfoWriter = this.writeDataSource.getDataset(tileStorageInfo.getDatasetName());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u683c\u5f0f\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTile(int level, MapExtent updateExtent, Consumer<String> msgCallback, Supplier<Boolean> abortedCallback) {
        this.abortedCallback = abortedCallback;
        this.msgCallBack = msgCallback;
        TileStorageInfo tileStorageInfo = this.tileParameter.getStorageInfo();
        if (tileStorageInfo.getInvalidData() != null) {
            this.invalidData = tileStorageInfo.getInvalidData();
        }
        this.readSysParams();
        try {
            this.msgCallBack.accept(String.format("\u5b50\u4efb\u52a1\u8303\u56f4\uff1a%s", this.getMapExtentWkt(updateExtent)));
            this.log.debug(String.format("\u5b50\u4efb\u52a1\u8303\u56f4\uff1a%s", this.getMapExtentWkt(updateExtent)));
            boolean bl = this.handleTile(level, updateExtent);
            return bl;
        }
        catch (Exception e) {
            msgCallback.accept(e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dataSource.close();
            this.writeDataSource.close();
            if (this.lstInterDataSource != null) {
                for (ITileDataSource interDataSource : this.lstInterDataSource) {
                    interDataSource.close();
                }
            }
        }
    }

    private void readSysParams() {
        this.lstDemValueMatch = new ArrayList<DemValueMatch>();
        ArrayList<TileStorageInfo> interpolateSourceList = new ArrayList<TileStorageInfo>();
        this.demMaxValue = Float.valueOf(9999.0f);
        this.demMinValue = Float.valueOf(-9999.0f);
        try {
            SysParamGroupDTO sysParamGroup = this.sysParamsService.getGroupDetail("TerrainSlice");
            if (sysParamGroup != null && sysParamGroup.getParams() != null) {
                for (SysParamDTO sysParam : sysParamGroup.getParams()) {
                    String[] connects;
                    if ("DemMaxValue".equals(sysParam.getKey())) {
                        this.demMaxValue = Float.valueOf(Float.parseFloat(sysParam.getValue()));
                    }
                    if ("DemMinValue".equals(sysParam.getKey())) {
                        this.demMinValue = Float.valueOf(Float.parseFloat(sysParam.getValue()));
                    }
                    if ("DEMValueMap".equals(sysParam.getKey())) {
                        String[] itemList;
                        for (String item : itemList = sysParam.getValue().split(";")) {
                            DemValueMatch valueMatch = new DemValueMatch();
                            String[] values = item.split(":");
                            valueMatch.setStartValue(Double.parseDouble(values[0]));
                            valueMatch.setEndValue(Double.parseDouble(values[1]));
                            valueMatch.setMatchValue(Double.parseDouble(values[2]));
                            this.lstDemValueMatch.add(valueMatch);
                        }
                    }
                    if (!"InterpolatedSources".equals(sysParam.getKey())) continue;
                    for (String connect : connects = sysParam.getValue().split(";")) {
                        TileStorageInfo interTileStorageInfo = new TileStorageInfo();
                        String[] items = connect.split("\\|");
                        if (connect.toLowerCase(Locale.ROOT).contains(".mbtiles)")) {
                            interTileStorageInfo.setStorageType(StorageTypeEnum.MBTiles.getValue());
                            interTileStorageInfo.setStoragePath(items[0]);
                        } else {
                            interTileStorageInfo.setStorageType(StorageTypeEnum.MongoDB.getValue());
                            String datasetId = items[0];
                            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
                            interTileStorageInfo.setDbKey(datasetDTO.getDataSource().getKey());
                            interTileStorageInfo.setDatasetName(datasetDTO.getName());
                        }
                        interTileStorageInfo.setInvalidData(Double.parseDouble(items[1]));
                        interpolateSourceList.add(interTileStorageInfo);
                    }
                }
            }
            this.lstInterNodataValue = new ArrayList<Integer>();
            this.lstInterLevels = new ArrayList<List<Integer>>();
            this.lstInterSchemas = new ArrayList<TileSchema>();
            this.lstInterReader = new ArrayList<ITileDataset>();
            this.lstInterDataSource = new ArrayList<ITileDataSource>();
            for (TileStorageInfo InterStorage : interpolateSourceList) {
                DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
                MongoTileDataSource interDataSource = null;
                ITileDataset interTileReader = null;
                switch (InterStorage.getStorageTypeEnum()) {
                    case MongoDB: {
                        DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(InterStorage.getDbKey());
                        interDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                        interDataSource.connect();
                        interTileReader = interDataSource.getDataset(InterStorage.getDatasetName());
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u683c\u5f0f\uff01");
                    }
                }
                this.lstInterDataSource.add((ITileDataSource)interDataSource);
                this.lstInterReader.add(interTileReader);
                this.lstInterSchemas.add(interTileReader.getTileMeta().getTileSchema());
                this.lstInterLevels.add(interTileReader.getTileMeta().getLevels());
                this.lstInterNodataValue.add((int)InterStorage.getInvalidData().doubleValue());
            }
        }
        catch (Exception e) {
            this.msgCallBack.accept("\u5730\u5f62\u5207\u7247\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff01" + e.getMessage());
            this.log.error("\u5730\u5f62\u5207\u7247\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)this.tileParameter.getMaskFilePath())) {
            this.maskWkt = WorkspaceUtil.readLocalFileGeometry((String)this.tileParameter.getMaskFilePath()).toWkt();
        }
    }

    private boolean handleTile(final int level, MapExtent updateExtent) {
        block6: {
            RefObject refTileRange = new RefObject();
            if (!this.isNeedHandleTile(level, updateExtent, (RefObject<TileRange>)refTileRange)) {
                return true;
            }
            TileRange tileRange = (TileRange)refTileRange.get();
            final int startRow = tileRange.getFirstRow();
            final int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
            final int startCol = tileRange.getFirstCol();
            final int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
            final ArrayBlockingQueue imageInfos = new ArrayBlockingQueue(20);
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 1, 5000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("terrain-tile-pool", false), new ThreadPoolExecutor.AbortPolicy());
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        block5: for (int row = startRow; row <= endRow; row += BaseTerrainTileGenerator.this.tileCount) {
                            if (BaseTerrainTileGenerator.this.abortedCallback.get().booleanValue()) {
                                break;
                            }
                            RefObject refYMin = new RefObject();
                            RefObject refYMax = new RefObject();
                            RefObject refRowTileCount = new RefObject();
                            BaseTerrainTileGenerator.this.getSuperTileRowInfo(row, endRow, level, (RefObject<Double>)refYMin, (RefObject<Double>)refYMax, (RefObject<Integer>)refRowTileCount);
                            int rowTileCount = (Integer)refRowTileCount.get();
                            double ymin = (Double)refYMin.get();
                            double ymax = (Double)refYMax.get();
                            if (rowTileCount <= 0) {
                                BaseTerrainTileGenerator.this.msgCallBack.accept("\u884c\u957f\u4e3a0\uff01");
                                continue;
                            }
                            for (int col = startCol; col <= endCol && !BaseTerrainTileGenerator.this.abortedCallback.get().booleanValue(); col += BaseTerrainTileGenerator.this.tileCount) {
                                RefObject refXMin = new RefObject();
                                RefObject refXMax = new RefObject();
                                RefObject refColTileCount = new RefObject();
                                BaseTerrainTileGenerator.this.getSuperTileColInfo(col, endCol, level, (RefObject<Double>)refXMin, (RefObject<Double>)refXMax, (RefObject<Integer>)refColTileCount);
                                int colTileCount = (Integer)refColTileCount.get();
                                double xmin = (Double)refXMin.get();
                                double xmax = (Double)refXMax.get();
                                if (colTileCount <= 0) {
                                    BaseTerrainTileGenerator.this.msgCallBack.accept("\u5217\u5bbd\u4e3a0\uff01");
                                    continue;
                                }
                                MapExtent extent = new MapExtent();
                                extent.setMinX(BigDecimal.valueOf(xmin));
                                extent.setMaxX(BigDecimal.valueOf(xmax));
                                extent.setMinY(BigDecimal.valueOf(ymin));
                                extent.setMaxY(BigDecimal.valueOf(ymax));
                                if (BaseTerrainTileGenerator.this.abortedCallback.get().booleanValue()) continue block5;
                                TerrainTileInfo multiImage = BaseTerrainTileGenerator.this.createMultiTileImage(extent, colTileCount, rowTileCount, level, col, row);
                                if (multiImage == null) {
                                    BaseTerrainTileGenerator.this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u7b2c%d-%d\u884c%d-%d\u5217\u751f\u6210\u56fe\u7247\u4e3a\u7a7a\u3002", level, row, row + rowTileCount - 1, col, col + colTileCount - 1));
                                    continue;
                                }
                                imageInfos.put(multiImage);
                            }
                        }
                    }
                    catch (Exception e) {
                        BaseTerrainTileGenerator.this.hasException = true;
                        BaseTerrainTileGenerator.this.msgCallBack.accept(e.getMessage());
                        BaseTerrainTileGenerator.this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        BaseTerrainTileGenerator.this.finish = true;
                    }
                }
            });
            do {
                try {
                    if (imageInfos.size() > 0) {
                        TerrainTileInfo tileInfo = (TerrainTileInfo)((Object)imageInfos.take());
                        this.tileInfoWriter.writeTile((TileData)tileInfo, true);
                    }
                }
                catch (Exception e) {
                    this.log.error("\u5199\u74e6\u7247\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    this.hasException = true;
                    this.msgCallBack.accept("\u5199\u74e6\u7247\u5f02\u5e38\uff1a" + e.getMessage());
                }
                if (this.abortedCallback.get().booleanValue()) break block6;
            } while (imageInfos.size() != 0 || !this.finish);
            executorService.shutdown();
        }
        if (this.abortedCallback.get().booleanValue() || this.hasException) {
            return false;
        }
        this.msgCallBack.accept(String.format("\u7ed3\u675f\u521b\u5efa\u7b2c%d\u7ea7\u74e6\u7247\u7f13\u5b58", level));
        return true;
    }

    protected boolean isNeedHandleTile(int level, MapExtent updateExtent, RefObject<TileRange> refTileRange) {
        int bundleStartRow;
        int bundleEndRow;
        int bundleStartCol;
        TileRange tileRange = TileTransform.worldToTile((MapExtent)updateExtent, (int)level, (TileSchema)this.tileSchema);
        refTileRange.set((Object)tileRange);
        boolean handledTileCount = false;
        int totalTileCount = 0;
        int startRow = tileRange.getFirstRow();
        int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
        int startCol = tileRange.getFirstCol();
        int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
        totalTileCount = tileRange.getRowCount() * tileRange.getColCount();
        String sourceWkt = this.maskWkt;
        if (StringUtil.isEmptyOrWhiteSpace((String)sourceWkt)) {
            sourceWkt = this.getMapExtentWkt(this.tileParameter.getSliceExtent());
        }
        MapExtent mapExtent = new MapExtent();
        mapExtent.setMinX(BigDecimal.valueOf(Math.max(this.tileParameter.getSliceExtent().getMinX().doubleValue(), updateExtent.getMinX().doubleValue())));
        mapExtent.setMaxX(BigDecimal.valueOf(Math.min(this.tileParameter.getSliceExtent().getMaxX().doubleValue(), updateExtent.getMaxX().doubleValue())));
        mapExtent.setMinY(BigDecimal.valueOf(Math.max(this.tileParameter.getSliceExtent().getMinY().doubleValue(), updateExtent.getMinY().doubleValue())));
        mapExtent.setMaxY(BigDecimal.valueOf(Math.min(this.tileParameter.getSliceExtent().getMaxY().doubleValue(), updateExtent.getMaxY().doubleValue())));
        String extentWkt = this.getMapExtentWkt(mapExtent);
        if (!this.isIntersect(sourceWkt, extentWkt)) {
            this.msgCallBack.accept(sourceWkt);
            this.msgCallBack.accept(extentWkt);
            this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u8303\u56f4\u4e0e\u591a\u8fb9\u5f62\u533a\u57df\u4e0d\u76f8\u4ea4\uff0c\u76f4\u63a5\u8df3\u8fc7\u3002", level));
            return false;
        }
        int tilePreCount = TileTaskHelper.getTilePreCount(tileRange);
        int bundleEndCol = endCol / tilePreCount;
        int count = (bundleEndCol - (bundleStartCol = startCol / tilePreCount) + 1) * ((bundleEndRow = endRow / tilePreCount) - (bundleStartRow = startRow / tilePreCount) + 1);
        if (count != 1) {
            this.msgCallBack.accept(String.format("\u5207\u7247\u8303\u56f4(%s)\u8de8\u8d8a\u591a\u4e2aBundle\u6587\u4ef6\u8303\u56f4\u3002", this.getMapExtentWkt(updateExtent)));
        }
        if (updateExtent.getMinX().equals(updateExtent.getMaxX())) {
            this.msgCallBack.accept(String.format("\u7b2c%d\u7ea7\u7684\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u5207\u7247\u4efb\u52a1\u3002", level));
            return false;
        }
        return true;
    }

    protected TerrainTileInfo createMultiTileImage(MapExtent mapExt, int colCount, int rowCount, int level, int startCol, int startRow) {
        this.currentTileCol = startCol;
        this.currentTileRow = startRow;
        this.currentTileLevel = level;
        MapExtent extent = TileTaskHelper.getTileExtent(this.tileSchema, level, startRow, startCol);
        List<Float> values = this.getValues(extent, this.samplePerTile, level, startCol, startRow);
        TransparentStateEnum transparent = TerrainTileUtil.getTransparentState(values, (int)this.invalidData);
        TerrainTileInfo tileInfo = new TerrainTileInfo();
        tileInfo.setLevel(level);
        tileInfo.setRow(startRow);
        tileInfo.setCol(startCol);
        tileInfo.setValues(values);
        tileInfo.setVersion(TerrainTileVersionEnum.V20);
        tileInfo.setTransparent(transparent);
        tileInfo = this.mergeTile(tileInfo);
        if (this.lstInterReader != null && this.lstInterReader.size() != 0) {
            tileInfo = this.interpolateTile(tileInfo);
        }
        tileInfo.setData(TerrainTileUtil.convertToTileInfoBytes(TerrainTileVersionEnum.V20, tileInfo.getValues()));
        return tileInfo;
    }

    protected List<Float> getValues(MapExtent extent, int samplesPerTile, int level, int startCol, int startRow) {
        return null;
    }

    protected boolean isIntersect(String sourceShapeWkt, String anotherShapeWkt) {
        IGeometry sourceGeo = GeometryFunc.createGeometry((String)sourceShapeWkt);
        IGeometry anotherGeo = GeometryFunc.createGeometry((String)anotherShapeWkt);
        return sourceGeo.intersects(anotherGeo);
    }

    protected String getMapExtentWkt(MapExtent mapExtent) {
        return String.format("POLYGON((%s %s,%s %s,%s %s,%s %s,%s %s))", mapExtent.getMinX(), mapExtent.getMinY(), mapExtent.getMinX(), mapExtent.getMaxY(), mapExtent.getMaxX(), mapExtent.getMaxY(), mapExtent.getMaxX(), mapExtent.getMinY(), mapExtent.getMinX(), mapExtent.getMinY());
    }

    private TerrainTileInfo mergeTile(TerrainTileInfo newInfo) {
        TileData oldInfo = null;
        TerrainTileInfo srcInfo = null;
        TerrainTileInfo updateInfo = null;
        TransparentStateEnum newState = newInfo.getTransparent();
        switch (this.mergeMode) {
            case NewFirst: {
                if (newState == TransparentStateEnum.NotTransparent) {
                    return newInfo;
                }
                oldInfo = this.tileReader.getTile(newInfo.getLevel(), newInfo.getRow(), newInfo.getCol());
                if (oldInfo == null) {
                    return newInfo;
                }
                srcInfo = new TerrainTileInfo(oldInfo, TerrainTileVersionEnum.V20);
                updateInfo = newInfo;
                break;
            }
            case OldFirst: {
                oldInfo = this.tileReader.getTile(newInfo.getLevel(), newInfo.getRow(), newInfo.getCol());
                if (oldInfo == null) {
                    return newInfo;
                }
                srcInfo = newInfo;
                updateInfo = new TerrainTileInfo(oldInfo, TerrainTileVersionEnum.V20);
                break;
            }
        }
        List<Float> combineValues = TerrainTileUtil.combineTileInfo(srcInfo.getValues(), updateInfo.getValues(), (int)this.invalidData, (int)this.invalidData);
        newInfo.setValues(combineValues);
        newInfo.setTransparent(TerrainTileUtil.getTransparentState(combineValues, (int)this.invalidData));
        return newInfo;
    }

    private void getSuperTileColInfo(int col, int maxCol, int levelId, RefObject<Double> xmin, RefObject<Double> xmax, RefObject<Integer> colTileCount) {
        if (col + this.tileCount < maxCol + 1) {
            colTileCount.set((Object)this.tileCount);
        } else {
            colTileCount.set((Object)(maxCol - col + 1));
        }
        TileRange tileRange = new TileRange(col, 0, ((Integer)colTileCount.get()).intValue(), 1);
        MapExtent extent = TileTransform.tileToWorld((TileRange)tileRange, (int)levelId, (TileSchema)this.tileSchema);
        xmin.set((Object)extent.getMinX().doubleValue());
        xmax.set((Object)extent.getMaxX().doubleValue());
    }

    private void getSuperTileRowInfo(int row, int maxRow, int levelId, RefObject<Double> ymin, RefObject<Double> ymax, RefObject<Integer> rowTileCount) {
        if (row + this.tileCount < maxRow + 1) {
            rowTileCount.set((Object)this.tileCount);
        } else {
            rowTileCount.set((Object)(maxRow - row + 1));
        }
        TileRange tileRange = new TileRange(0, row, 0, ((Integer)rowTileCount.get()).intValue());
        MapExtent extent = TileTransform.tileToWorld((TileRange)tileRange, (int)levelId, (TileSchema)this.tileSchema);
        ymin.set((Object)extent.getMinY().doubleValue());
        ymax.set((Object)extent.getMaxY().doubleValue());
    }

    private TerrainTileInfo interpolateTile(TerrainTileInfo info) {
        TransparentStateEnum state = info.getTransparent();
        if (state == TransparentStateEnum.NotTransparent) {
            return info;
        }
        ITileDataset tileReader = null;
        List<Integer> levels = null;
        TileData tileInfo = null;
        Mat tempMat = null;
        Mat sourceMat = null;
        List<Object> subFourMats = new ArrayList();
        tempMat = this.getFromCache(info.getLevel(), info.getRow(), info.getCol());
        if (tempMat != null) {
            sourceMat = new Mat(info.getValues());
            sourceMat = TerrainTileUtil.combineTileInfo(sourceMat, tempMat, (int)this.invalidData);
            info.setValues(sourceMat.getValues());
            info.setTransparent(TerrainTileUtil.getTransparentState(info.getValues(), (int)this.invalidData));
            return info;
        }
        for (int i = 0; i < this.lstInterReader.size(); ++i) {
            tileReader = this.lstInterReader.get(i);
            levels = this.lstInterLevels.get(i);
            if (!levels.contains(info.getLevel()) || (tileInfo = tileReader.getTile(info.getLevel(), info.getRow(), info.getCol())) == null) continue;
            info.setValues(TerrainTileUtil.combineTileInfo(info.getValues(), TerrainTileUtil.getValues(TerrainTileVersionEnum.V20, tileInfo.getData()), (int)this.invalidData, this.lstInterNodataValue.get(i)));
            info.setTransparent(TerrainTileUtil.getTransparentState(info.getValues(), this.lstInterNodataValue.get(i)));
            return info;
        }
        TileRange tileRange = new TileRange(info.getCol(), info.getRow());
        MapExtent mapExtent = TileTransform.tileToWorld((TileRange)tileRange, (int)info.getLevel(), (TileSchema)this.tileSchema);
        MapExtent extent = new MapExtent();
        extent.setMinX(BigDecimal.valueOf(mapExtent.getMinX().doubleValue() + 1.0E-10));
        extent.setMinY(BigDecimal.valueOf(mapExtent.getMinY().doubleValue() + 1.0E-10));
        extent.setMaxX(BigDecimal.valueOf(mapExtent.getMaxX().doubleValue() - 1.0E-10));
        extent.setMaxY(BigDecimal.valueOf(mapExtent.getMaxY().doubleValue() - 1.0E-10));
        for (int i = 0; i < this.lstInterReader.size(); ++i) {
            tileReader = this.lstInterReader.get(i);
            levels = this.lstInterLevels.get(i);
            levels = new ArrayList<Integer>(levels);
            levels.sort((o1, o2) -> o2 - o1);
            for (int level : levels) {
                if (level >= info.getLevel()) continue;
                tileRange = TileTransform.worldToTile((MapExtent)extent, (int)level, (TileSchema)this.lstInterSchemas.get(i));
                tempMat = this.getFromCache(level, tileRange.getFirstRow(), tileRange.getFirstCol());
                if (tempMat == null) {
                    tileInfo = tileReader.getTile(level, tileRange.getFirstRow(), tileRange.getFirstCol());
                    if (tileInfo == null) continue;
                    tempMat = new Mat(TerrainTileUtil.getValues(TerrainTileVersionEnum.V20, tileInfo.getData()));
                    subFourMats = TerrainTileUtil.spiltOne2Four(tempMat);
                    this.add2Cache((Mat)subFourMats.get(0), level + 1, tileRange.getFirstRow() * 2, tileRange.getFirstCol() * 2);
                    this.add2Cache((Mat)subFourMats.get(1), level + 1, tileRange.getFirstRow() * 2, tileRange.getFirstCol() * 2 + 1);
                    this.add2Cache((Mat)subFourMats.get(2), level + 1, tileRange.getFirstRow() * 2 + 1, tileRange.getFirstCol() * 2);
                    this.add2Cache((Mat)subFourMats.get(3), level + 1, tileRange.getFirstRow() * 2 + 1, tileRange.getFirstCol() * 2 + 1);
                }
                for (int interLevel = level + 1; interLevel <= info.getLevel(); ++interLevel) {
                    tileRange = TileTransform.worldToTile((MapExtent)extent, (int)interLevel, (TileSchema)this.lstInterSchemas.get(i));
                    tempMat = this.getFromCache(interLevel, tileRange.getFirstRow(), tileRange.getFirstCol());
                    if (interLevel == info.getLevel()) {
                        sourceMat = new Mat(info.getValues());
                        if (tempMat != null) {
                            sourceMat = TerrainTileUtil.combineTileInfo(sourceMat, tempMat, (int)this.invalidData);
                        }
                        info.setValues(sourceMat.getValues());
                        info.setTransparent(TerrainTileUtil.getTransparentState(info.getValues(), (int)this.invalidData));
                        return info;
                    }
                    try {
                        subFourMats = TerrainTileUtil.spiltOne2Four(tempMat);
                    }
                    catch (Exception e) {
                        this.msgCallBack.accept(e.getMessage());
                        this.msgCallBack.accept("\u8bf7\u68c0\u67e5\u63d2\u503c\u6e90\uff1a" + tileRange.getFirstRow() + "_" + tileRange.getFirstCol() + "_" + interLevel);
                    }
                    this.add2Cache((Mat)subFourMats.get(0), interLevel + 1, tileRange.getFirstRow() * 2, tileRange.getFirstCol() * 2);
                    this.add2Cache((Mat)subFourMats.get(1), interLevel + 1, tileRange.getFirstRow() * 2, tileRange.getFirstCol() * 2 + 1);
                    this.add2Cache((Mat)subFourMats.get(2), interLevel + 1, tileRange.getFirstRow() * 2 + 1, tileRange.getFirstCol() * 2);
                    this.add2Cache((Mat)subFourMats.get(3), interLevel + 1, tileRange.getFirstRow() * 2 + 1, tileRange.getFirstCol() * 2 + 1);
                }
            }
        }
        return info;
    }

    public boolean downSizingTile(final int level, final MapExtent updateExtent, final Consumer<String> msgCallback, final Supplier<Boolean> abortedCallback) {
        block5: {
            this.msgCallBack = msgCallback;
            TileStorageInfo tileStorageInfo = this.tileParameter.getStorageInfo();
            if (tileStorageInfo.getInvalidData() != null) {
                this.invalidData = tileStorageInfo.getInvalidData();
            }
            this.readSysParams();
            this.msgCallBack.accept(String.format("\u5b50\u4efb\u52a1\u8303\u56f4\uff1a%s", this.getMapExtentWkt(updateExtent)));
            final ArrayBlockingQueue imageInfos = new ArrayBlockingQueue(20);
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 1, 5000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("feature-entity-pool", false), new ThreadPoolExecutor.AbortPolicy());
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RefObject refTileRange = new RefObject();
                        if (!BaseTerrainTileGenerator.this.isNeedHandleTile(level, updateExtent, (RefObject<TileRange>)refTileRange)) {
                            return;
                        }
                        TileRange tileRange = (TileRange)refTileRange.get();
                        for (int rowNum = tileRange.getFirstRow(); rowNum < tileRange.getFirstRow() + tileRange.getRowCount(); ++rowNum) {
                            for (int colNumber = tileRange.getFirstCol(); colNumber < tileRange.getFirstCol() + tileRange.getColCount() && !((Boolean)abortedCallback.get()).booleanValue(); ++colNumber) {
                                TileData tileInfo = BaseTerrainTileGenerator.this.merge4To1Tile(BaseTerrainTileGenerator.this.tileReader, level, rowNum, colNumber);
                                if (tileInfo == null) continue;
                                imageInfos.put(tileInfo);
                            }
                        }
                    }
                    catch (Exception e) {
                        BaseTerrainTileGenerator.this.hasException = true;
                        msgCallback.accept(e.getMessage());
                        BaseTerrainTileGenerator.this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        BaseTerrainTileGenerator.this.finish = true;
                    }
                }
            });
            do {
                try {
                    String label;
                    TileData tileInfo = (TileData)imageInfos.take();
                    boolean success = this.tileInfoWriter.writeTile(tileInfo, true);
                    String string = label = success ? "\u6210\u529f" : "\u5931\u8d25";
                    if (!success) {
                        this.msgCallBack.accept("Row:" + tileInfo.getRow() + " Col:" + tileInfo.getCol() + label);
                        this.hasException = true;
                    }
                }
                catch (Exception e) {
                    this.log.error("\u7f29\u7f16\u74e6\u7247\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                    this.hasException = true;
                    msgCallback.accept("\u7f29\u7f16\u74e6\u7247\u5931\u8d25\uff1a" + e.getMessage());
                }
                if (abortedCallback.get().booleanValue()) break block5;
            } while (imageInfos.size() != 0 || !this.finish);
            executorService.shutdown();
        }
        this.msgCallBack.accept("\u7f29\u7f16\u7ed3\u675f\uff01");
        return abortedCallback.get() == false && !this.hasException;
    }

    private TileData merge4To1Tile(ITileDataset reader, int level, int row, int col) {
        TerrainTileInfo tileInfo1 = null;
        TerrainTileInfo tileInfo2 = null;
        TerrainTileInfo tileInfo3 = null;
        TerrainTileInfo tileInfo4 = null;
        if (this.tileSchema.getYaxis() == YAxis.OSM) {
            tileInfo1 = this.getTerrainTileInfo(reader, level + 1, row * 2, col * 2);
            tileInfo2 = this.getTerrainTileInfo(reader, level + 1, row * 2, col * 2 + 1);
            tileInfo3 = this.getTerrainTileInfo(reader, level + 1, row * 2 + 1, col * 2);
            tileInfo4 = this.getTerrainTileInfo(reader, level + 1, row * 2 + 1, col * 2 + 1);
        } else {
            tileInfo1 = this.getTerrainTileInfo(reader, level + 1, row * 2 + 1, col * 2);
            tileInfo2 = this.getTerrainTileInfo(reader, level + 1, row * 2 + 1, col * 2 + 1);
            tileInfo3 = this.getTerrainTileInfo(reader, level + 1, row * 2, col * 2);
            tileInfo4 = this.getTerrainTileInfo(reader, level + 1, row * 2, col * 2 + 1);
        }
        if (tileInfo1.getTransparent() == TransparentStateEnum.Transparent && tileInfo2.getTransparent() == TransparentStateEnum.Transparent && tileInfo3.getTransparent() == TransparentStateEnum.Transparent && tileInfo4.getTransparent() == TransparentStateEnum.Transparent) {
            return null;
        }
        tileInfo1 = this.interpolateTile(tileInfo1);
        tileInfo2 = this.interpolateTile(tileInfo2);
        tileInfo3 = this.interpolateTile(tileInfo3);
        tileInfo4 = this.interpolateTile(tileInfo4);
        ArrayList<Float> mergeValues = new ArrayList<Float>();
        for (int i = 0; i < 4 * this.samplePerTile * this.samplePerTile; ++i) {
            mergeValues.add(Float.valueOf((float)this.invalidData));
        }
        int index = 0;
        int mergeIndex = 0;
        for (int i = 0; i < this.samplePerTile; ++i) {
            for (int j = 0; j < this.samplePerTile; ++j) {
                index = i * this.samplePerTile + j;
                mergeIndex = i * 2 * this.samplePerTile + j;
                mergeValues.set(mergeIndex, tileInfo1.getValues().get(index));
                mergeIndex = i * 2 * this.samplePerTile + this.samplePerTile + j;
                mergeValues.set(mergeIndex, tileInfo2.getValues().get(index));
                mergeIndex = (i + this.samplePerTile) * 2 * this.samplePerTile + j;
                mergeValues.set(mergeIndex, tileInfo3.getValues().get(index));
                mergeIndex = (i + this.samplePerTile) * 2 * this.samplePerTile + this.samplePerTile + j;
                mergeValues.set(mergeIndex, tileInfo4.getValues().get(index));
            }
        }
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < this.samplePerTile * this.samplePerTile; ++i) {
            result.add(Float.valueOf((float)this.invalidData));
        }
        int topInx = 0;
        int downInx = 0;
        int centerInx = 0;
        int leftInx = 0;
        int rightInx = 0;
        for (int i = 0; i < this.samplePerTile; ++i) {
            for (int j = 0; j < this.samplePerTile; ++j) {
                index = i * this.samplePerTile + j;
                if (i == 0 && j == 0) {
                    result.set(index, (Float)mergeValues.get(0));
                    continue;
                }
                if (i == 0 && j == this.samplePerTile - 1) {
                    result.set(index, (Float)mergeValues.get(2 * this.samplePerTile - 1));
                    continue;
                }
                if (i == this.samplePerTile - 1 && j == 0) {
                    result.set(index, (Float)mergeValues.get(2 * this.samplePerTile * (2 * this.samplePerTile - 1)));
                    continue;
                }
                if (i == this.samplePerTile - 1 && j == this.samplePerTile - 1) {
                    result.set(index, (Float)mergeValues.get(mergeValues.size() - 1));
                    continue;
                }
                if (j == 0) {
                    topInx = (2 * i - 1) * 2 * this.samplePerTile;
                    downInx = (2 * i + 1) * 2 * this.samplePerTile;
                    centerInx = 2 * i * 2 * this.samplePerTile;
                    result.set(index, Float.valueOf((((Float)mergeValues.get(topInx)).floatValue() + ((Float)mergeValues.get(downInx)).floatValue() + ((Float)mergeValues.get(centerInx)).floatValue()) / 3.0f));
                    continue;
                }
                if (j == this.samplePerTile - 1) {
                    topInx = (2 * i - 1) * 2 * this.samplePerTile + 2 * this.samplePerTile - 1;
                    downInx = (2 * i + 1) * 2 * this.samplePerTile + 2 * this.samplePerTile - 1;
                    centerInx = 2 * i * 2 * this.samplePerTile + 2 * this.samplePerTile - 1;
                    result.set(index, Float.valueOf((((Float)mergeValues.get(topInx)).floatValue() + ((Float)mergeValues.get(downInx)).floatValue() + ((Float)mergeValues.get(centerInx)).floatValue()) / 3.0f));
                    continue;
                }
                if (i == 0) {
                    leftInx = 2 * j - 1;
                    rightInx = 2 * j + 1;
                    centerInx = 2 * j;
                    result.set(index, Float.valueOf((((Float)mergeValues.get(leftInx)).floatValue() + ((Float)mergeValues.get(rightInx)).floatValue() + ((Float)mergeValues.get(centerInx)).floatValue()) / 3.0f));
                    continue;
                }
                if (i == this.samplePerTile - 1) {
                    leftInx = (2 * this.samplePerTile - 1) * 2 * this.samplePerTile + 2 * j - 1;
                    rightInx = (2 * this.samplePerTile - 1) * 2 * this.samplePerTile + 2 * j + 1;
                    centerInx = (2 * this.samplePerTile - 1) * 2 * this.samplePerTile + 2 * j;
                    result.set(index, Float.valueOf((((Float)mergeValues.get(leftInx)).floatValue() + ((Float)mergeValues.get(rightInx)).floatValue() + ((Float)mergeValues.get(centerInx)).floatValue()) / 3.0f));
                    continue;
                }
                topInx = (2 * i - 1) * 2 * this.samplePerTile + 2 * j;
                downInx = (2 * i + 1) * 2 * this.samplePerTile + 2 * j;
                centerInx = 2 * i * 2 * this.samplePerTile + 2 * j;
                leftInx = 2 * i * 2 * this.samplePerTile + 2 * j - 1;
                rightInx = 2 * i * 2 * this.samplePerTile + 2 * j + 1;
                result.set(index, Float.valueOf((((Float)mergeValues.get(leftInx)).floatValue() + ((Float)mergeValues.get(rightInx)).floatValue() + ((Float)mergeValues.get(centerInx)).floatValue() + ((Float)mergeValues.get(topInx)).floatValue() + ((Float)mergeValues.get(downInx)).floatValue()) / 5.0f));
            }
        }
        TerrainTileInfo resultTileIndo = new TerrainTileInfo();
        resultTileIndo.setFormat("\u5730\u5f62");
        resultTileIndo.setCol(col);
        resultTileIndo.setLevel(level);
        resultTileIndo.setRow(row);
        resultTileIndo.setData(TerrainTileUtil.convertToTileInfoBytes(TerrainTileVersionEnum.V20, result));
        return resultTileIndo;
    }

    private TerrainTileInfo getTerrainTileInfo(ITileDataset reader, int level, int row, int col) {
        TileData tileInfo = reader.getTile(level, row, col);
        TerrainTileInfo terrainTileInfo = new TerrainTileInfo();
        terrainTileInfo.setLevel(level);
        terrainTileInfo.setRow(row);
        terrainTileInfo.setCol(col);
        terrainTileInfo.setVersion(TerrainTileVersionEnum.V20);
        if (tileInfo == null) {
            terrainTileInfo.setTransparent(TransparentStateEnum.Transparent);
            ArrayList<Float> values = new ArrayList<Float>();
            for (int i = 0; i < this.samplePerTile * this.samplePerTile; ++i) {
                values.add(Float.valueOf((float)this.invalidData));
            }
            terrainTileInfo.setValues(values);
        } else {
            List<Float> values = TerrainTileUtil.getValues(TerrainTileVersionEnum.V20, tileInfo.getData());
            terrainTileInfo.setTransparent(TerrainTileUtil.getTransparentState(values, (int)this.invalidData));
            terrainTileInfo.setValues(values);
        }
        return terrainTileInfo;
    }

    private String getKey(int level, int row, int col) {
        return String.format("%d_%d_%d", level, row, col);
    }

    protected Mat getFromCache(int level, int row, int col) {
        String key = this.getKey(level, row, col);
        return this.caches.get(key);
    }

    protected void add2Cache(Mat mat, int level, int row, int col) {
        String key = this.getKey(level, row, col);
        if (this.caches.containsKey(key)) {
            return;
        }
        if (level != this.currentTileLevel) {
            this.caches.put(key, mat);
            return;
        }
        this.caches.put(key, mat);
        this.canDeleteKeys.add(key);
        if (this.canDeleteCacheSize < 400) {
            ++this.canDeleteCacheSize;
        } else {
            Mat temp = this.caches.get(this.canDeleteKeys.get(0));
            this.caches.remove(this.canDeleteKeys.get(0));
            this.canDeleteKeys.remove(0);
        }
    }
}

