/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain.generator;

import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.dgt.tile.terrain.generator.TerrainTileSampleBase;
import com.geoway.dgt.tile.terrain.param.BlockPixelInfo;
import com.geoway.dgt.tile.terrain.param.TerrainRasterInfo;
import com.geoway.dgt.tile.terrain.param.VertexCollection;
import java.math.BigDecimal;
import java.util.function.Consumer;

public class TerrainTileSampleOneByBatch
extends TerrainTileSampleBase {
    private final double expandRatio = 0.5;
    private VertexCollection vertexCollection;

    @Override
    public double[][] getValues(TerrainRasterInfo terrainRasterInfo, MapExtent extent, SpatialReference tileSpatialRef, int samplesPerTile, int level, int startCol, int startRow, Consumer<String> msgCallback) {
        this.msgCallBack = msgCallback;
        MapExtent copyEnvelope = new MapExtent();
        copyEnvelope.setMinX(BigDecimal.valueOf(extent.getMinX().doubleValue() - extent.getWidth().doubleValue() * 0.5));
        copyEnvelope.setMaxY(BigDecimal.valueOf(extent.getMaxY().doubleValue() + extent.getHeight().doubleValue() * 0.5));
        copyEnvelope.setMaxX(BigDecimal.valueOf(extent.getMaxX().doubleValue() + extent.getWidth().doubleValue() * 0.5));
        copyEnvelope.setMinY(BigDecimal.valueOf(extent.getMinY().doubleValue() - extent.getHeight().doubleValue() * 0.5));
        BlockPixelInfo blockPixel = this.getBlockPixelInfo(terrainRasterInfo, copyEnvelope, tileSpatialRef, level, startCol, startRow);
        if (!terrainRasterInfo.getSameSpatialReference().booleanValue()) {
            this.vertexCollection = this.createCollection(extent, samplesPerTile);
            SpatialReference dataSpatialReference = new SpatialReference();
            dataSpatialReference.setWkt(terrainRasterInfo.getRasterDataset().getRasterInfo().getSpatialReferenceSystem().getWkt());
            this.project(this.vertexCollection, tileSpatialRef, dataSpatialReference);
        }
        double[][] result = new double[samplesPerTile][samplesPerTile];
        double scaleFactor = 1.0 / (double)(samplesPerTile - 1);
        double widthPerPixel = scaleFactor * extent.getWidth().doubleValue();
        double heightPerPixel = scaleFactor * extent.getHeight().doubleValue();
        double currentX = 0.0;
        double currentY = 0.0;
        double currentZ = 0.0;
        RefObject edgeX = new RefObject();
        edgeX.set((Object)0);
        RefObject edgeY = new RefObject();
        edgeY.set((Object)0);
        for (int pixelRow = 0; pixelRow < samplesPerTile; ++pixelRow) {
            currentY = extent.getMaxY().doubleValue() - (double)pixelRow * heightPerPixel;
            for (int pixelCol = 0; pixelCol < samplesPerTile; ++pixelCol) {
                currentX = extent.getMinX().doubleValue() + (double)pixelCol * widthPerPixel;
                if (!terrainRasterInfo.getSameSpatialReference().booleanValue()) {
                    int inx = pixelRow * samplesPerTile + pixelCol;
                    currentX = this.vertexCollection.x[inx];
                    currentY = this.vertexCollection.y[inx];
                    currentZ = this.vertexCollection.z[inx];
                }
                result[pixelRow][pixelCol] = this.geoToPixelPoint(terrainRasterInfo.getRasterDataset().getRaster().GetGeoTransform(), currentX, currentY, (RefObject<Integer>)edgeX, (RefObject<Integer>)edgeY) == false ? this.invalidData : ((Integer)edgeX.get() >= terrainRasterInfo.getRasterDataset().getRasterInfo().getWidth() || (Integer)edgeY.get() >= terrainRasterInfo.getRasterDataset().getRasterInfo().getHeight() ? this.invalidData.doubleValue() : blockPixel.getValues()[(Integer)edgeX.get() - blockPixel.getStartRow()][(Integer)edgeY.get() - blockPixel.getStartCol()].doubleValue());
            }
        }
        result = this.handleSpecialValues(result, samplesPerTile, terrainRasterInfo);
        return result;
    }
}

