/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.image.document;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.dgt.tile.image.document.DxLayer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class DxDocument {
    private List<DxLayer> dxLayers;
    private MapExtent mapExtent;

    public void save(String path) {
        String jsonString = JSONObject.toJSONString((Object)this);
        BufferedWriter writer = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                boolean bl = file.delete();
            }
            boolean isCreate = file.createNewFile();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), 1024);
            writer.write(jsonString);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5730\u56fe\u6587\u6863\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public void addLayer(DxLayer layer) {
        if (this.dxLayers == null) {
            this.dxLayers = new ArrayList<DxLayer>();
        }
        this.dxLayers.add(layer);
    }

    public DxDocument() {
    }

    public DxDocument(String path) {
        BufferedReader reader = null;
        FileInputStream inputStream = null;
        try {
            File file = new File(path);
            inputStream = new FileInputStream(file);
            String charset = FileUtil.getFileCharset((File)file);
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, charset));
            StringBuilder jsonString = new StringBuilder();
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                jsonString.append(tempString);
            }
            DxDocument document = (DxDocument)JSONObject.parseObject((String)jsonString.toString(), DxDocument.class);
            this.dxLayers = document.getDxLayers();
            this.mapExtent = document.getMapExtent();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u5730\u56fe\u6587\u6863\u8bfb\u53d6\u5931\u8d25\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream, reader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream, reader});
    }

    public List<DxLayer> getDxLayers() {
        return this.dxLayers;
    }

    public MapExtent getMapExtent() {
        return this.mapExtent;
    }

    public void setDxLayers(List<DxLayer> dxLayers) {
        this.dxLayers = dxLayers;
    }

    public void setMapExtent(MapExtent mapExtent) {
        this.mapExtent = mapExtent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DxDocument)) {
            return false;
        }
        DxDocument other = (DxDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DxLayer> this$dxLayers = this.getDxLayers();
        List<DxLayer> other$dxLayers = other.getDxLayers();
        if (this$dxLayers == null ? other$dxLayers != null : !((Object)this$dxLayers).equals(other$dxLayers)) {
            return false;
        }
        MapExtent this$mapExtent = this.getMapExtent();
        MapExtent other$mapExtent = other.getMapExtent();
        return !(this$mapExtent == null ? other$mapExtent != null : !this$mapExtent.equals(other$mapExtent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DxDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DxLayer> $dxLayers = this.getDxLayers();
        result = result * 59 + ($dxLayers == null ? 43 : ((Object)$dxLayers).hashCode());
        MapExtent $mapExtent = this.getMapExtent();
        result = result * 59 + ($mapExtent == null ? 43 : $mapExtent.hashCode());
        return result;
    }

    public String toString() {
        return "DxDocument(dxLayers=" + this.getDxLayers() + ", mapExtent=" + this.getMapExtent() + ")";
    }
}

