/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.terrain;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.dgt.frame.constants.TaskLogLevelEnum;
import com.geoway.dgt.frame.tools.IToolParam;
import com.geoway.dgt.frame.tools.ToolBase;
import com.geoway.dgt.frame.tools.model.DataParam;
import com.geoway.dgt.frame.tools.model.DataStripingResult;
import com.geoway.dgt.frame.tools.model.ExecuteParam;
import com.geoway.dgt.frame.tools.model.ExecuteResult;
import com.geoway.dgt.tile.constant.TileTypeEnum;
import com.geoway.dgt.tile.dto.TileStorageInfo;
import com.geoway.dgt.tile.terrain.TerrainSliceParam;
import com.geoway.dgt.tile.terrain.generator.GDALTerrainTileGenerator;
import com.geoway.dgt.tile.util.GDALSpatialOperator;
import com.geoway.dgt.tile.util.TileTaskHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TerrainSliceTool
extends ToolBase {
    private final DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);

    public void batchDataStriping(DataParam batchInputData, DataParam batchOutputData, IToolParam toolParam, Consumer<DataStripingResult> oneDataCallback) {
        TerrainSliceParam terrainSliceParam = (TerrainSliceParam)toolParam;
        TileSchema tileSchema = TileSchema.TerrainV20;
        if (!StringUtil.isEmptyOrWhiteSpace((String)terrainSliceParam.getTileSchemaPath())) {
            tileSchema = new TileSchema();
        }
        switch (terrainSliceParam.getTileExtentType()) {
            case Full: {
                terrainSliceParam.setSliceExtent(GDALSpatialOperator.getRasterEnvelope(terrainSliceParam.getRasterList(), tileSchema));
                break;
            }
            case Custom: {
                terrainSliceParam.setSliceExtent(GDALSpatialOperator.getShpMapExtent(terrainSliceParam.getMaskFilePath(), tileSchema));
                break;
            }
        }
        this.updateTileMeta(tileSchema, terrainSliceParam);
        for (int level = terrainSliceParam.getToLevel().intValue(); level >= terrainSliceParam.getFromLevel(); --level) {
            List<MapExtent> tileExtents = TileTaskHelper.parseToBundleMultiPartExtent(tileSchema, level, terrainSliceParam.getSliceExtent());
            int priority = level + 50;
            int extentId = 1;
            for (MapExtent updateExtent : tileExtents) {
                DataStripingResult item = new DataStripingResult();
                item.setName(String.format("\u7b2c%d\u7ea7-\u533a\u57df%d", level, extentId));
                item.setPriority(priority);
                TerrainSliceParam executeParam = new TerrainSliceParam();
                executeParam.setSliceExtent(updateExtent);
                executeParam.setFromLevel(level);
                executeParam.setToLevel(level);
                executeParam.setStorageInfo(terrainSliceParam.getStorageInfo());
                executeParam.setMergeModel(terrainSliceParam.getMergeModel());
                executeParam.setExtentType(terrainSliceParam.getExtentType());
                executeParam.setMaskFilePath(terrainSliceParam.getMaskFilePath());
                executeParam.setTileSchemaPath(terrainSliceParam.getTileSchemaPath());
                executeParam.setRasterList(terrainSliceParam.getRasterList());
                if (level == terrainSliceParam.getToLevel()) {
                    executeParam.setSliceType(TileTypeEnum.Update.getValue());
                } else {
                    executeParam.setSliceType(TileTypeEnum.DownSizing.getValue());
                }
                item.setToolExecuteParam((IToolParam)executeParam);
                oneDataCallback.accept(item);
                ++extentId;
            }
        }
    }

    public ExecuteParam buildExecuteParam(DataParam inputData, DataParam outputData, IToolParam toolParam) {
        ExecuteParam executeParam = new ExecuteParam();
        executeParam.setToolExecuteParam(toolParam);
        return executeParam;
    }

    public ExecuteResult execute(DataParam inputDataParam, DataParam outputDataParam, IToolParam executeParam) {
        ExecuteResult executeResult = new ExecuteResult();
        try {
            TerrainSliceParam terrainSliceParam = (TerrainSliceParam)executeParam;
            boolean success = false;
            GDALTerrainTileGenerator tileGenerator = new GDALTerrainTileGenerator();
            tileGenerator.setTileParameter(terrainSliceParam);
            switch (terrainSliceParam.getTileTypeEnum()) {
                case Update: {
                    success = tileGenerator.updateTile(terrainSliceParam.getFromLevel(), terrainSliceParam.getSliceExtent(), arg_0 -> ((TerrainSliceTool)this).invokeExcuteLog(arg_0), () -> ((TerrainSliceTool)this).isAborted());
                    break;
                }
                case DownSizing: {
                    success = tileGenerator.downSizingTile(terrainSliceParam.getFromLevel(), terrainSliceParam.getSliceExtent(), arg_0 -> ((TerrainSliceTool)this).invokeExcuteLog(arg_0), () -> ((TerrainSliceTool)this).isAborted());
                    break;
                }
            }
            if (!success) {
                executeResult.setSuccess(Boolean.valueOf(false));
                executeResult.setErrorMessage("\u5207\u7247\u5931\u8d25");
            }
        }
        catch (Exception e) {
            executeResult.setSuccess(Boolean.valueOf(false));
            executeResult.setErrorMessage(e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
            this.invokeExcuteLog(e.getMessage(), TaskLogLevelEnum.Error);
        }
        return executeResult;
    }

    private void updateTileMeta(TileSchema tileSchema, TerrainSliceParam terrainSliceParam) {
        TileMeta tileMeta;
        TileStorageInfo tileStorageInfo = terrainSliceParam.getStorageInfo();
        MongoTileDataSource dataSource = null;
        ITileDataset tileReader = null;
        switch (tileStorageInfo.getStorageTypeEnum()) {
            case MongoDB: {
                DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(tileStorageInfo.getDbKey());
                dataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                dataSource.connect();
                tileReader = dataSource.getDataset(tileStorageInfo.getDatasetName());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u683c\u5f0f\uff01");
            }
        }
        TileMeta tileMeta2 = tileMeta = tileReader == null ? null : tileReader.getTileMeta();
        if (tileMeta == null) {
            tileMeta = new TileMeta();
            tileMeta.setName(tileStorageInfo.getDatasetName());
            tileMeta.setAliasName(tileStorageInfo.getDatasetName());
            tileMeta.setTileSchema(tileSchema);
            tileMeta.setTileType(TileType.TerrainTile);
            tileMeta.setDataFormat("\u5730\u5f62");
            tileMeta.setStartLevel(terrainSliceParam.getFromLevel());
            tileMeta.setEndLevel(terrainSliceParam.getToLevel());
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            for (int level = terrainSliceParam.getFromLevel().intValue(); level <= terrainSliceParam.getToLevel(); ++level) {
                levelList.add(level);
            }
            tileMeta.setLevels(levelList);
            tileMeta.setXmax(Double.valueOf(terrainSliceParam.getSliceExtent().getMaxX().doubleValue()));
            tileMeta.setXmin(Double.valueOf(terrainSliceParam.getSliceExtent().getMinX().doubleValue()));
            tileMeta.setYmax(Double.valueOf(terrainSliceParam.getSliceExtent().getMaxY().doubleValue()));
            tileMeta.setYmin(Double.valueOf(terrainSliceParam.getSliceExtent().getMinY().doubleValue()));
            dataSource.createDataset(tileMeta);
        } else {
            tileMeta.setStartLevel(Integer.valueOf(Math.min(tileMeta.getStartLevel(), terrainSliceParam.getFromLevel())));
            tileMeta.setEndLevel(Integer.valueOf(Math.max(tileMeta.getEndLevel(), terrainSliceParam.getToLevel())));
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            for (int level = tileMeta.getStartLevel().intValue(); level <= tileMeta.getEndLevel(); ++level) {
                levelList.add(level);
            }
            tileMeta.setLevels(levelList);
            tileMeta.setXmax(Double.valueOf(Math.max(tileMeta.getXmax(), terrainSliceParam.getSliceExtent().getMaxX().doubleValue())));
            tileMeta.setXmin(Double.valueOf(Math.min(tileMeta.getXmin(), terrainSliceParam.getSliceExtent().getMinX().doubleValue())));
            tileMeta.setYmax(Double.valueOf(Math.max(tileMeta.getYmax(), terrainSliceParam.getSliceExtent().getMaxY().doubleValue())));
            tileMeta.setYmin(Double.valueOf(Math.min(tileMeta.getYmin(), terrainSliceParam.getSliceExtent().getMinY().doubleValue())));
            tileReader.updateTileMeta(tileMeta);
        }
        dataSource.close();
    }
}

