/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.dgt.tile.util;

import com.geoway.dgt.tile.util.BitConverter;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressDataUsingDeflate(List<Short> pDataBuffer, int samplesPerTile) {
        if (pDataBuffer == null || pDataBuffer.size() == 0) {
            return new byte[0];
        }
        byte[] pData = new byte[samplesPerTile * samplesPerTile * 2];
        for (int m = 0; m < samplesPerTile; ++m) {
            for (int n = 0; n < samplesPerTile; ++n) {
                byte[] convert = BitConverter.short2bytes(pDataBuffer.get(m * samplesPerTile + n));
                for (int j = 0; j < 2; ++j) {
                    pData[(m * samplesPerTile + n) * 2 + j] = convert[j];
                }
            }
        }
        byte[] outPutByteArray = null;
        Deflater compress = new Deflater();
        compress.reset();
        compress.setInput(pData);
        compress.finish();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(pData.length);){
            byte[] buf = new byte[1024];
            while (!compress.finished()) {
                int i = compress.deflate(buf);
                bos.write(buf, 0, i);
            }
            outPutByteArray = bos.toByteArray();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            outPutByteArray = pData;
        }
        finally {
            compress.end();
        }
        return outPutByteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deCompressBytes(byte[] sourceByte) {
        byte[] outPutByteArray = null;
        Inflater decompress = new Inflater();
        decompress.reset();
        decompress.setInput(sourceByte);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(sourceByte.length);){
            byte[] buf = new byte[1024];
            while (!decompress.finished()) {
                int i = decompress.inflate(buf);
                bos.write(buf, 0, i);
            }
            outPutByteArray = bos.toByteArray();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            outPutByteArray = sourceByte;
        }
        finally {
            decompress.end();
        }
        return outPutByteArray;
    }
}

