/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DynamicTableNameInnerInterceptor
implements InnerInterceptor {
    private Map<String, TableNameHandler> tableNameHandlerMap;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        if (!InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    protected String changeTable(String sql) {
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        Objects.requireNonNull(names);
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                String value = name.getValue();
                TableNameHandler handler = (TableNameHandler)this.tableNameHandlerMap.get(value);
                if (handler != null) {
                    builder.append(handler.dynamicTableName(sql, value));
                } else {
                    builder.append(value);
                }
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        return builder.toString();
    }

    public Map<String, TableNameHandler> getTableNameHandlerMap() {
        return this.tableNameHandlerMap;
    }

    public void setTableNameHandlerMap(Map<String, TableNameHandler> tableNameHandlerMap) {
        this.tableNameHandlerMap = tableNameHandlerMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableNameInnerInterceptor)) {
            return false;
        }
        DynamicTableNameInnerInterceptor other = (DynamicTableNameInnerInterceptor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$tableNameHandlerMap = this.getTableNameHandlerMap();
        Map other$tableNameHandlerMap = other.getTableNameHandlerMap();
        return !(this$tableNameHandlerMap == null ? other$tableNameHandlerMap != null : !((Object)this$tableNameHandlerMap).equals(other$tableNameHandlerMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableNameInnerInterceptor;
    }

    public int hashCode() {
        int result = 1;
        Map $tableNameHandlerMap = this.getTableNameHandlerMap();
        result = result * 59 + ($tableNameHandlerMap == null ? 43 : ((Object)$tableNameHandlerMap).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicTableNameInnerInterceptor(tableNameHandlerMap=" + this.getTableNameHandlerMap() + ")";
    }

    public DynamicTableNameInnerInterceptor() {
    }

    public DynamicTableNameInnerInterceptor(Map<String, TableNameHandler> tableNameHandlerMap) {
        this.tableNameHandlerMap = tableNameHandlerMap;
    }

    public void setTableNameHandler(TableNameHandler tableNameHandler) {
        if (ObjectUtil.isEmpty((Object)this.tableNameHandlerMap)) {
            this.tableNameHandlerMap = new ConcurrentHashMap();
        }
        this.tableNameHandlerMap.put(tableNameHandler.getClass().getName(), tableNameHandler);
    }
}

