/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sample.component.websocket.config;

import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.common.util.JwtUtil;
import com.dji.sample.component.AuthInterceptor;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Component
public class AuthPrincipalHandler
extends DefaultHandshakeHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthPrincipalHandler.class);

    protected boolean isValidOrigin(ServerHttpRequest request) {
        if (request instanceof ServletServerHttpRequest) {
            HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
            String token = servletRequest.getParameter(AuthInterceptor.PARAM_TOKEN);
            if (!StringUtils.hasText((String)token)) {
                return false;
            }
            log.debug("token:" + token);
            Optional customClaim = JwtUtil.parseToken((String)token);
            if (customClaim.isEmpty()) {
                return false;
            }
            servletRequest.setAttribute(AuthInterceptor.TOKEN_CLAIM, customClaim.get());
            return true;
        }
        return false;
    }

    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        if (request instanceof ServletServerHttpRequest) {
            CustomClaim claim = (CustomClaim)((ServletServerHttpRequest)request).getServletRequest().getAttribute(AuthInterceptor.TOKEN_CLAIM);
            return () -> claim.getWorkspaceId() + "/" + claim.getUserType() + "/" + claim.getId();
        }
        return () -> null;
    }
}

