/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.config;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.airport.DroneAirportApp;
import com.geoway.fczx.airport.config.AirportServerConfig;
import com.geoway.fczx.airport.handler.AbstractResultEncoder;
import com.geoway.fczx.airport.handler.ResultReturnPointCut;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(basePackages={"com.geoway.fczx.airport"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={DroneAirportApp.class, AirportServerConfig.class})})
@MapperScan(value={"com.geoway.fczx.airport.dao"})
@EnableConfigurationProperties(value={ServerProperties.class})
public class AirportImportConfig {
    private static final Logger log = LoggerFactory.getLogger(AirportImportConfig.class);
    @Resource
    private ServerProperties properties;
    @Resource
    private AbstractResultEncoder resultEncoder;

    @PostConstruct
    public void init() {
        if (ObjectUtil.isEmpty((Object)System.getProperty("com.geoway.fczx.airport.drone-server-url"))) {
            String port = this.properties.getPort() == null ? "8080" : this.properties.getPort().toString();
            String path = this.properties.getServlet().getContextPath();
            if (!ObjectUtil.isNotEmpty((Object)path) || !path.startsWith("/")) {
                path = "/" + path;
            }
            String serverUrl = "http://127.0.0.1:".concat(port).concat(path);
            System.setProperty("com.geoway.fczx.airport.drone-server-url", serverUrl);
        }
    }

    @Bean
    public Pointcut resultReturnPointCut() {
        log.info("\u3010\u4e92\u8054\u8d2f\u901a\u3011\u56fd\u571f\u4e91-\u8702\u5de2\u667a\u5de1\u6210\u679c\u52a0\u5bc6\u56de\u4f20");
        ResultReturnPointCut returnPointCut = new ResultReturnPointCut();
        returnPointCut.setExpression("execution(* com.geoway.fczx.core.handler.mqtt.FileUploadHandler.doHandle(..)) ||execution(* com.geoway.fczx.core.handler.mqtt.DeviceReloadHandler.doHandle(..))");
        return returnPointCut;
    }

    @Bean
    public DefaultPointcutAdvisor resultReturnPointCutAdvisor() {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut(this.resultReturnPointCut());
        advisor.setAdvice((Advice)this.resultEncoder);
        return advisor;
    }
}

