/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.config;

import com.geoway.fczx.airport.data.property.AirportAccessProperties;
import com.geoway.fczx.airport.handler.RestErrorHandler;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class AirportServerConfig {
    private static final Logger log = LoggerFactory.getLogger(AirportServerConfig.class);
    @Resource
    private AirportAccessProperties accessProperties;

    @PostConstruct
    public void initAirportAccess() {
        if (this.accessProperties.getDroneServerUrl().isEmpty()) {
            throw new RuntimeException("\u672a\u77e5\u8702\u5de2\u667a\u5de1\u670d\u52a1\u5730\u5740\uff0c\u65e0\u6cd5\u542f\u52a8\u542f\u7528");
        }
        log.info("\u8702\u5de2\u667a\u5de1\u670d\u52a1\u5730\u5740:{}", (Object)this.accessProperties.getDroneServerUrl());
    }

    @Bean
    public RestTemplate airportApiRest() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new RestErrorHandler());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        return restTemplate;
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("OPTIONS");
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }
}

