/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.airport.data.AddTaskParam;
import com.geoway.fczx.airport.data.DroneStatus;
import com.geoway.fczx.airport.data.TaskResult;
import com.geoway.fczx.airport.data.response.HttpResponse;
import com.geoway.fczx.airport.service.AirportAccessService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u673a\u573a\u63a5\u5165\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/droneAirport"})
public class AirportAccessController {
    @Resource
    private AirportAccessService airportService;

    @Operation(summary="\u65e0\u4eba\u673a\u72b6\u6001\u83b7\u53d6")
    @ApiImplicitParam(name="deviceid", value="\u65e0\u4eba\u673a\u673a\u573a\u8bbe\u5907\u552f\u4e00id", required=true)
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/getDroneStatus"})
    public HttpResponse<DroneStatus> getDroneStatus(String deviceid) {
        return this.airportService.getDroneStatus(deviceid);
    }

    @Operation(summary="\u65e0\u4eba\u673a\u4efb\u52a1\u6dfb\u52a0")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/AddTask"})
    public HttpResponse<Object> addTask(@RequestBody AddTaskParam param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param, param.getBizidname(), param.getTasklist()})) {
            return this.airportService.addTask(param);
        }
        return HttpResponse.error("\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @Operation(summary="\u65e0\u4eba\u673a\u4efb\u52a1\u53d6\u6d88")
    @ApiImplicitParam(name="taskid", value="\u65e0\u4eba\u673a\u4efb\u52a1id", required=true)
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/cancelTask"})
    public HttpResponse<Object> cancelTask(String taskid, Boolean taskIsFlight) {
        return this.airportService.cancelTask(taskid, taskIsFlight);
    }

    @Operation(summary="\u65e0\u4eba\u673a\u4efb\u52a1\u8fdb\u5ea6", responses={@ApiResponse(responseCode="200", description="\u4efb\u52a1\u6267\u884c\u6210\u529f"), @ApiResponse(responseCode="201", description="\u5f85\u6267\u884c"), @ApiResponse(responseCode="202", description="\u4efb\u52a1\u6267\u884c\u4e2d"), @ApiResponse(responseCode="203", description="\u4efb\u52a1\u6267\u884c\u5b8c\u6210"), @ApiResponse(responseCode="204", description="\u4efb\u52a1\u53d6\u6d88"), @ApiResponse(responseCode="205", description="\u4efb\u52a1\u6267\u884c\u5931\u8d25"), @ApiResponse(responseCode="206", description="\u4efb\u52a1\u6682\u505c")})
    @ApiImplicitParam(name="taskid", value="\u65e0\u4eba\u673a\u4efb\u52a1id", required=true)
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/queryTaskStatus"})
    public HttpResponse<Object> queryTaskStatus(String taskid, Boolean taskIsFlight) {
        return this.airportService.queryTaskStatus(taskid, taskIsFlight);
    }

    @Operation(summary="\u65e0\u4eba\u673a\u6210\u679c\u83b7\u53d6", description="\u83b7\u53d6\u4efb\u52a1\u6210\u679c\u6570\u636e")
    @ApiImplicitParam(name="taskid", value="\u65e0\u4eba\u673a\u4efb\u52a1id", required=true)
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/getResult"})
    public HttpResponse<TaskResult> getResult(String taskid, Boolean taskIsFlight) {
        return this.airportService.getResult(taskid, taskIsFlight);
    }

    @ApiIgnore
    @Operation(summary="\u6210\u679c\u52a0\u5bc6\u6821\u9a8c\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objectKey", value="\u5b58\u50a8\u5bf9\u8c61key", required=true), @ApiImplicitParam(name="flag", value="\u662f\u5426\u7f13\u5b58", required=true)})
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/encodeResult"})
    public HttpResponse<Map<String, Object>> encodeResult(String objectKey, Boolean flag) {
        if (ObjectUtil.isEmpty((Object)flag)) {
            flag = true;
        }
        Map<String, Object> res = this.airportService.encodeResult(objectKey, BooleanUtil.isTrue((Boolean)flag));
        return HttpResponse.success(res);
    }

    @Operation(summary="\u65e0\u4eba\u673a\u6210\u679c\u83b7\u53d6", description="\u83b7\u53d6\u6210\u679c\u9644\u4ef6")
    @ApiImplicitParam(name="objectKey", value="\u5b58\u50a8\u5bf9\u8c61key", required=true)
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/encodeResult"})
    public void obtainEncodeResult(String objectKey, HttpServletResponse response) throws IOException {
        StringBuilder jym = new StringBuilder();
        byte[] res = this.airportService.obtainEncodeResult(objectKey, true, jym);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (res == null) {
            response.setContentType("application/json");
            response.setStatus(500);
            res = "\u83b7\u53d6\u52a0\u5bc6\u6210\u679c\u5931\u8d25".getBytes(StandardCharsets.UTF_8);
        } else {
            String fileName = FileUtil.getName((String)objectKey);
            response.setStatus(200);
            response.setContentType("application/force-download");
            response.setHeader("gtyjym", jym.toString());
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(fileName, "UTF-8"));
        }
        IoUtil.copy((InputStream)new ByteArrayInputStream(res), (OutputStream)response.getOutputStream());
    }
}

